package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ImportedModelName,
  Timestamp,
  ModelImportJobArn,
  ImportedModelArn,
  JobName
}
import scala.jdk.CollectionConverters._
final case class ModelImportJobSummary(
    jobArn: ModelImportJobArn,
    jobName: JobName,
    status: zio.aws.bedrock.model.ModelImportJobStatus,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent,
    importedModelArn: Optional[ImportedModelArn] = Optional.Absent,
    importedModelName: Optional[ImportedModelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary = {
    import ModelImportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary
      .builder()
      .jobArn(ModelImportJobArn.unwrap(jobArn): java.lang.String)
      .jobName(JobName.unwrap(jobName): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        importedModelArn.map(value =>
          ImportedModelArn.unwrap(value): java.lang.String
        )
      )(_.importedModelArn)
      .optionallyWith(
        importedModelName.map(value =>
          ImportedModelName.unwrap(value): java.lang.String
        )
      )(_.importedModelName)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly =
    zio.aws.bedrock.model.ModelImportJobSummary.wrap(buildAwsValue())
}
object ModelImportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelImportJobSummary =
      zio.aws.bedrock.model.ModelImportJobSummary(
        jobArn,
        jobName,
        status,
        lastModifiedTime.map(value => value),
        creationTime,
        endTime.map(value => value),
        importedModelArn.map(value => value),
        importedModelName.map(value => value)
      )
    def jobArn: ModelImportJobArn
    def jobName: JobName
    def status: zio.aws.bedrock.model.ModelImportJobStatus
    def lastModifiedTime: Optional[Timestamp]
    def creationTime: Timestamp
    def endTime: Optional[Timestamp]
    def importedModelArn: Optional[ImportedModelArn]
    def importedModelName: Optional[ImportedModelName]
    def getJobArn: ZIO[Any, Nothing, ModelImportJobArn] = ZIO.succeed(jobArn)
    def getJobName: ZIO[Any, Nothing, JobName] = ZIO.succeed(jobName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.ModelImportJobStatus] =
      ZIO.succeed(status)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getImportedModelArn: ZIO[Any, AwsError, ImportedModelArn] =
      AwsError.unwrapOptionField("importedModelArn", importedModelArn)
    def getImportedModelName: ZIO[Any, AwsError, ImportedModelName] =
      AwsError.unwrapOptionField("importedModelName", importedModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary
  ) extends zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly {
    override val jobArn: ModelImportJobArn =
      zio.aws.bedrock.model.primitives.ModelImportJobArn(impl.jobArn())
    override val jobName: JobName =
      zio.aws.bedrock.model.primitives.JobName(impl.jobName())
    override val status: zio.aws.bedrock.model.ModelImportJobStatus =
      zio.aws.bedrock.model.ModelImportJobStatus.wrap(impl.status())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val importedModelArn: Optional[ImportedModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelArn())
        .map(value => zio.aws.bedrock.model.primitives.ImportedModelArn(value))
    override val importedModelName: Optional[ImportedModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelName())
        .map(value => zio.aws.bedrock.model.primitives.ImportedModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary
  ): zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly = new Wrapper(impl)
}
