package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelInvocationJobInputDataConfig(
    s3InputDataConfig: Optional[
      zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig = {
    import ModelInvocationJobInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig
      .builder()
      .optionallyWith(s3InputDataConfig.map(value => value.buildAwsValue()))(
        _.s3InputDataConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly =
    zio.aws.bedrock.model.ModelInvocationJobInputDataConfig
      .wrap(buildAwsValue())
}
object ModelInvocationJobInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelInvocationJobInputDataConfig =
      zio.aws.bedrock.model.ModelInvocationJobInputDataConfig(
        s3InputDataConfig.map(value => value.asEditable)
      )
    def s3InputDataConfig: Optional[
      zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.ReadOnly
    ]
    def getS3InputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3InputDataConfig", s3InputDataConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig
  ) extends zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly {
    override val s3InputDataConfig: Optional[
      zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3InputDataConfig())
      .map(value =>
        zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig
  ): zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly =
    new Wrapper(impl)
}
