package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelInvocationJobOutputDataConfig(
    s3OutputDataConfig: Optional[
      zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig = {
    import ModelInvocationJobOutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig
      .builder()
      .optionallyWith(s3OutputDataConfig.map(value => value.buildAwsValue()))(
        _.s3OutputDataConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly =
    zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig
      .wrap(buildAwsValue())
}
object ModelInvocationJobOutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig =
      zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig(
        s3OutputDataConfig.map(value => value.asEditable)
      )
    def s3OutputDataConfig: Optional[
      zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.ReadOnly
    ]
    def getS3OutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3OutputDataConfig", s3OutputDataConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig
  ) extends zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly {
    override val s3OutputDataConfig: Optional[
      zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OutputDataConfig())
      .map(value =>
        zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig
  ): zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly =
    new Wrapper(impl)
}
