package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{AccountId, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelInvocationJobS3InputDataConfig(
    s3InputFormat: Optional[zio.aws.bedrock.model.S3InputFormat] =
      Optional.Absent,
    s3Uri: S3Uri,
    s3BucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3InputDataConfig = {
    import ModelInvocationJobS3InputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3InputDataConfig
      .builder()
      .optionallyWith(s3InputFormat.map(value => value.unwrap))(_.s3InputFormat)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        s3BucketOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.s3BucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.ReadOnly =
    zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig
      .wrap(buildAwsValue())
}
object ModelInvocationJobS3InputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3InputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig =
      zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig(
        s3InputFormat.map(value => value),
        s3Uri,
        s3BucketOwner.map(value => value)
      )
    def s3InputFormat: Optional[zio.aws.bedrock.model.S3InputFormat]
    def s3Uri: S3Uri
    def s3BucketOwner: Optional[AccountId]
    def getS3InputFormat
        : ZIO[Any, AwsError, zio.aws.bedrock.model.S3InputFormat] =
      AwsError.unwrapOptionField("s3InputFormat", s3InputFormat)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getS3BucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3InputDataConfig
  ) extends zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.ReadOnly {
    override val s3InputFormat: Optional[zio.aws.bedrock.model.S3InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3InputFormat())
        .map(value => zio.aws.bedrock.model.S3InputFormat.wrap(value))
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
    override val s3BucketOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.bedrock.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3InputDataConfig
  ): zio.aws.bedrock.model.ModelInvocationJobS3InputDataConfig.ReadOnly =
    new Wrapper(impl)
}
