package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{AccountId, KmsKeyId, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelInvocationJobS3OutputDataConfig(
    s3Uri: S3Uri,
    s3EncryptionKeyId: Optional[KmsKeyId] = Optional.Absent,
    s3BucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3OutputDataConfig = {
    import ModelInvocationJobS3OutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3OutputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        s3EncryptionKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.s3EncryptionKeyId)
      .optionallyWith(
        s3BucketOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.s3BucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.ReadOnly =
    zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig
      .wrap(buildAwsValue())
}
object ModelInvocationJobS3OutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3OutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig =
      zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig(
        s3Uri,
        s3EncryptionKeyId.map(value => value),
        s3BucketOwner.map(value => value)
      )
    def s3Uri: S3Uri
    def s3EncryptionKeyId: Optional[KmsKeyId]
    def s3BucketOwner: Optional[AccountId]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getS3EncryptionKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("s3EncryptionKeyId", s3EncryptionKeyId)
    def getS3BucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3OutputDataConfig
  ) extends zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
    override val s3EncryptionKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3EncryptionKeyId())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
    override val s3BucketOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.bedrock.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobS3OutputDataConfig
  ): zio.aws.bedrock.model.ModelInvocationJobS3OutputDataConfig.ReadOnly =
    new Wrapper(impl)
}
