package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ModelInvocationJobStatus {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus
}
object ModelInvocationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus
  ): zio.aws.bedrock.model.ModelInvocationJobStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.SUBMITTED =>
      val r = Submitted
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.PARTIALLY_COMPLETED =>
      val r = PartiallyCompleted
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.EXPIRED =>
      val r = Expired
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.VALIDATING =>
      val r = Validating
      r
    case software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.SCHEDULED =>
      val r = Scheduled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Submitted extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.SUBMITTED
  }
  case object InProgress
      extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.FAILED
  }
  case object Stopping extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.STOPPED
  }
  case object PartiallyCompleted
      extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.PARTIALLY_COMPLETED
  }
  case object Expired extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.EXPIRED
  }
  case object Validating
      extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.VALIDATING
  }
  case object Scheduled extends zio.aws.bedrock.model.ModelInvocationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelInvocationJobStatus.SCHEDULED
  }
}
