package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ModelModality {
  def unwrap: software.amazon.awssdk.services.bedrock.model.ModelModality
}
object ModelModality {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ModelModality
  ): zio.aws.bedrock.model.ModelModality = value match {
    case software.amazon.awssdk.services.bedrock.model.ModelModality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ModelModality.TEXT =>
      val r = TEXT
      r
    case software.amazon.awssdk.services.bedrock.model.ModelModality.IMAGE =>
      val r = IMAGE
      r
    case software.amazon.awssdk.services.bedrock.model.ModelModality.EMBEDDING =>
      val r = EMBEDDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.bedrock.model.ModelModality {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelModality =
      software.amazon.awssdk.services.bedrock.model.ModelModality.UNKNOWN_TO_SDK_VERSION
  }
  case object TEXT extends zio.aws.bedrock.model.ModelModality {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelModality =
      software.amazon.awssdk.services.bedrock.model.ModelModality.TEXT
  }
  case object IMAGE extends zio.aws.bedrock.model.ModelModality {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelModality =
      software.amazon.awssdk.services.bedrock.model.ModelModality.IMAGE
  }
  case object EMBEDDING extends zio.aws.bedrock.model.ModelModality {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelModality =
      software.amazon.awssdk.services.bedrock.model.ModelModality.EMBEDDING
  }
}
