package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OutputDataConfig(s3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.OutputDataConfig = {
    import OutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.OutputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.OutputDataConfig.ReadOnly =
    zio.aws.bedrock.model.OutputDataConfig.wrap(buildAwsValue())
}
object OutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.OutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.OutputDataConfig =
      zio.aws.bedrock.model.OutputDataConfig(s3Uri)
    def s3Uri: S3Uri
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.OutputDataConfig
  ) extends zio.aws.bedrock.model.OutputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.OutputDataConfig
  ): zio.aws.bedrock.model.OutputDataConfig.ReadOnly = new Wrapper(impl)
}
