package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ProvisionedModelStatus {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus
}
object ProvisionedModelStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus
  ): zio.aws.bedrock.model.ProvisionedModelStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.ProvisionedModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus =
      software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.bedrock.model.ProvisionedModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus =
      software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.CREATING
  }
  case object InService extends zio.aws.bedrock.model.ProvisionedModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus =
      software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.IN_SERVICE
  }
  case object Updating extends zio.aws.bedrock.model.ProvisionedModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus =
      software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.UPDATING
  }
  case object Failed extends zio.aws.bedrock.model.ProvisionedModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus =
      software.amazon.awssdk.services.bedrock.model.ProvisionedModelStatus.FAILED
  }
}
