package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutModelInvocationLoggingConfigurationRequest(
    loggingConfig: zio.aws.bedrock.model.LoggingConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest = {
    import PutModelInvocationLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest
      .builder()
      .loggingConfig(loggingConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest.ReadOnly =
    zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutModelInvocationLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest =
      zio.aws.bedrock.model
        .PutModelInvocationLoggingConfigurationRequest(loggingConfig.asEditable)
    def loggingConfig: zio.aws.bedrock.model.LoggingConfig.ReadOnly
    def getLoggingConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.LoggingConfig.ReadOnly] =
      ZIO.succeed(loggingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest
  ) extends zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest.ReadOnly {
    override val loggingConfig: zio.aws.bedrock.model.LoggingConfig.ReadOnly =
      zio.aws.bedrock.model.LoggingConfig.wrap(impl.loggingConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest
  ): zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
