package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{KeyPrefix, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Config(
    bucketName: BucketName,
    keyPrefix: Optional[KeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.S3Config = {
    import S3Config.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.S3Config
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        keyPrefix.map(value => KeyPrefix.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.S3Config.ReadOnly =
    zio.aws.bedrock.model.S3Config.wrap(buildAwsValue())
}
object S3Config {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.bedrock.model.S3Config] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.S3Config =
      zio.aws.bedrock.model.S3Config(bucketName, keyPrefix.map(value => value))
    def bucketName: BucketName
    def keyPrefix: Optional[KeyPrefix]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getKeyPrefix: ZIO[Any, AwsError, KeyPrefix] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.S3Config
  ) extends zio.aws.bedrock.model.S3Config.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.bedrock.model.primitives.BucketName(impl.bucketName())
    override val keyPrefix: Optional[KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefix())
      .map(value => zio.aws.bedrock.model.primitives.KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.S3Config
  ): zio.aws.bedrock.model.S3Config.ReadOnly = new Wrapper(impl)
}
