package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3DataSource(s3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.S3DataSource = {
    import S3DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.S3DataSource
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.S3DataSource.ReadOnly =
    zio.aws.bedrock.model.S3DataSource.wrap(buildAwsValue())
}
object S3DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.S3DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.S3DataSource =
      zio.aws.bedrock.model.S3DataSource(s3Uri)
    def s3Uri: S3Uri
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.S3DataSource
  ) extends zio.aws.bedrock.model.S3DataSource.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.S3DataSource
  ): zio.aws.bedrock.model.S3DataSource.ReadOnly = new Wrapper(impl)
}
