package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait S3InputFormat {
  def unwrap: software.amazon.awssdk.services.bedrock.model.S3InputFormat
}
object S3InputFormat {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.S3InputFormat
  ): zio.aws.bedrock.model.S3InputFormat = value match {
    case software.amazon.awssdk.services.bedrock.model.S3InputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.S3InputFormat.JSONL =>
      val r = JSONL
      r
  }
  case object unknownToSdkVersion extends zio.aws.bedrock.model.S3InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.S3InputFormat =
      software.amazon.awssdk.services.bedrock.model.S3InputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object JSONL extends zio.aws.bedrock.model.S3InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.S3InputFormat =
      software.amazon.awssdk.services.bedrock.model.S3InputFormat.JSONL
  }
}
