package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopEvaluationJobRequest(
    jobIdentifier: EvaluationJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest = {
    import StopEvaluationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest
      .builder()
      .jobIdentifier(
        EvaluationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.StopEvaluationJobRequest.ReadOnly =
    zio.aws.bedrock.model.StopEvaluationJobRequest.wrap(buildAwsValue())
}
object StopEvaluationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.StopEvaluationJobRequest =
      zio.aws.bedrock.model.StopEvaluationJobRequest(jobIdentifier)
    def jobIdentifier: EvaluationJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, EvaluationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest
  ) extends zio.aws.bedrock.model.StopEvaluationJobRequest.ReadOnly {
    override val jobIdentifier: EvaluationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .EvaluationJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.StopEvaluationJobRequest
  ): zio.aws.bedrock.model.StopEvaluationJobRequest.ReadOnly = new Wrapper(impl)
}
