package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelCustomizationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopModelCustomizationJobRequest(
    jobIdentifier: ModelCustomizationJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest = {
    import StopModelCustomizationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest
      .builder()
      .jobIdentifier(
        ModelCustomizationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.StopModelCustomizationJobRequest.ReadOnly =
    zio.aws.bedrock.model.StopModelCustomizationJobRequest.wrap(buildAwsValue())
}
object StopModelCustomizationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.StopModelCustomizationJobRequest =
      zio.aws.bedrock.model.StopModelCustomizationJobRequest(jobIdentifier)
    def jobIdentifier: ModelCustomizationJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, ModelCustomizationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest
  ) extends zio.aws.bedrock.model.StopModelCustomizationJobRequest.ReadOnly {
    override val jobIdentifier: ModelCustomizationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .ModelCustomizationJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.StopModelCustomizationJobRequest
  ): zio.aws.bedrock.model.StopModelCustomizationJobRequest.ReadOnly =
    new Wrapper(impl)
}
