package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelInvocationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopModelInvocationJobRequest(
    jobIdentifier: ModelInvocationJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest = {
    import StopModelInvocationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest
      .builder()
      .jobIdentifier(
        ModelInvocationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.StopModelInvocationJobRequest.ReadOnly =
    zio.aws.bedrock.model.StopModelInvocationJobRequest.wrap(buildAwsValue())
}
object StopModelInvocationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.StopModelInvocationJobRequest =
      zio.aws.bedrock.model.StopModelInvocationJobRequest(jobIdentifier)
    def jobIdentifier: ModelInvocationJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, ModelInvocationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest
  ) extends zio.aws.bedrock.model.StopModelInvocationJobRequest.ReadOnly {
    override val jobIdentifier: ModelInvocationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .ModelInvocationJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.StopModelInvocationJobRequest
  ): zio.aws.bedrock.model.StopModelInvocationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
