package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.TaggableResourcesArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: TaggableResourcesArn,
    tags: Iterable[zio.aws.bedrock.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.TagResourceRequest
      .builder()
      .resourceARN(TaggableResourcesArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.TagResourceRequest.ReadOnly =
    zio.aws.bedrock.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.TagResourceRequest =
      zio.aws.bedrock.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: TaggableResourcesArn
    def tags: List[zio.aws.bedrock.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, TaggableResourcesArn] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.TagResourceRequest
  ) extends zio.aws.bedrock.model.TagResourceRequest.ReadOnly {
    override val resourceARN: TaggableResourcesArn =
      zio.aws.bedrock.model.primitives.TaggableResourcesArn(impl.resourceARN())
    override val tags: List[zio.aws.bedrock.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.TagResourceRequest
  ): zio.aws.bedrock.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
