package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TrainingDataConfig(s3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.TrainingDataConfig = {
    import TrainingDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.TrainingDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.TrainingDataConfig.ReadOnly =
    zio.aws.bedrock.model.TrainingDataConfig.wrap(buildAwsValue())
}
object TrainingDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.TrainingDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.TrainingDataConfig =
      zio.aws.bedrock.model.TrainingDataConfig(s3Uri)
    def s3Uri: S3Uri
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.TrainingDataConfig
  ) extends zio.aws.bedrock.model.TrainingDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.TrainingDataConfig
  ): zio.aws.bedrock.model.TrainingDataConfig.ReadOnly = new Wrapper(impl)
}
