package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.MetricFloat
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrainingMetrics(
    trainingLoss: Optional[MetricFloat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.TrainingMetrics = {
    import TrainingMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.TrainingMetrics
      .builder()
      .optionallyWith(
        trainingLoss.map(value => MetricFloat.unwrap(value): java.lang.Float)
      )(_.trainingLoss)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.TrainingMetrics.ReadOnly =
    zio.aws.bedrock.model.TrainingMetrics.wrap(buildAwsValue())
}
object TrainingMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.TrainingMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.TrainingMetrics =
      zio.aws.bedrock.model.TrainingMetrics(trainingLoss.map(value => value))
    def trainingLoss: Optional[MetricFloat]
    def getTrainingLoss: ZIO[Any, AwsError, MetricFloat] =
      AwsError.unwrapOptionField("trainingLoss", trainingLoss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.TrainingMetrics
  ) extends zio.aws.bedrock.model.TrainingMetrics.ReadOnly {
    override val trainingLoss: Optional[MetricFloat] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingLoss())
      .map(value => zio.aws.bedrock.model.primitives.MetricFloat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.TrainingMetrics
  ): zio.aws.bedrock.model.TrainingMetrics.ReadOnly = new Wrapper(impl)
}
