package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{TagKey, TaggableResourcesArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: TaggableResourcesArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.UntagResourceRequest
      .builder()
      .resourceARN(TaggableResourcesArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.UntagResourceRequest.ReadOnly =
    zio.aws.bedrock.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.UntagResourceRequest =
      zio.aws.bedrock.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: TaggableResourcesArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, TaggableResourcesArn] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.UntagResourceRequest
  ) extends zio.aws.bedrock.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: TaggableResourcesArn =
      zio.aws.bedrock.model.primitives.TaggableResourcesArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.UntagResourceRequest
  ): zio.aws.bedrock.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
