package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  Timestamp,
  GuardrailDraftVersion,
  GuardrailArn,
  GuardrailId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateGuardrailResponse(
    guardrailId: GuardrailId,
    guardrailArn: GuardrailArn,
    version: GuardrailDraftVersion,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.UpdateGuardrailResponse = {
    import UpdateGuardrailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.UpdateGuardrailResponse
      .builder()
      .guardrailId(GuardrailId.unwrap(guardrailId): java.lang.String)
      .guardrailArn(GuardrailArn.unwrap(guardrailArn): java.lang.String)
      .version(GuardrailDraftVersion.unwrap(version): java.lang.String)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly =
    zio.aws.bedrock.model.UpdateGuardrailResponse.wrap(buildAwsValue())
}
object UpdateGuardrailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.UpdateGuardrailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.UpdateGuardrailResponse =
      zio.aws.bedrock.model.UpdateGuardrailResponse(
        guardrailId,
        guardrailArn,
        version,
        updatedAt
      )
    def guardrailId: GuardrailId
    def guardrailArn: GuardrailArn
    def version: GuardrailDraftVersion
    def updatedAt: Timestamp
    def getGuardrailId: ZIO[Any, Nothing, GuardrailId] =
      ZIO.succeed(guardrailId)
    def getGuardrailArn: ZIO[Any, Nothing, GuardrailArn] =
      ZIO.succeed(guardrailArn)
    def getVersion: ZIO[Any, Nothing, GuardrailDraftVersion] =
      ZIO.succeed(version)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.UpdateGuardrailResponse
  ) extends zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly {
    override val guardrailId: GuardrailId =
      zio.aws.bedrock.model.primitives.GuardrailId(impl.guardrailId())
    override val guardrailArn: GuardrailArn =
      zio.aws.bedrock.model.primitives.GuardrailArn(impl.guardrailArn())
    override val version: GuardrailDraftVersion =
      zio.aws.bedrock.model.primitives.GuardrailDraftVersion(impl.version())
    override val updatedAt: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.UpdateGuardrailResponse
  ): zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly = new Wrapper(impl)
}
