package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  ModelIdentifier,
  ProvisionedModelName,
  ProvisionedModelId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProvisionedModelThroughputRequest(
    provisionedModelId: ProvisionedModelId,
    desiredProvisionedModelName: Optional[ProvisionedModelName] =
      Optional.Absent,
    desiredModelId: Optional[ModelIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest = {
    import UpdateProvisionedModelThroughputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest
      .builder()
      .provisionedModelId(
        ProvisionedModelId.unwrap(provisionedModelId): java.lang.String
      )
      .optionallyWith(
        desiredProvisionedModelName.map(value =>
          ProvisionedModelName.unwrap(value): java.lang.String
        )
      )(_.desiredProvisionedModelName)
      .optionallyWith(
        desiredModelId.map(value =>
          ModelIdentifier.unwrap(value): java.lang.String
        )
      )(_.desiredModelId)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest.ReadOnly =
    zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest
      .wrap(buildAwsValue())
}
object UpdateProvisionedModelThroughputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest =
      zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest(
        provisionedModelId,
        desiredProvisionedModelName.map(value => value),
        desiredModelId.map(value => value)
      )
    def provisionedModelId: ProvisionedModelId
    def desiredProvisionedModelName: Optional[ProvisionedModelName]
    def desiredModelId: Optional[ModelIdentifier]
    def getProvisionedModelId: ZIO[Any, Nothing, ProvisionedModelId] =
      ZIO.succeed(provisionedModelId)
    def getDesiredProvisionedModelName
        : ZIO[Any, AwsError, ProvisionedModelName] = AwsError.unwrapOptionField(
      "desiredProvisionedModelName",
      desiredProvisionedModelName
    )
    def getDesiredModelId: ZIO[Any, AwsError, ModelIdentifier] =
      AwsError.unwrapOptionField("desiredModelId", desiredModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest
  ) extends zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest.ReadOnly {
    override val provisionedModelId: ProvisionedModelId =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelId(impl.provisionedModelId())
    override val desiredProvisionedModelName: Optional[ProvisionedModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredProvisionedModelName())
        .map(value =>
          zio.aws.bedrock.model.primitives.ProvisionedModelName(value)
        )
    override val desiredModelId: Optional[ModelIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredModelId())
        .map(value => zio.aws.bedrock.model.primitives.ModelIdentifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.UpdateProvisionedModelThroughputRequest
  ): zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest.ReadOnly =
    new Wrapper(impl)
}
