package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ValidationDataConfig(
    validators: Iterable[zio.aws.bedrock.model.Validator]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ValidationDataConfig = {
    import ValidationDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ValidationDataConfig
      .builder()
      .validators(validators.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ValidationDataConfig.ReadOnly =
    zio.aws.bedrock.model.ValidationDataConfig.wrap(buildAwsValue())
}
object ValidationDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ValidationDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ValidationDataConfig =
      zio.aws.bedrock.model.ValidationDataConfig(validators.map { item =>
        item.asEditable
      })
    def validators: List[zio.aws.bedrock.model.Validator.ReadOnly]
    def getValidators
        : ZIO[Any, Nothing, List[zio.aws.bedrock.model.Validator.ReadOnly]] =
      ZIO.succeed(validators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ValidationDataConfig
  ) extends zio.aws.bedrock.model.ValidationDataConfig.ReadOnly {
    override val validators: List[zio.aws.bedrock.model.Validator.ReadOnly] =
      impl
        .validators()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.Validator.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ValidationDataConfig
  ): zio.aws.bedrock.model.ValidationDataConfig.ReadOnly = new Wrapper(impl)
}
