package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Validator(s3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.Validator = {
    import Validator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.Validator
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.Validator.ReadOnly =
    zio.aws.bedrock.model.Validator.wrap(buildAwsValue())
}
object Validator {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.bedrock.model.Validator] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.Validator =
      zio.aws.bedrock.model.Validator(s3Uri)
    def s3Uri: S3Uri
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.Validator
  ) extends zio.aws.bedrock.model.Validator.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.Validator
  ): zio.aws.bedrock.model.Validator.ReadOnly = new Wrapper(impl)
}
