package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.MetricFloat
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidatorMetric(
    validationLoss: Optional[MetricFloat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ValidatorMetric = {
    import ValidatorMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ValidatorMetric
      .builder()
      .optionallyWith(
        validationLoss.map(value => MetricFloat.unwrap(value): java.lang.Float)
      )(_.validationLoss)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ValidatorMetric.ReadOnly =
    zio.aws.bedrock.model.ValidatorMetric.wrap(buildAwsValue())
}
object ValidatorMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ValidatorMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ValidatorMetric =
      zio.aws.bedrock.model.ValidatorMetric(validationLoss.map(value => value))
    def validationLoss: Optional[MetricFloat]
    def getValidationLoss: ZIO[Any, AwsError, MetricFloat] =
      AwsError.unwrapOptionField("validationLoss", validationLoss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ValidatorMetric
  ) extends zio.aws.bedrock.model.ValidatorMetric.ReadOnly {
    override val validationLoss: Optional[MetricFloat] = zio.aws.core.internal
      .optionalFromNullable(impl.validationLoss())
      .map(value => zio.aws.bedrock.model.primitives.MetricFloat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ValidatorMetric
  ): zio.aws.bedrock.model.ValidatorMetric.ReadOnly = new Wrapper(impl)
}
