package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{SecurityGroupId, SubnetId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VpcConfig(
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.VpcConfig
      .builder()
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.VpcConfig.ReadOnly =
    zio.aws.bedrock.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.bedrock.model.VpcConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.VpcConfig =
      zio.aws.bedrock.model.VpcConfig(subnetIds, securityGroupIds)
    def subnetIds: List[SubnetId]
    def securityGroupIds: List[SecurityGroupId]
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.VpcConfig
  ) extends zio.aws.bedrock.model.VpcConfig.ReadOnly {
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.VpcConfig
  ): zio.aws.bedrock.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
