package zio.aws.bedrock
import zio.aws.bedrock.model.primitives.{
  SubnetId,
  EvaluationJobIdentifier,
  ErrorMessage,
  EvaluationModelIdentifier,
  SecurityGroupId,
  GuardrailFailureRecommendation,
  GuardrailTopicExample,
  EvaluationMetricName,
  GuardrailStatusReason,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.bedrock.model.primitives.GuardrailRegexDescriptionString.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends zio.prelude.Subtype[String]
    type AccountId = zio.aws.bedrock.model.primitives.AccountId.Type
    object BaseModelIdentifier extends zio.prelude.Subtype[String]
    type BaseModelIdentifier =
      zio.aws.bedrock.model.primitives.BaseModelIdentifier.Type
    object BedrockModelId extends zio.prelude.Subtype[String]
    type BedrockModelId = zio.aws.bedrock.model.primitives.BedrockModelId.Type
    object BrandedName extends zio.prelude.Subtype[String]
    type BrandedName = zio.aws.bedrock.model.primitives.BrandedName.Type
    object BucketName extends zio.prelude.Subtype[String]
    type BucketName = zio.aws.bedrock.model.primitives.BucketName.Type
    object CustomModelArn extends zio.prelude.Subtype[String]
    type CustomModelArn = zio.aws.bedrock.model.primitives.CustomModelArn.Type
    object CustomModelName extends zio.prelude.Subtype[String]
    type CustomModelName = zio.aws.bedrock.model.primitives.CustomModelName.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.bedrock.model.primitives.ErrorMessage.Type
    object EvaluationDatasetName extends zio.prelude.Subtype[String]
    type EvaluationDatasetName =
      zio.aws.bedrock.model.primitives.EvaluationDatasetName.Type
    object EvaluationJobArn extends zio.prelude.Subtype[String]
    type EvaluationJobArn =
      zio.aws.bedrock.model.primitives.EvaluationJobArn.Type
    object EvaluationJobDescription extends zio.prelude.Subtype[String]
    type EvaluationJobDescription =
      zio.aws.bedrock.model.primitives.EvaluationJobDescription.Type
    object EvaluationJobIdentifier extends zio.prelude.Subtype[String]
    type EvaluationJobIdentifier =
      zio.aws.bedrock.model.primitives.EvaluationJobIdentifier.Type
    object EvaluationJobName extends zio.prelude.Subtype[String]
    type EvaluationJobName =
      zio.aws.bedrock.model.primitives.EvaluationJobName.Type
    object EvaluationMetricDescription extends zio.prelude.Subtype[String]
    type EvaluationMetricDescription =
      zio.aws.bedrock.model.primitives.EvaluationMetricDescription.Type
    object EvaluationMetricName extends zio.prelude.Subtype[String]
    type EvaluationMetricName =
      zio.aws.bedrock.model.primitives.EvaluationMetricName.Type
    object EvaluationModelIdentifier extends zio.prelude.Subtype[String]
    type EvaluationModelIdentifier =
      zio.aws.bedrock.model.primitives.EvaluationModelIdentifier.Type
    object EvaluationModelInferenceParams extends zio.prelude.Subtype[String]
    type EvaluationModelInferenceParams =
      zio.aws.bedrock.model.primitives.EvaluationModelInferenceParams.Type
    object EvaluationRatingMethod extends zio.prelude.Subtype[String]
    type EvaluationRatingMethod =
      zio.aws.bedrock.model.primitives.EvaluationRatingMethod.Type
    object FoundationModelArn extends zio.prelude.Subtype[String]
    type FoundationModelArn =
      zio.aws.bedrock.model.primitives.FoundationModelArn.Type
    object GuardrailArn extends zio.prelude.Subtype[String]
    type GuardrailArn = zio.aws.bedrock.model.primitives.GuardrailArn.Type
    object GuardrailBlockedMessaging extends zio.prelude.Subtype[String]
    type GuardrailBlockedMessaging =
      zio.aws.bedrock.model.primitives.GuardrailBlockedMessaging.Type
    object GuardrailContextualGroundingFilterConfigThresholdDouble
        extends zio.prelude.Subtype[Double]
    type GuardrailContextualGroundingFilterConfigThresholdDouble =
      zio.aws.bedrock.model.primitives.GuardrailContextualGroundingFilterConfigThresholdDouble.Type
    object GuardrailContextualGroundingFilterThresholdDouble
        extends zio.prelude.Subtype[Double]
    type GuardrailContextualGroundingFilterThresholdDouble =
      zio.aws.bedrock.model.primitives.GuardrailContextualGroundingFilterThresholdDouble.Type
    object GuardrailDescription extends zio.prelude.Subtype[String]
    type GuardrailDescription =
      zio.aws.bedrock.model.primitives.GuardrailDescription.Type
    object GuardrailDraftVersion extends zio.prelude.Subtype[String]
    type GuardrailDraftVersion =
      zio.aws.bedrock.model.primitives.GuardrailDraftVersion.Type
    object GuardrailFailureRecommendation extends zio.prelude.Subtype[String]
    type GuardrailFailureRecommendation =
      zio.aws.bedrock.model.primitives.GuardrailFailureRecommendation.Type
    object GuardrailId extends zio.prelude.Subtype[String]
    type GuardrailId = zio.aws.bedrock.model.primitives.GuardrailId.Type
    object GuardrailIdentifier extends zio.prelude.Subtype[String]
    type GuardrailIdentifier =
      zio.aws.bedrock.model.primitives.GuardrailIdentifier.Type
    object GuardrailName extends zio.prelude.Subtype[String]
    type GuardrailName = zio.aws.bedrock.model.primitives.GuardrailName.Type
    object GuardrailNumericalVersion extends zio.prelude.Subtype[String]
    type GuardrailNumericalVersion =
      zio.aws.bedrock.model.primitives.GuardrailNumericalVersion.Type
    object GuardrailRegexConfigDescriptionString
        extends zio.prelude.Subtype[String]
    type GuardrailRegexConfigDescriptionString =
      zio.aws.bedrock.model.primitives.GuardrailRegexConfigDescriptionString.Type
    object GuardrailRegexConfigNameString extends zio.prelude.Subtype[String]
    type GuardrailRegexConfigNameString =
      zio.aws.bedrock.model.primitives.GuardrailRegexConfigNameString.Type
    object GuardrailRegexConfigPatternString extends zio.prelude.Subtype[String]
    type GuardrailRegexConfigPatternString =
      zio.aws.bedrock.model.primitives.GuardrailRegexConfigPatternString.Type
    object GuardrailRegexDescriptionString extends zio.prelude.Subtype[String]
    type GuardrailRegexDescriptionString =
      zio.aws.bedrock.model.primitives.GuardrailRegexDescriptionString.Type
    object GuardrailRegexNameString extends zio.prelude.Subtype[String]
    type GuardrailRegexNameString =
      zio.aws.bedrock.model.primitives.GuardrailRegexNameString.Type
    object GuardrailRegexPatternString extends zio.prelude.Subtype[String]
    type GuardrailRegexPatternString =
      zio.aws.bedrock.model.primitives.GuardrailRegexPatternString.Type
    object GuardrailStatusReason extends zio.prelude.Subtype[String]
    type GuardrailStatusReason =
      zio.aws.bedrock.model.primitives.GuardrailStatusReason.Type
    object GuardrailTopicDefinition extends zio.prelude.Subtype[String]
    type GuardrailTopicDefinition =
      zio.aws.bedrock.model.primitives.GuardrailTopicDefinition.Type
    object GuardrailTopicExample extends zio.prelude.Subtype[String]
    type GuardrailTopicExample =
      zio.aws.bedrock.model.primitives.GuardrailTopicExample.Type
    object GuardrailTopicName extends zio.prelude.Subtype[String]
    type GuardrailTopicName =
      zio.aws.bedrock.model.primitives.GuardrailTopicName.Type
    object GuardrailVersion extends zio.prelude.Subtype[String]
    type GuardrailVersion =
      zio.aws.bedrock.model.primitives.GuardrailVersion.Type
    object GuardrailWordConfigTextString extends zio.prelude.Subtype[String]
    type GuardrailWordConfigTextString =
      zio.aws.bedrock.model.primitives.GuardrailWordConfigTextString.Type
    object GuardrailWordTextString extends zio.prelude.Subtype[String]
    type GuardrailWordTextString =
      zio.aws.bedrock.model.primitives.GuardrailWordTextString.Type
    object HumanTaskInstructions extends zio.prelude.Subtype[String]
    type HumanTaskInstructions =
      zio.aws.bedrock.model.primitives.HumanTaskInstructions.Type
    object IdempotencyToken extends zio.prelude.Subtype[String]
    type IdempotencyToken =
      zio.aws.bedrock.model.primitives.IdempotencyToken.Type
    object ImportedModelArn extends zio.prelude.Subtype[String]
    type ImportedModelArn =
      zio.aws.bedrock.model.primitives.ImportedModelArn.Type
    object ImportedModelIdentifier extends zio.prelude.Subtype[String]
    type ImportedModelIdentifier =
      zio.aws.bedrock.model.primitives.ImportedModelIdentifier.Type
    object ImportedModelName extends zio.prelude.Subtype[String]
    type ImportedModelName =
      zio.aws.bedrock.model.primitives.ImportedModelName.Type
    object InferenceProfileArn extends zio.prelude.Subtype[String]
    type InferenceProfileArn =
      zio.aws.bedrock.model.primitives.InferenceProfileArn.Type
    object InferenceProfileDescription extends zio.prelude.Subtype[String]
    type InferenceProfileDescription =
      zio.aws.bedrock.model.primitives.InferenceProfileDescription.Type
    object InferenceProfileId extends zio.prelude.Subtype[String]
    type InferenceProfileId =
      zio.aws.bedrock.model.primitives.InferenceProfileId.Type
    object InferenceProfileIdentifier extends zio.prelude.Subtype[String]
    type InferenceProfileIdentifier =
      zio.aws.bedrock.model.primitives.InferenceProfileIdentifier.Type
    object InferenceProfileName extends zio.prelude.Subtype[String]
    type InferenceProfileName =
      zio.aws.bedrock.model.primitives.InferenceProfileName.Type
    object InstructSupported extends zio.prelude.Subtype[Boolean]
    type InstructSupported =
      zio.aws.bedrock.model.primitives.InstructSupported.Type
    object JobName extends zio.prelude.Subtype[String]
    type JobName = zio.aws.bedrock.model.primitives.JobName.Type
    object KeyPrefix extends zio.prelude.Subtype[String]
    type KeyPrefix = zio.aws.bedrock.model.primitives.KeyPrefix.Type
    object KmsKeyArn extends zio.prelude.Subtype[String]
    type KmsKeyArn = zio.aws.bedrock.model.primitives.KmsKeyArn.Type
    object KmsKeyId extends zio.prelude.Subtype[String]
    type KmsKeyId = zio.aws.bedrock.model.primitives.KmsKeyId.Type
    object LogGroupName extends zio.prelude.Subtype[String]
    type LogGroupName = zio.aws.bedrock.model.primitives.LogGroupName.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.bedrock.model.primitives.MaxResults.Type
    object Message extends zio.prelude.Subtype[String]
    type Message = zio.aws.bedrock.model.primitives.Message.Type
    object MetricFloat extends zio.prelude.Subtype[Float]
    type MetricFloat = zio.aws.bedrock.model.primitives.MetricFloat.Type
    object ModelArchitecture extends zio.prelude.Subtype[String]
    type ModelArchitecture =
      zio.aws.bedrock.model.primitives.ModelArchitecture.Type
    object ModelArn extends zio.prelude.Subtype[String]
    type ModelArn = zio.aws.bedrock.model.primitives.ModelArn.Type
    object ModelCopyJobArn extends zio.prelude.Subtype[String]
    type ModelCopyJobArn = zio.aws.bedrock.model.primitives.ModelCopyJobArn.Type
    object ModelCustomizationJobArn extends zio.prelude.Subtype[String]
    type ModelCustomizationJobArn =
      zio.aws.bedrock.model.primitives.ModelCustomizationJobArn.Type
    object ModelCustomizationJobIdentifier extends zio.prelude.Subtype[String]
    type ModelCustomizationJobIdentifier =
      zio.aws.bedrock.model.primitives.ModelCustomizationJobIdentifier.Type
    object ModelId extends zio.prelude.Subtype[String]
    type ModelId = zio.aws.bedrock.model.primitives.ModelId.Type
    object ModelIdentifier extends zio.prelude.Subtype[String]
    type ModelIdentifier = zio.aws.bedrock.model.primitives.ModelIdentifier.Type
    object ModelImportJobArn extends zio.prelude.Subtype[String]
    type ModelImportJobArn =
      zio.aws.bedrock.model.primitives.ModelImportJobArn.Type
    object ModelImportJobIdentifier extends zio.prelude.Subtype[String]
    type ModelImportJobIdentifier =
      zio.aws.bedrock.model.primitives.ModelImportJobIdentifier.Type
    object ModelInvocationIdempotencyToken extends zio.prelude.Subtype[String]
    type ModelInvocationIdempotencyToken =
      zio.aws.bedrock.model.primitives.ModelInvocationIdempotencyToken.Type
    object ModelInvocationJobArn extends zio.prelude.Subtype[String]
    type ModelInvocationJobArn =
      zio.aws.bedrock.model.primitives.ModelInvocationJobArn.Type
    object ModelInvocationJobIdentifier extends zio.prelude.Subtype[String]
    type ModelInvocationJobIdentifier =
      zio.aws.bedrock.model.primitives.ModelInvocationJobIdentifier.Type
    object ModelInvocationJobName extends zio.prelude.Subtype[String]
    type ModelInvocationJobName =
      zio.aws.bedrock.model.primitives.ModelInvocationJobName.Type
    object ModelInvocationJobTimeoutDurationInHours
        extends zio.prelude.Subtype[Int]
    type ModelInvocationJobTimeoutDurationInHours =
      zio.aws.bedrock.model.primitives.ModelInvocationJobTimeoutDurationInHours.Type
    object ModelName extends zio.prelude.Subtype[String]
    type ModelName = zio.aws.bedrock.model.primitives.ModelName.Type
    object PaginationToken extends zio.prelude.Subtype[String]
    type PaginationToken = zio.aws.bedrock.model.primitives.PaginationToken.Type
    object PositiveInteger extends zio.prelude.Subtype[Int]
    type PositiveInteger = zio.aws.bedrock.model.primitives.PositiveInteger.Type
    object Provider extends zio.prelude.Subtype[String]
    type Provider = zio.aws.bedrock.model.primitives.Provider.Type
    object ProvisionedModelArn extends zio.prelude.Subtype[String]
    type ProvisionedModelArn =
      zio.aws.bedrock.model.primitives.ProvisionedModelArn.Type
    object ProvisionedModelId extends zio.prelude.Subtype[String]
    type ProvisionedModelId =
      zio.aws.bedrock.model.primitives.ProvisionedModelId.Type
    object ProvisionedModelName extends zio.prelude.Subtype[String]
    type ProvisionedModelName =
      zio.aws.bedrock.model.primitives.ProvisionedModelName.Type
    object RoleArn extends zio.prelude.Subtype[String]
    type RoleArn = zio.aws.bedrock.model.primitives.RoleArn.Type
    object S3Uri extends zio.prelude.Subtype[String]
    type S3Uri = zio.aws.bedrock.model.primitives.S3Uri.Type
    object SageMakerFlowDefinitionArn extends zio.prelude.Subtype[String]
    type SageMakerFlowDefinitionArn =
      zio.aws.bedrock.model.primitives.SageMakerFlowDefinitionArn.Type
    object SecurityGroupId extends zio.prelude.Subtype[String]
    type SecurityGroupId = zio.aws.bedrock.model.primitives.SecurityGroupId.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.bedrock.model.primitives.SubnetId.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.bedrock.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.bedrock.model.primitives.TagValue.Type
    object TaggableResourcesArn extends zio.prelude.Subtype[String]
    type TaggableResourcesArn =
      zio.aws.bedrock.model.primitives.TaggableResourcesArn.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.bedrock.model.primitives.Timestamp.Type
  }
  type BatchDeleteEvaluationJobErrors =
    List[zio.aws.bedrock.model.BatchDeleteEvaluationJobError]
  type BatchDeleteEvaluationJobItems =
    List[zio.aws.bedrock.model.BatchDeleteEvaluationJobItem]
  type CustomModelSummaryList = List[zio.aws.bedrock.model.CustomModelSummary]
  type ErrorMessages = List[ErrorMessage]
  type EvaluationDatasetMetricConfigs =
    List[zio.aws.bedrock.model.EvaluationDatasetMetricConfig]
  type EvaluationJobIdentifiers = List[EvaluationJobIdentifier]
  type EvaluationMetricNames = List[EvaluationMetricName]
  type EvaluationModelConfigs =
    List[zio.aws.bedrock.model.EvaluationModelConfig]
  type EvaluationModelIdentifiers = List[EvaluationModelIdentifier]
  type EvaluationSummaries = List[zio.aws.bedrock.model.EvaluationSummary]
  type EvaluationTaskTypes = List[zio.aws.bedrock.model.EvaluationTaskType]
  type FoundationModelSummaryList =
    List[zio.aws.bedrock.model.FoundationModelSummary]
  type GuardrailContentFilters =
    List[zio.aws.bedrock.model.GuardrailContentFilter]
  type GuardrailContentFiltersConfig =
    List[zio.aws.bedrock.model.GuardrailContentFilterConfig]
  type GuardrailContextualGroundingFilters =
    List[zio.aws.bedrock.model.GuardrailContextualGroundingFilter]
  type GuardrailContextualGroundingFiltersConfig =
    List[zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig]
  type GuardrailFailureRecommendations = List[GuardrailFailureRecommendation]
  type GuardrailManagedWordLists =
    List[zio.aws.bedrock.model.GuardrailManagedWords]
  type GuardrailManagedWordListsConfig =
    List[zio.aws.bedrock.model.GuardrailManagedWordsConfig]
  type GuardrailPiiEntities = List[zio.aws.bedrock.model.GuardrailPiiEntity]
  type GuardrailPiiEntitiesConfig =
    List[zio.aws.bedrock.model.GuardrailPiiEntityConfig]
  type GuardrailRegexes = List[zio.aws.bedrock.model.GuardrailRegex]
  type GuardrailRegexesConfig = List[zio.aws.bedrock.model.GuardrailRegexConfig]
  type GuardrailStatusReasons = List[GuardrailStatusReason]
  type GuardrailSummaries = List[zio.aws.bedrock.model.GuardrailSummary]
  type GuardrailTopicExamples = List[GuardrailTopicExample]
  type GuardrailTopics = List[zio.aws.bedrock.model.GuardrailTopic]
  type GuardrailTopicsConfig = List[zio.aws.bedrock.model.GuardrailTopicConfig]
  type GuardrailWords = List[zio.aws.bedrock.model.GuardrailWord]
  type GuardrailWordsConfig = List[zio.aws.bedrock.model.GuardrailWordConfig]
  type HumanEvaluationCustomMetrics =
    List[zio.aws.bedrock.model.HumanEvaluationCustomMetric]
  type ImportedModelSummaryList =
    List[zio.aws.bedrock.model.ImportedModelSummary]
  type InferenceProfileModels =
    List[zio.aws.bedrock.model.InferenceProfileModel]
  type InferenceProfileSummaries =
    List[zio.aws.bedrock.model.InferenceProfileSummary]
  type InferenceTypeList = List[zio.aws.bedrock.model.InferenceType]
  type ModelCopyJobSummaries = List[zio.aws.bedrock.model.ModelCopyJobSummary]
  type ModelCustomizationHyperParameters = Map[String, String]
  type ModelCustomizationJobSummaries =
    List[zio.aws.bedrock.model.ModelCustomizationJobSummary]
  type ModelCustomizationList = List[zio.aws.bedrock.model.ModelCustomization]
  type ModelImportJobSummaries =
    List[zio.aws.bedrock.model.ModelImportJobSummary]
  type ModelInvocationJobSummaries =
    List[zio.aws.bedrock.model.ModelInvocationJobSummary]
  type ModelModalityList = List[zio.aws.bedrock.model.ModelModality]
  type ProvisionedModelSummaries =
    List[zio.aws.bedrock.model.ProvisionedModelSummary]
  type SecurityGroupIds = List[SecurityGroupId]
  type SubnetIds = List[SubnetId]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.bedrock.model.Tag]
  type ValidationMetrics = List[zio.aws.bedrock.model.ValidatorMetric]
  type Validators = List[zio.aws.bedrock.model.Validator]
}
