package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.JobArn
import scala.jdk.CollectionConverters._
final case class CancelJobResponse(
    cancellationStatus: zio.aws.braket.model.CancellationStatus,
    jobArn: JobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CancelJobResponse = {
    import CancelJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CancelJobResponse
      .builder()
      .cancellationStatus(cancellationStatus.unwrap)
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CancelJobResponse.ReadOnly =
    zio.aws.braket.model.CancelJobResponse.wrap(buildAwsValue())
}
object CancelJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CancelJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CancelJobResponse =
      zio.aws.braket.model.CancelJobResponse(cancellationStatus, jobArn)
    def cancellationStatus: zio.aws.braket.model.CancellationStatus
    def jobArn: JobArn
    def getCancellationStatus
        : ZIO[Any, Nothing, zio.aws.braket.model.CancellationStatus] =
      ZIO.succeed(cancellationStatus)
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CancelJobResponse
  ) extends zio.aws.braket.model.CancelJobResponse.ReadOnly {
    override val cancellationStatus: zio.aws.braket.model.CancellationStatus =
      zio.aws.braket.model.CancellationStatus.wrap(impl.cancellationStatus())
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CancelJobResponse
  ): zio.aws.braket.model.CancelJobResponse.ReadOnly = new Wrapper(impl)
}
