package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.{QuantumTaskArn, String64}
import scala.jdk.CollectionConverters._
final case class CancelQuantumTaskRequest(
    clientToken: String64,
    quantumTaskArn: QuantumTaskArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest = {
    import CancelQuantumTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest
      .builder()
      .clientToken(String64.unwrap(clientToken): java.lang.String)
      .quantumTaskArn(QuantumTaskArn.unwrap(quantumTaskArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CancelQuantumTaskRequest.ReadOnly =
    zio.aws.braket.model.CancelQuantumTaskRequest.wrap(buildAwsValue())
}
object CancelQuantumTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CancelQuantumTaskRequest =
      zio.aws.braket.model.CancelQuantumTaskRequest(clientToken, quantumTaskArn)
    def clientToken: String64
    def quantumTaskArn: QuantumTaskArn
    def getClientToken: ZIO[Any, Nothing, String64] = ZIO.succeed(clientToken)
    def getQuantumTaskArn: ZIO[Any, Nothing, QuantumTaskArn] =
      ZIO.succeed(quantumTaskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest
  ) extends zio.aws.braket.model.CancelQuantumTaskRequest.ReadOnly {
    override val clientToken: String64 =
      zio.aws.braket.model.primitives.String64(impl.clientToken())
    override val quantumTaskArn: QuantumTaskArn =
      zio.aws.braket.model.primitives.QuantumTaskArn(impl.quantumTaskArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest
  ): zio.aws.braket.model.CancelQuantumTaskRequest.ReadOnly = new Wrapper(impl)
}
