package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.JobArn
import scala.jdk.CollectionConverters._
final case class CreateJobResponse(jobArn: JobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.CreateJobResponse = {
    import CreateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.CreateJobResponse
      .builder()
      .jobArn(JobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.CreateJobResponse.ReadOnly =
    zio.aws.braket.model.CreateJobResponse.wrap(buildAwsValue())
}
object CreateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.CreateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.CreateJobResponse =
      zio.aws.braket.model.CreateJobResponse(jobArn)
    def jobArn: JobArn
    def getJobArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.CreateJobResponse
  ) extends zio.aws.braket.model.CreateJobResponse.ReadOnly {
    override val jobArn: JobArn =
      zio.aws.braket.model.primitives.JobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.CreateJobResponse
  ): zio.aws.braket.model.CreateJobResponse.ReadOnly = new Wrapper(impl)
}
