package zio.aws.braket.model
import scala.jdk.CollectionConverters._
sealed trait DeviceType {
  def unwrap: software.amazon.awssdk.services.braket.model.DeviceType
}
object DeviceType {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.DeviceType
  ): zio.aws.braket.model.DeviceType = value match {
    case software.amazon.awssdk.services.braket.model.DeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.DeviceType.QPU =>
      val r = QPU
      r
    case software.amazon.awssdk.services.braket.model.DeviceType.SIMULATOR =>
      val r = SIMULATOR
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.DeviceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceType =
      software.amazon.awssdk.services.braket.model.DeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object QPU extends zio.aws.braket.model.DeviceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceType =
      software.amazon.awssdk.services.braket.model.DeviceType.QPU
  }
  case object SIMULATOR extends zio.aws.braket.model.DeviceType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.DeviceType =
      software.amazon.awssdk.services.braket.model.DeviceType.SIMULATOR
  }
}
