package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.{JsonValue, DeviceArn}
import scala.jdk.CollectionConverters._
final case class GetDeviceResponse(
    deviceArn: DeviceArn,
    deviceCapabilities: JsonValue,
    deviceName: String,
    deviceStatus: zio.aws.braket.model.DeviceStatus,
    deviceType: zio.aws.braket.model.DeviceType,
    providerName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.GetDeviceResponse = {
    import GetDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.GetDeviceResponse
      .builder()
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .deviceCapabilities(
        JsonValue.unwrap(deviceCapabilities): java.lang.String
      )
      .deviceName(deviceName: java.lang.String)
      .deviceStatus(deviceStatus.unwrap)
      .deviceType(deviceType.unwrap)
      .providerName(providerName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.GetDeviceResponse.ReadOnly =
    zio.aws.braket.model.GetDeviceResponse.wrap(buildAwsValue())
}
object GetDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.GetDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.GetDeviceResponse =
      zio.aws.braket.model.GetDeviceResponse(
        deviceArn,
        deviceCapabilities,
        deviceName,
        deviceStatus,
        deviceType,
        providerName
      )
    def deviceArn: DeviceArn
    def deviceCapabilities: JsonValue
    def deviceName: String
    def deviceStatus: zio.aws.braket.model.DeviceStatus
    def deviceType: zio.aws.braket.model.DeviceType
    def providerName: String
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
    def getDeviceCapabilities: ZIO[Any, Nothing, JsonValue] =
      ZIO.succeed(deviceCapabilities)
    def getDeviceName: ZIO[Any, Nothing, String] = ZIO.succeed(deviceName)
    def getDeviceStatus: ZIO[Any, Nothing, zio.aws.braket.model.DeviceStatus] =
      ZIO.succeed(deviceStatus)
    def getDeviceType: ZIO[Any, Nothing, zio.aws.braket.model.DeviceType] =
      ZIO.succeed(deviceType)
    def getProviderName: ZIO[Any, Nothing, String] = ZIO.succeed(providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.GetDeviceResponse
  ) extends zio.aws.braket.model.GetDeviceResponse.ReadOnly {
    override val deviceArn: DeviceArn =
      zio.aws.braket.model.primitives.DeviceArn(impl.deviceArn())
    override val deviceCapabilities: JsonValue =
      zio.aws.braket.model.primitives.JsonValue(impl.deviceCapabilities())
    override val deviceName: String = impl.deviceName(): String
    override val deviceStatus: zio.aws.braket.model.DeviceStatus =
      zio.aws.braket.model.DeviceStatus.wrap(impl.deviceStatus())
    override val deviceType: zio.aws.braket.model.DeviceType =
      zio.aws.braket.model.DeviceType.wrap(impl.deviceType())
    override val providerName: String = impl.providerName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.GetDeviceResponse
  ): zio.aws.braket.model.GetDeviceResponse.ReadOnly = new Wrapper(impl)
}
