package zio.aws.braket.model
import zio.aws.braket.model.primitives.{
  InstanceConfigVolumeSizeInGbInteger,
  InstanceConfigInstanceCountInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceConfig(
    instanceCount: Optional[InstanceConfigInstanceCountInteger] =
      Optional.Absent,
    instanceType: zio.aws.braket.model.InstanceType,
    volumeSizeInGb: InstanceConfigVolumeSizeInGbInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.InstanceConfig = {
    import InstanceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.InstanceConfig
      .builder()
      .optionallyWith(
        instanceCount.map(value =>
          InstanceConfigInstanceCountInteger.unwrap(value): Integer
        )
      )(_.instanceCount)
      .instanceType(instanceType.unwrap)
      .volumeSizeInGb(
        InstanceConfigVolumeSizeInGbInteger.unwrap(volumeSizeInGb): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.braket.model.InstanceConfig.ReadOnly =
    zio.aws.braket.model.InstanceConfig.wrap(buildAwsValue())
}
object InstanceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.InstanceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.InstanceConfig =
      zio.aws.braket.model.InstanceConfig(
        instanceCount.map(value => value),
        instanceType,
        volumeSizeInGb
      )
    def instanceCount: Optional[InstanceConfigInstanceCountInteger]
    def instanceType: zio.aws.braket.model.InstanceType
    def volumeSizeInGb: InstanceConfigVolumeSizeInGbInteger
    def getInstanceCount
        : ZIO[Any, AwsError, InstanceConfigInstanceCountInteger] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, Nothing, zio.aws.braket.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getVolumeSizeInGb
        : ZIO[Any, Nothing, InstanceConfigVolumeSizeInGbInteger] =
      ZIO.succeed(volumeSizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.InstanceConfig
  ) extends zio.aws.braket.model.InstanceConfig.ReadOnly {
    override val instanceCount: Optional[InstanceConfigInstanceCountInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCount())
        .map(value =>
          zio.aws.braket.model.primitives
            .InstanceConfigInstanceCountInteger(value)
        )
    override val instanceType: zio.aws.braket.model.InstanceType =
      zio.aws.braket.model.InstanceType.wrap(impl.instanceType())
    override val volumeSizeInGb: InstanceConfigVolumeSizeInGbInteger =
      zio.aws.braket.model.primitives
        .InstanceConfigVolumeSizeInGbInteger(impl.volumeSizeInGb())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.InstanceConfig
  ): zio.aws.braket.model.InstanceConfig.ReadOnly = new Wrapper(impl)
}
