package zio.aws.braket.model
import scala.jdk.CollectionConverters._
sealed trait JobEventType {
  def unwrap: software.amazon.awssdk.services.braket.model.JobEventType
}
object JobEventType {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.JobEventType
  ): zio.aws.braket.model.JobEventType = value match {
    case software.amazon.awssdk.services.braket.model.JobEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.WAITING_FOR_PRIORITY =>
      val r = WAITING_FOR_PRIORITY
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.QUEUED_FOR_EXECUTION =>
      val r = QUEUED_FOR_EXECUTION
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.STARTING_INSTANCE =>
      val r = STARTING_INSTANCE
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.DOWNLOADING_DATA =>
      val r = DOWNLOADING_DATA
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.DEPRIORITIZED_DUE_TO_INACTIVITY =>
      val r = DEPRIORITIZED_DUE_TO_INACTIVITY
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.UPLOADING_RESULTS =>
      val r = UPLOADING_RESULTS
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.MAX_RUNTIME_EXCEEDED =>
      val r = MAX_RUNTIME_EXCEEDED
      r
    case software.amazon.awssdk.services.braket.model.JobEventType.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object WAITING_FOR_PRIORITY extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.WAITING_FOR_PRIORITY
  }
  case object QUEUED_FOR_EXECUTION extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.QUEUED_FOR_EXECUTION
  }
  case object STARTING_INSTANCE extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.STARTING_INSTANCE
  }
  case object DOWNLOADING_DATA extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.DOWNLOADING_DATA
  }
  case object RUNNING extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.RUNNING
  }
  case object DEPRIORITIZED_DUE_TO_INACTIVITY
      extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.DEPRIORITIZED_DUE_TO_INACTIVITY
  }
  case object UPLOADING_RESULTS extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.UPLOADING_RESULTS
  }
  case object COMPLETED extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.COMPLETED
  }
  case object FAILED extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.FAILED
  }
  case object MAX_RUNTIME_EXCEEDED extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.MAX_RUNTIME_EXCEEDED
  }
  case object CANCELLED extends zio.aws.braket.model.JobEventType {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobEventType =
      software.amazon.awssdk.services.braket.model.JobEventType.CANCELLED
  }
}
