package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.braket.model.primitives.{S3Path, String2048}
import scala.jdk.CollectionConverters._
final case class JobOutputDataConfig(
    kmsKeyId: Optional[String2048] = Optional.Absent,
    s3Path: S3Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.JobOutputDataConfig = {
    import JobOutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.JobOutputDataConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => String2048.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .s3Path(S3Path.unwrap(s3Path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.JobOutputDataConfig.ReadOnly =
    zio.aws.braket.model.JobOutputDataConfig.wrap(buildAwsValue())
}
object JobOutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.JobOutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.JobOutputDataConfig =
      zio.aws.braket.model
        .JobOutputDataConfig(kmsKeyId.map(value => value), s3Path)
    def kmsKeyId: Optional[String2048]
    def s3Path: S3Path
    def getKmsKeyId: ZIO[Any, AwsError, String2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3Path: ZIO[Any, Nothing, S3Path] = ZIO.succeed(s3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.JobOutputDataConfig
  ) extends zio.aws.braket.model.JobOutputDataConfig.ReadOnly {
    override val kmsKeyId: Optional[String2048] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.braket.model.primitives.String2048(value))
    override val s3Path: S3Path =
      zio.aws.braket.model.primitives.S3Path(impl.s3Path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.JobOutputDataConfig
  ): zio.aws.braket.model.JobOutputDataConfig.ReadOnly = new Wrapper(impl)
}
