package zio.aws.braket.model
import scala.jdk.CollectionConverters._
sealed trait JobPrimaryStatus {
  def unwrap: software.amazon.awssdk.services.braket.model.JobPrimaryStatus
}
object JobPrimaryStatus {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.JobPrimaryStatus
  ): zio.aws.braket.model.JobPrimaryStatus = value match {
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.braket.model.JobPrimaryStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.QUEUED
  }
  case object RUNNING extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.COMPLETED
  }
  case object FAILED extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.FAILED
  }
  case object CANCELLING extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.braket.model.JobPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.JobPrimaryStatus =
      software.amazon.awssdk.services.braket.model.JobPrimaryStatus.CANCELLED
  }
}
