package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.braket.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.ListTagsForResourceRequest =
      zio.aws.braket.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: String
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest
  ) extends zio.aws.braket.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest
  ): zio.aws.braket.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
