package zio.aws.braket.model
import scala.jdk.CollectionConverters._
sealed trait QuantumTaskStatus {
  def unwrap: software.amazon.awssdk.services.braket.model.QuantumTaskStatus
}
object QuantumTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.braket.model.QuantumTaskStatus
  ): zio.aws.braket.model.QuantumTaskStatus = value match {
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.braket.model.QuantumTaskStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.CREATED
  }
  case object QUEUED extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.QUEUED
  }
  case object RUNNING extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.COMPLETED
  }
  case object FAILED extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.FAILED
  }
  case object CANCELLING extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.braket.model.QuantumTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.braket.model.QuantumTaskStatus =
      software.amazon.awssdk.services.braket.model.QuantumTaskStatus.CANCELLED
  }
}
