package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.braket.model.primitives.{
  String256,
  SearchDevicesFilterNameString
}
import scala.jdk.CollectionConverters._
final case class SearchDevicesFilter(
    name: SearchDevicesFilterNameString,
    values: Iterable[String256]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchDevicesFilter = {
    import SearchDevicesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchDevicesFilter
      .builder()
      .name(SearchDevicesFilterNameString.unwrap(name): java.lang.String)
      .values(values.map { item =>
        String256.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchDevicesFilter.ReadOnly =
    zio.aws.braket.model.SearchDevicesFilter.wrap(buildAwsValue())
}
object SearchDevicesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchDevicesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchDevicesFilter =
      zio.aws.braket.model.SearchDevicesFilter(name, values)
    def name: SearchDevicesFilterNameString
    def values: List[String256]
    def getName: ZIO[Any, Nothing, SearchDevicesFilterNameString] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[String256]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesFilter
  ) extends zio.aws.braket.model.SearchDevicesFilter.ReadOnly {
    override val name: SearchDevicesFilterNameString =
      zio.aws.braket.model.primitives.SearchDevicesFilterNameString(impl.name())
    override val values: List[String256] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.braket.model.primitives.String256(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchDevicesFilter
  ): zio.aws.braket.model.SearchDevicesFilter.ReadOnly = new Wrapper(impl)
}
