package zio.aws.braket.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchQuantumTasksResponse(
    nextToken: Optional[String] = Optional.Absent,
    quantumTasks: Iterable[zio.aws.braket.model.QuantumTaskSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse = {
    import SearchQuantumTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .quantumTasks(quantumTasks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly =
    zio.aws.braket.model.SearchQuantumTasksResponse.wrap(buildAwsValue())
}
object SearchQuantumTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.braket.model.SearchQuantumTasksResponse =
      zio.aws.braket.model.SearchQuantumTasksResponse(
        nextToken.map(value => value),
        quantumTasks.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def quantumTasks: List[zio.aws.braket.model.QuantumTaskSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQuantumTasks: ZIO[Any, Nothing, List[
      zio.aws.braket.model.QuantumTaskSummary.ReadOnly
    ]] = ZIO.succeed(quantumTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse
  ) extends zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val quantumTasks
        : List[zio.aws.braket.model.QuantumTaskSummary.ReadOnly] = impl
      .quantumTasks()
      .asScala
      .map { item =>
        zio.aws.braket.model.QuantumTaskSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse
  ): zio.aws.braket.model.SearchQuantumTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
