package zio.aws.chime
import zio.aws.chime.model.BatchCreateRoomMembershipResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.chime.model.{
  CreateVoiceConnectorGroupRequest,
  UpdateVoiceConnectorRequest,
  GetVoiceConnectorOriginationRequest,
  ListChannelBansRequest,
  UpdatePhoneNumberSettingsRequest,
  CreateVoiceConnectorRequest,
  GetProxySessionRequest,
  CreateAccountRequest,
  UpdateUserSettingsRequest,
  DeleteSipMediaApplicationRequest,
  CreateBotRequest,
  ListVoiceConnectorTerminationCredentialsRequest,
  UpdateGlobalSettingsRequest,
  ListMeetingTagsRequest,
  BatchSuspendUserRequest,
  PutVoiceConnectorLoggingConfigurationRequest,
  CreateMeetingRequest,
  CreateRoomMembershipRequest,
  DeleteChannelModeratorRequest,
  BatchCreateChannelMembershipRequest,
  UpdateChannelReadMarkerRequest,
  PutAppInstanceStreamingConfigurationsRequest,
  ListChannelMessagesRequest,
  UpdateSipMediaApplicationRequest,
  DeleteVoiceConnectorOriginationRequest,
  PutRetentionSettingsRequest,
  UpdateAccountSettingsRequest,
  GetMediaCapturePipelineRequest,
  SearchAvailablePhoneNumbersRequest,
  GetBotRequest,
  UntagMeetingRequest,
  DisassociateSigninDelegateGroupsFromAccountRequest,
  DeleteEventsConfigurationRequest,
  CreateMeetingWithAttendeesRequest,
  GetChannelMessageRequest,
  RedactChannelMessageRequest,
  GetVoiceConnectorProxyRequest,
  UpdateSipMediaApplicationCallRequest,
  DeleteChannelRequest,
  DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
  ListUsersRequest,
  GetVoiceConnectorLoggingConfigurationRequest,
  StopMeetingTranscriptionRequest,
  GetSipRuleRequest,
  CreateSipMediaApplicationRequest,
  AssociatePhoneNumbersWithVoiceConnectorRequest,
  DeleteChannelMembershipRequest,
  DescribeChannelModeratedByAppInstanceUserRequest,
  ListMediaCapturePipelinesRequest,
  TagMeetingRequest,
  GetMeetingRequest,
  DeleteAppInstanceUserRequest,
  AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
  CreateChannelRequest,
  DescribeChannelMembershipRequest,
  CreateProxySessionRequest,
  DeleteVoiceConnectorTerminationRequest,
  ListAttendeeTagsRequest,
  DeleteRoomMembershipRequest,
  GetAppInstanceRetentionSettingsRequest,
  ListAttendeesRequest,
  DeleteVoiceConnectorProxyRequest,
  CreateAppInstanceAdminRequest,
  UpdatePhoneNumberRequest,
  UpdateAppInstanceUserRequest,
  GetVoiceConnectorRequest,
  ListTagsForResourceRequest,
  RedactConversationMessageRequest,
  ListBotsRequest,
  CreatePhoneNumberOrderRequest,
  UpdateAccountRequest,
  DeleteAttendeeRequest,
  CreateAppInstanceRequest,
  RedactRoomMessageRequest,
  PutSipMediaApplicationLoggingConfigurationRequest,
  UpdateChannelMessageRequest,
  InviteUsersRequest,
  PutVoiceConnectorOriginationRequest,
  CreateAppInstanceUserRequest,
  ListVoiceConnectorGroupsRequest,
  CreateChannelMembershipRequest,
  PutVoiceConnectorTerminationRequest,
  DeleteAppInstanceAdminRequest,
  GetVoiceConnectorGroupRequest,
  DeletePhoneNumberRequest,
  DeleteProxySessionRequest,
  DeleteRoomRequest,
  UpdateProxySessionRequest,
  DeleteAccountRequest,
  BatchDeletePhoneNumberRequest,
  DeleteMediaCapturePipelineRequest,
  ResetPersonalPinRequest,
  ListChannelMembershipsForAppInstanceUserRequest,
  CreateRoomRequest,
  ListSipRulesRequest,
  GetAttendeeRequest,
  DeleteChannelBanRequest,
  DisassociatePhoneNumberFromUserRequest,
  CreateMediaCapturePipelineRequest,
  ListProxySessionsRequest,
  DeleteVoiceConnectorGroupRequest,
  DescribeChannelMembershipForAppInstanceUserRequest,
  CreateUserRequest,
  RegenerateSecurityTokenRequest,
  GetAccountRequest,
  ListPhoneNumbersRequest,
  UpdateChannelRequest,
  GetUserSettingsRequest,
  DeleteVoiceConnectorRequest,
  CreateAttendeeRequest,
  GetAppInstanceStreamingConfigurationsRequest,
  PutAppInstanceRetentionSettingsRequest,
  GetEventsConfigurationRequest,
  GetPhoneNumberOrderRequest,
  CreateSipRuleRequest,
  DescribeChannelBanRequest,
  PutVoiceConnectorTerminationCredentialsRequest,
  DeleteVoiceConnectorTerminationCredentialsRequest,
  GetSipMediaApplicationRequest,
  DeleteVoiceConnectorStreamingConfigurationRequest,
  GetUserRequest,
  UpdateRoomMembershipRequest,
  ListAppInstanceUsersRequest,
  LogoutUserRequest,
  ListAccountsRequest,
  ListAppInstanceAdminsRequest,
  PutVoiceConnectorStreamingConfigurationRequest,
  DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
  DescribeAppInstanceUserRequest,
  ListChannelsRequest,
  PutVoiceConnectorEmergencyCallingConfigurationRequest,
  GetPhoneNumberRequest,
  ListChannelModeratorsRequest,
  SendChannelMessageRequest,
  ListRoomsRequest,
  UpdateVoiceConnectorGroupRequest,
  UntagResourceRequest,
  UpdateBotRequest,
  CreateSipMediaApplicationCallRequest,
  PutEventsConfigurationRequest,
  UntagAttendeeRequest,
  GetSipMediaApplicationLoggingConfigurationRequest,
  ListRoomMembershipsRequest,
  RestorePhoneNumberRequest,
  ListSupportedPhoneNumberCountriesRequest,
  CreateChannelBanRequest,
  BatchCreateAttendeeRequest,
  DescribeAppInstanceAdminRequest,
  ListMeetingsRequest,
  UpdateSipRuleRequest,
  StartMeetingTranscriptionRequest,
  CreateMeetingDialOutRequest,
  ListSipMediaApplicationsRequest,
  UpdateUserRequest,
  BatchUpdateUserRequest,
  GetMessagingSessionEndpointRequest,
  UpdateRoomRequest,
  DeleteSipRuleRequest,
  DeleteAppInstanceStreamingConfigurationsRequest,
  TagAttendeeRequest,
  DeleteChannelMessageRequest,
  ListVoiceConnectorsRequest,
  UpdateAppInstanceRequest,
  AssociatePhoneNumberWithUserRequest,
  GetVoiceConnectorTerminationHealthRequest,
  AssociateSigninDelegateGroupsWithAccountRequest,
  BatchCreateRoomMembershipRequest,
  DeleteAppInstanceRequest,
  GetVoiceConnectorStreamingConfigurationRequest,
  BatchUpdatePhoneNumberRequest,
  BatchUnsuspendUserRequest,
  ListAppInstancesRequest,
  GetVoiceConnectorEmergencyCallingConfigurationRequest,
  DescribeChannelRequest,
  GetAccountSettingsRequest,
  GetVoiceConnectorTerminationRequest,
  DescribeAppInstanceRequest,
  DeleteMeetingRequest,
  ListPhoneNumberOrdersRequest,
  CreateChannelModeratorRequest,
  PutVoiceConnectorProxyRequest,
  GetRoomRequest,
  TagResourceRequest,
  DisassociatePhoneNumbersFromVoiceConnectorRequest,
  DescribeChannelModeratorRequest,
  ListChannelMembershipsRequest,
  GetRetentionSettingsRequest,
  ListChannelsModeratedByAppInstanceUserRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.chime.model.{
  Account,
  CreateSipMediaApplicationCallResponse,
  TagAttendeeResponse,
  PutVoiceConnectorEmergencyCallingConfigurationResponse,
  UpdateSipRuleResponse,
  GetVoiceConnectorEmergencyCallingConfigurationResponse,
  DescribeChannelMembershipForAppInstanceUserResponse,
  BatchCreateRoomMembershipResponse,
  ListAppInstancesResponse,
  BatchCreateAttendeeResponse,
  GetSipMediaApplicationResponse,
  DeleteSipRuleResponse,
  GetAccountResponse,
  MediaCapturePipeline,
  CreateChannelResponse,
  ListChannelsModeratedByAppInstanceUserResponse,
  PutAppInstanceRetentionSettingsResponse,
  GetVoiceConnectorTerminationResponse,
  GetPhoneNumberSettingsRequest,
  PutEventsConfigurationResponse,
  DeleteMeetingResponse,
  AppInstanceUserSummary,
  Room,
  PutSipMediaApplicationLoggingConfigurationResponse,
  ResetPersonalPinResponse,
  PhoneNumberOrder,
  PutAppInstanceStreamingConfigurationsResponse,
  LogoutUserResponse,
  DeleteVoiceConnectorTerminationCredentialsResponse,
  AssociatePhoneNumbersWithVoiceConnectorGroupResponse,
  UpdateChannelResponse,
  SearchAvailablePhoneNumbersResponse,
  DeleteVoiceConnectorTerminationResponse,
  UntagAttendeeResponse,
  ListRoomsResponse,
  GetVoiceConnectorGroupResponse,
  CreateAttendeeResponse,
  ChannelMessageSummary,
  BatchDeletePhoneNumberResponse,
  CreateProxySessionResponse,
  ListChannelModeratorsResponse,
  DeletePhoneNumberResponse,
  DeleteVoiceConnectorOriginationResponse,
  GetAppInstanceRetentionSettingsResponse,
  ListChannelsResponse,
  UpdateSipMediaApplicationResponse,
  ListPhoneNumberOrdersResponse,
  GetPhoneNumberSettingsResponse,
  CreateSipMediaApplicationResponse,
  GetAttendeeResponse,
  DeleteAppInstanceResponse,
  UpdateAccountResponse,
  SipMediaApplication,
  DeleteProxySessionResponse,
  ListVoiceConnectorsResponse,
  ListUsersResponse,
  DescribeChannelModeratedByAppInstanceUserResponse,
  UpdateVoiceConnectorGroupResponse,
  PutVoiceConnectorLoggingConfigurationResponse,
  DescribeChannelResponse,
  DeleteAccountResponse,
  ChannelModeratorSummary,
  GetAppInstanceStreamingConfigurationsResponse,
  GetVoiceConnectorProxyResponse,
  DeleteAttendeeResponse,
  ChannelBanSummary,
  PutRetentionSettingsResponse,
  AssociatePhoneNumbersWithVoiceConnectorResponse,
  ListMeetingTagsResponse,
  CreateAccountResponse,
  User,
  RedactRoomMessageResponse,
  VoiceConnectorGroup,
  AssociateSigninDelegateGroupsWithAccountResponse,
  ChannelMembershipSummary,
  GetVoiceConnectorTerminationHealthResponse,
  CreatePhoneNumberOrderResponse,
  ListAccountsResponse,
  ListProxySessionsResponse,
  DeleteChannelBanResponse,
  ListAppInstanceUsersResponse,
  UpdateChannelMessageResponse,
  CreateMediaCapturePipelineResponse,
  ListChannelMessagesResponse,
  GetProxySessionResponse,
  GetUserResponse,
  DescribeAppInstanceAdminResponse,
  ListChannelMembershipsForAppInstanceUserResponse,
  DeleteAppInstanceStreamingConfigurationsResponse,
  BatchCreateChannelMembershipResponse,
  ChannelModeratedByAppInstanceUserSummary,
  DeleteChannelMessageResponse,
  CreateMeetingWithAttendeesResponse,
  ProxySession,
  DeleteRoomMembershipResponse,
  ListAttendeeTagsResponse,
  InviteUsersResponse,
  DeleteVoiceConnectorEmergencyCallingConfigurationResponse,
  DescribeChannelMembershipResponse,
  ChannelSummary,
  ListChannelMembershipsResponse,
  AssociatePhoneNumberWithUserResponse,
  UpdateBotResponse,
  ListTagsForResourceResponse,
  UpdateRoomResponse,
  UpdateSipMediaApplicationCallResponse,
  SipRule,
  UntagResourceResponse,
  CreateRoomMembershipResponse,
  CreateMeetingDialOutResponse,
  Meeting,
  GetRoomResponse,
  CreateVoiceConnectorResponse,
  UpdateAppInstanceResponse,
  DeleteVoiceConnectorGroupResponse,
  UntagMeetingResponse,
  PutVoiceConnectorProxyResponse,
  RoomMembership,
  DescribeChannelModeratorResponse,
  UpdateGlobalSettingsResponse,
  GetMeetingResponse,
  DisassociatePhoneNumberFromUserResponse,
  GetVoiceConnectorOriginationResponse,
  ListSupportedPhoneNumberCountriesResponse,
  GetRetentionSettingsResponse,
  DeleteVoiceConnectorResponse,
  DisassociatePhoneNumbersFromVoiceConnectorResponse,
  CreateUserResponse,
  DeleteChannelModeratorResponse,
  CreateMeetingResponse,
  ListChannelBansResponse,
  UpdateUserSettingsResponse,
  DeleteAppInstanceAdminResponse,
  GetEventsConfigurationResponse,
  CreateVoiceConnectorGroupResponse,
  UpdateAccountSettingsResponse,
  DeleteChannelMembershipResponse,
  CreateAppInstanceResponse,
  PutVoiceConnectorStreamingConfigurationResponse,
  GetVoiceConnectorResponse,
  UpdateProxySessionResponse,
  BatchSuspendUserResponse,
  GetSipMediaApplicationLoggingConfigurationResponse,
  AppInstanceSummary,
  UpdateRoomMembershipResponse,
  PhoneNumber,
  SendChannelMessageResponse,
  DeleteMediaCapturePipelineResponse,
  ListBotsResponse,
  GetGlobalSettingsResponse,
  StartMeetingTranscriptionResponse,
  ListSipRulesResponse,
  GetAccountSettingsResponse,
  UpdateVoiceConnectorResponse,
  GetMessagingSessionEndpointResponse,
  DisassociateSigninDelegateGroupsFromAccountResponse,
  DeleteVoiceConnectorProxyResponse,
  GetChannelMessageResponse,
  ListVoiceConnectorGroupsResponse,
  UpdatePhoneNumberResponse,
  RedactChannelMessageResponse,
  CreateAppInstanceAdminResponse,
  DescribeChannelBanResponse,
  DescribeAppInstanceResponse,
  BatchUpdateUserResponse,
  VoiceConnector,
  PutVoiceConnectorTerminationCredentialsResponse,
  RedactConversationMessageResponse,
  ListPhoneNumbersResponse,
  UpdatePhoneNumberSettingsResponse,
  GetGlobalSettingsRequest,
  DisassociatePhoneNumbersFromVoiceConnectorGroupResponse,
  GetPhoneNumberResponse,
  CreateSipRuleResponse,
  UpdateAppInstanceUserResponse,
  CreateBotResponse,
  ListVoiceConnectorTerminationCredentialsResponse,
  AppInstanceAdminSummary,
  UpdateChannelReadMarkerResponse,
  BatchUpdatePhoneNumberResponse,
  GetPhoneNumberOrderResponse,
  CreateChannelMembershipResponse,
  GetMediaCapturePipelineResponse,
  CreateChannelBanResponse,
  ListRoomMembershipsResponse,
  DeleteRoomResponse,
  Attendee,
  ListAttendeesResponse,
  ListMediaCapturePipelinesResponse,
  UpdateUserResponse,
  ListMeetingsResponse,
  GetSipRuleResponse,
  GetBotResponse,
  TagResourceResponse,
  ListAppInstanceAdminsResponse,
  DeleteVoiceConnectorStreamingConfigurationResponse,
  DeleteEventsConfigurationResponse,
  DescribeAppInstanceUserResponse,
  StopMeetingTranscriptionResponse,
  DeleteChannelResponse,
  CreateAppInstanceUserResponse,
  TagMeetingResponse,
  DeleteSipMediaApplicationResponse,
  Bot,
  PutVoiceConnectorOriginationResponse,
  GetUserSettingsResponse,
  GetVoiceConnectorStreamingConfigurationResponse,
  DeleteAppInstanceUserResponse,
  PutVoiceConnectorTerminationResponse,
  CreateRoomResponse,
  RestorePhoneNumberResponse,
  RegenerateSecurityTokenResponse,
  ListSipMediaApplicationsResponse,
  CreateChannelModeratorResponse,
  ChannelMembershipForAppInstanceUserSummary,
  BatchUnsuspendUserResponse,
  GetVoiceConnectorLoggingConfigurationResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import zio.aws.chime.model.primitives.E164PhoneNumber
import software.amazon.awssdk.services.chime.{
  ChimeAsyncClientBuilder,
  ChimeAsyncClient
}
import scala.jdk.CollectionConverters._
trait Chime extends AspectSupport[Chime] {
  val api: ChimeAsyncClient
  def listSipMediaApplications(
      request: ListSipMediaApplicationsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.SipMediaApplication.ReadOnly]
  def listSipMediaApplicationsPaginated(
      request: ListSipMediaApplicationsRequest
  ): IO[AwsError, zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly]
  def redactConversationMessage(request: RedactConversationMessageRequest): IO[
    AwsError,
    zio.aws.chime.model.RedactConversationMessageResponse.ReadOnly
  ]
  def updateAccount(
      request: UpdateAccountRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateAccountResponse.ReadOnly]
  def describeAppInstance(
      request: DescribeAppInstanceRequest
  ): IO[AwsError, zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly]
  def describeChannelMembership(request: DescribeChannelMembershipRequest): IO[
    AwsError,
    zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly
  ]
  def listAppInstanceUsers(
      request: ListAppInstanceUsersRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly,
    zio.aws.chime.model.AppInstanceUserSummary.ReadOnly
  ]]
  def listAppInstanceUsersPaginated(
      request: ListAppInstanceUsersRequest
  ): IO[AwsError, zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly]
  def putVoiceConnectorEmergencyCallingConfiguration(
      request: PutVoiceConnectorEmergencyCallingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ]
  def updateRoomMembership(
      request: UpdateRoomMembershipRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateRoomMembershipResponse.ReadOnly]
  def deleteSipRule(request: DeleteSipRuleRequest): IO[AwsError, Unit]
  def putVoiceConnectorProxy(
      request: PutVoiceConnectorProxyRequest
  ): IO[AwsError, zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly]
  def listUsers(
      request: ListUsersRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.User.ReadOnly]
  def listUsersPaginated(
      request: ListUsersRequest
  ): IO[AwsError, zio.aws.chime.model.ListUsersResponse.ReadOnly]
  def createVoiceConnector(
      request: CreateVoiceConnectorRequest
  ): IO[AwsError, zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly]
  def updateAppInstance(
      request: UpdateAppInstanceRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly]
  def updateUser(
      request: UpdateUserRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateUserResponse.ReadOnly]
  def createAppInstanceUser(
      request: CreateAppInstanceUserRequest
  ): IO[AwsError, zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly]
  def listChannels(
      request: ListChannelsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.ChannelSummary.ReadOnly]
  def listChannelsPaginated(
      request: ListChannelsRequest
  ): IO[AwsError, zio.aws.chime.model.ListChannelsResponse.ReadOnly]
  def restorePhoneNumber(
      request: RestorePhoneNumberRequest
  ): IO[AwsError, zio.aws.chime.model.RestorePhoneNumberResponse.ReadOnly]
  def putSipMediaApplicationLoggingConfiguration(
      request: PutSipMediaApplicationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ]
  def listAppInstanceAdmins(
      request: ListAppInstanceAdminsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly,
    zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly
  ]]
  def listAppInstanceAdminsPaginated(
      request: ListAppInstanceAdminsRequest
  ): IO[AwsError, zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly]
  def getVoiceConnector(
      request: GetVoiceConnectorRequest
  ): IO[AwsError, zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly]
  def createAccount(
      request: CreateAccountRequest
  ): IO[AwsError, zio.aws.chime.model.CreateAccountResponse.ReadOnly]
  def disassociatePhoneNumbersFromVoiceConnector(
      request: DisassociatePhoneNumbersFromVoiceConnectorRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
  ]
  def updateBot(
      request: UpdateBotRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateBotResponse.ReadOnly]
  def updateVoiceConnectorGroup(request: UpdateVoiceConnectorGroupRequest): IO[
    AwsError,
    zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly
  ]
  def listSupportedPhoneNumberCountries(
      request: ListSupportedPhoneNumberCountriesRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
  ]
  def deleteChannelModerator(
      request: DeleteChannelModeratorRequest
  ): IO[AwsError, Unit]
  def getVoiceConnectorProxy(
      request: GetVoiceConnectorProxyRequest
  ): IO[AwsError, zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly]
  def listAttendees(
      request: ListAttendeesRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.Attendee.ReadOnly]
  def listAttendeesPaginated(
      request: ListAttendeesRequest
  ): IO[AwsError, zio.aws.chime.model.ListAttendeesResponse.ReadOnly]
  def batchSuspendUser(
      request: BatchSuspendUserRequest
  ): IO[AwsError, zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly]
  def describeAppInstanceUser(
      request: DescribeAppInstanceUserRequest
  ): IO[AwsError, zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly]
  def deleteRoomMembership(
      request: DeleteRoomMembershipRequest
  ): IO[AwsError, Unit]
  def listVoiceConnectors(
      request: ListVoiceConnectorsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.VoiceConnector.ReadOnly]
  def listVoiceConnectorsPaginated(
      request: ListVoiceConnectorsRequest
  ): IO[AwsError, zio.aws.chime.model.ListVoiceConnectorsResponse.ReadOnly]
  def getMeeting(
      request: GetMeetingRequest
  ): IO[AwsError, zio.aws.chime.model.GetMeetingResponse.ReadOnly]
  def associatePhoneNumberWithUser(
      request: AssociatePhoneNumberWithUserRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.AssociatePhoneNumberWithUserResponse.ReadOnly
  ]
  def describeChannelModeratedByAppInstanceUser(
      request: DescribeChannelModeratedByAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
  ]
  def updateSipRule(
      request: UpdateSipRuleRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly]
  def listAccounts(
      request: ListAccountsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.Account.ReadOnly]
  def listAccountsPaginated(
      request: ListAccountsRequest
  ): IO[AwsError, zio.aws.chime.model.ListAccountsResponse.ReadOnly]
  def listChannelMembershipsForAppInstanceUser(
      request: ListChannelMembershipsForAppInstanceUserRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
  ]
  def listChannelMembershipsForAppInstanceUserPaginated(
      request: ListChannelMembershipsForAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
  ]
  def disassociateSigninDelegateGroupsFromAccount(
      request: DisassociateSigninDelegateGroupsFromAccountRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse.ReadOnly
  ]
  def putAppInstanceRetentionSettings(
      request: PutAppInstanceRetentionSettingsRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly
  ]
  def getMediaCapturePipeline(
      request: GetMediaCapturePipelineRequest
  ): IO[AwsError, zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly]
  def getVoiceConnectorTermination(
      request: GetVoiceConnectorTerminationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly
  ]
  def sendChannelMessage(
      request: SendChannelMessageRequest
  ): IO[AwsError, zio.aws.chime.model.SendChannelMessageResponse.ReadOnly]
  def associatePhoneNumbersWithVoiceConnector(
      request: AssociatePhoneNumbersWithVoiceConnectorRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
  ]
  def createPhoneNumberOrder(
      request: CreatePhoneNumberOrderRequest
  ): IO[AwsError, zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly]
  def deleteVoiceConnectorEmergencyCallingConfiguration(
      request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ): IO[AwsError, Unit]
  def deleteChannelMembership(
      request: DeleteChannelMembershipRequest
  ): IO[AwsError, Unit]
  def createAppInstance(
      request: CreateAppInstanceRequest
  ): IO[AwsError, zio.aws.chime.model.CreateAppInstanceResponse.ReadOnly]
  def updateRoom(
      request: UpdateRoomRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateRoomResponse.ReadOnly]
  def getSipMediaApplicationLoggingConfiguration(
      request: GetSipMediaApplicationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ]
  def getProxySession(
      request: GetProxySessionRequest
  ): IO[AwsError, zio.aws.chime.model.GetProxySessionResponse.ReadOnly]
  def deletePhoneNumber(request: DeletePhoneNumberRequest): IO[AwsError, Unit]
  def listPhoneNumberOrders(
      request: ListPhoneNumberOrdersRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.PhoneNumberOrder.ReadOnly]
  def listPhoneNumberOrdersPaginated(
      request: ListPhoneNumberOrdersRequest
  ): IO[AwsError, zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly]
  def batchCreateRoomMembership(
      request: BatchCreateRoomMembershipRequest
  ): IO[AwsError, ReadOnly]
  def tagMeeting(request: TagMeetingRequest): IO[AwsError, Unit]
  def deleteAppInstanceAdmin(
      request: DeleteAppInstanceAdminRequest
  ): IO[AwsError, Unit]
  def deleteAccount(
      request: DeleteAccountRequest
  ): IO[AwsError, zio.aws.chime.model.DeleteAccountResponse.ReadOnly]
  def batchCreateAttendee(
      request: BatchCreateAttendeeRequest
  ): IO[AwsError, zio.aws.chime.model.BatchCreateAttendeeResponse.ReadOnly]
  def deleteSipMediaApplication(
      request: DeleteSipMediaApplicationRequest
  ): IO[AwsError, Unit]
  def getAccount(
      request: GetAccountRequest
  ): IO[AwsError, zio.aws.chime.model.GetAccountResponse.ReadOnly]
  def listProxySessions(
      request: ListProxySessionsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.ProxySession.ReadOnly]
  def listProxySessionsPaginated(
      request: ListProxySessionsRequest
  ): IO[AwsError, zio.aws.chime.model.ListProxySessionsResponse.ReadOnly]
  def describeAppInstanceAdmin(
      request: DescribeAppInstanceAdminRequest
  ): IO[AwsError, zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly]
  def getEventsConfiguration(
      request: GetEventsConfigurationRequest
  ): IO[AwsError, zio.aws.chime.model.GetEventsConfigurationResponse.ReadOnly]
  def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit]
  def deleteVoiceConnectorProxy(
      request: DeleteVoiceConnectorProxyRequest
  ): IO[AwsError, Unit]
  def createRoomMembership(
      request: CreateRoomMembershipRequest
  ): IO[AwsError, zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly]
  def updateAppInstanceUser(
      request: UpdateAppInstanceUserRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly]
  def getUser(
      request: GetUserRequest
  ): IO[AwsError, zio.aws.chime.model.GetUserResponse.ReadOnly]
  def getPhoneNumberOrder(
      request: GetPhoneNumberOrderRequest
  ): IO[AwsError, zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly]
  def deleteEventsConfiguration(
      request: DeleteEventsConfigurationRequest
  ): IO[AwsError, Unit]
  def updateVoiceConnector(
      request: UpdateVoiceConnectorRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateVoiceConnectorResponse.ReadOnly]
  def batchUpdateUser(
      request: BatchUpdateUserRequest
  ): IO[AwsError, zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly]
  def untagAttendee(request: UntagAttendeeRequest): IO[AwsError, Unit]
  def getSipMediaApplication(
      request: GetSipMediaApplicationRequest
  ): IO[AwsError, zio.aws.chime.model.GetSipMediaApplicationResponse.ReadOnly]
  def listChannelBans(
      request: ListChannelBansRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelBansResponse.ReadOnly,
    zio.aws.chime.model.ChannelBanSummary.ReadOnly
  ]]
  def listChannelBansPaginated(
      request: ListChannelBansRequest
  ): IO[AwsError, zio.aws.chime.model.ListChannelBansResponse.ReadOnly]
  def redactRoomMessage(
      request: RedactRoomMessageRequest
  ): IO[AwsError, zio.aws.chime.model.RedactRoomMessageResponse.ReadOnly]
  def updateSipMediaApplicationCall(
      request: UpdateSipMediaApplicationCallRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly
  ]
  def getUserSettings(
      request: GetUserSettingsRequest
  ): IO[AwsError, zio.aws.chime.model.GetUserSettingsResponse.ReadOnly]
  def createUser(
      request: CreateUserRequest
  ): IO[AwsError, zio.aws.chime.model.CreateUserResponse.ReadOnly]
  def listChannelMessages(
      request: ListChannelMessagesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly,
    zio.aws.chime.model.ChannelMessageSummary.ReadOnly
  ]]
  def listChannelMessagesPaginated(
      request: ListChannelMessagesRequest
  ): IO[AwsError, zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly]
  def deleteVoiceConnectorOrigination(
      request: DeleteVoiceConnectorOriginationRequest
  ): IO[AwsError, Unit]
  def listPhoneNumbers(
      request: ListPhoneNumbersRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.PhoneNumber.ReadOnly]
  def listPhoneNumbersPaginated(
      request: ListPhoneNumbersRequest
  ): IO[AwsError, zio.aws.chime.model.ListPhoneNumbersResponse.ReadOnly]
  def deleteVoiceConnectorTerminationCredentials(
      request: DeleteVoiceConnectorTerminationCredentialsRequest
  ): IO[AwsError, Unit]
  def associateSigninDelegateGroupsWithAccount(
      request: AssociateSigninDelegateGroupsWithAccountRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountResponse.ReadOnly
  ]
  def updatePhoneNumber(
      request: UpdatePhoneNumberRequest
  ): IO[AwsError, zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly]
  def createChannelMembership(
      request: CreateChannelMembershipRequest
  ): IO[AwsError, zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly]
  def deleteMeeting(request: DeleteMeetingRequest): IO[AwsError, Unit]
  def tagAttendee(request: TagAttendeeRequest): IO[AwsError, Unit]
  def inviteUsers(
      request: InviteUsersRequest
  ): IO[AwsError, zio.aws.chime.model.InviteUsersResponse.ReadOnly]
  def getVoiceConnectorTerminationHealth(
      request: GetVoiceConnectorTerminationHealthRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
  ]
  def getPhoneNumber(
      request: GetPhoneNumberRequest
  ): IO[AwsError, zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly]
  def updateUserSettings(request: UpdateUserSettingsRequest): IO[AwsError, Unit]
  def resetPersonalPIN(
      request: ResetPersonalPinRequest
  ): IO[AwsError, zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly]
  def createChannel(
      request: CreateChannelRequest
  ): IO[AwsError, zio.aws.chime.model.CreateChannelResponse.ReadOnly]
  def describeChannelBan(
      request: DescribeChannelBanRequest
  ): IO[AwsError, zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly]
  def listChannelMemberships(
      request: ListChannelMembershipsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly,
    zio.aws.chime.model.ChannelMembershipSummary.ReadOnly
  ]]
  def listChannelMembershipsPaginated(
      request: ListChannelMembershipsRequest
  ): IO[AwsError, zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly]
  def batchCreateChannelMembership(
      request: BatchCreateChannelMembershipRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly
  ]
  def putVoiceConnectorLoggingConfiguration(
      request: PutVoiceConnectorLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ]
  def logoutUser(
      request: LogoutUserRequest
  ): IO[AwsError, zio.aws.chime.model.LogoutUserResponse.ReadOnly]
  def searchAvailablePhoneNumbers(
      request: SearchAvailablePhoneNumbersRequest
  ): ZStream[Any, AwsError, E164PhoneNumber]
  def searchAvailablePhoneNumbersPaginated(
      request: SearchAvailablePhoneNumbersRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly
  ]
  def listVoiceConnectorTerminationCredentials(
      request: ListVoiceConnectorTerminationCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
  ]
  def updateChannelReadMarker(
      request: UpdateChannelReadMarkerRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly]
  def deleteAppInstanceUser(
      request: DeleteAppInstanceUserRequest
  ): IO[AwsError, Unit]
  def createChannelModerator(
      request: CreateChannelModeratorRequest
  ): IO[AwsError, zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def getAppInstanceStreamingConfigurations(
      request: GetAppInstanceStreamingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetAppInstanceStreamingConfigurationsResponse.ReadOnly
  ]
  def updateSipMediaApplication(request: UpdateSipMediaApplicationRequest): IO[
    AwsError,
    zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly
  ]
  def disassociatePhoneNumberFromUser(
      request: DisassociatePhoneNumberFromUserRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.DisassociatePhoneNumberFromUserResponse.ReadOnly
  ]
  def getChannelMessage(
      request: GetChannelMessageRequest
  ): IO[AwsError, zio.aws.chime.model.GetChannelMessageResponse.ReadOnly]
  def putRetentionSettings(
      request: PutRetentionSettingsRequest
  ): IO[AwsError, zio.aws.chime.model.PutRetentionSettingsResponse.ReadOnly]
  def deleteAppInstance(request: DeleteAppInstanceRequest): IO[AwsError, Unit]
  def createAppInstanceAdmin(
      request: CreateAppInstanceAdminRequest
  ): IO[AwsError, zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly]
  def getSipRule(
      request: GetSipRuleRequest
  ): IO[AwsError, zio.aws.chime.model.GetSipRuleResponse.ReadOnly]
  def createChannelBan(
      request: CreateChannelBanRequest
  ): IO[AwsError, zio.aws.chime.model.CreateChannelBanResponse.ReadOnly]
  def untagMeeting(request: UntagMeetingRequest): IO[AwsError, Unit]
  def updatePhoneNumberSettings(
      request: UpdatePhoneNumberSettingsRequest
  ): IO[AwsError, Unit]
  def deleteChannelMessage(
      request: DeleteChannelMessageRequest
  ): IO[AwsError, Unit]
  def createRoom(
      request: CreateRoomRequest
  ): IO[AwsError, zio.aws.chime.model.CreateRoomResponse.ReadOnly]
  def deleteRoom(request: DeleteRoomRequest): IO[AwsError, Unit]
  def listBots(
      request: ListBotsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.Bot.ReadOnly]
  def listBotsPaginated(
      request: ListBotsRequest
  ): IO[AwsError, zio.aws.chime.model.ListBotsResponse.ReadOnly]
  def getVoiceConnectorStreamingConfiguration(
      request: GetVoiceConnectorStreamingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ]
  def createVoiceConnectorGroup(request: CreateVoiceConnectorGroupRequest): IO[
    AwsError,
    zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly
  ]
  def deleteProxySession(request: DeleteProxySessionRequest): IO[AwsError, Unit]
  def redactChannelMessage(
      request: RedactChannelMessageRequest
  ): IO[AwsError, zio.aws.chime.model.RedactChannelMessageResponse.ReadOnly]
  def createBot(
      request: CreateBotRequest
  ): IO[AwsError, zio.aws.chime.model.CreateBotResponse.ReadOnly]
  def listMeetings(
      request: ListMeetingsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.Meeting.ReadOnly]
  def listMeetingsPaginated(
      request: ListMeetingsRequest
  ): IO[AwsError, zio.aws.chime.model.ListMeetingsResponse.ReadOnly]
  def deleteAttendee(request: DeleteAttendeeRequest): IO[AwsError, Unit]
  def deleteChannelBan(request: DeleteChannelBanRequest): IO[AwsError, Unit]
  def listSipRules(
      request: ListSipRulesRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.SipRule.ReadOnly]
  def listSipRulesPaginated(
      request: ListSipRulesRequest
  ): IO[AwsError, zio.aws.chime.model.ListSipRulesResponse.ReadOnly]
  def getAttendee(
      request: GetAttendeeRequest
  ): IO[AwsError, zio.aws.chime.model.GetAttendeeResponse.ReadOnly]
  def describeChannelModerator(
      request: DescribeChannelModeratorRequest
  ): IO[AwsError, zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly]
  def batchUnsuspendUser(
      request: BatchUnsuspendUserRequest
  ): IO[AwsError, zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly]
  def describeChannelMembershipForAppInstanceUser(
      request: DescribeChannelMembershipForAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
  ]
  def getGlobalSettings()
      : IO[AwsError, zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.chime.model.ListTagsForResourceResponse.ReadOnly]
  def createMeeting(
      request: CreateMeetingRequest
  ): IO[AwsError, zio.aws.chime.model.CreateMeetingResponse.ReadOnly]
  def putVoiceConnectorTermination(
      request: PutVoiceConnectorTerminationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly
  ]
  def startMeetingTranscription(request: StartMeetingTranscriptionRequest): IO[
    AwsError,
    zio.aws.chime.model.StartMeetingTranscriptionResponse.ReadOnly
  ]
  def associatePhoneNumbersWithVoiceConnectorGroup(
      request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
  ]
  def listAppInstances(
      request: ListAppInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.AppInstanceSummary.ReadOnly]
  def listAppInstancesPaginated(
      request: ListAppInstancesRequest
  ): IO[AwsError, zio.aws.chime.model.ListAppInstancesResponse.ReadOnly]
  def createMeetingDialOut(
      request: CreateMeetingDialOutRequest
  ): IO[AwsError, zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly]
  def putEventsConfiguration(
      request: PutEventsConfigurationRequest
  ): IO[AwsError, zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def batchDeletePhoneNumber(
      request: BatchDeletePhoneNumberRequest
  ): IO[AwsError, zio.aws.chime.model.BatchDeletePhoneNumberResponse.ReadOnly]
  def createMeetingWithAttendees(
      request: CreateMeetingWithAttendeesRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly
  ]
  def disassociatePhoneNumbersFromVoiceConnectorGroup(
      request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
  ]
  def describeChannel(
      request: DescribeChannelRequest
  ): IO[AwsError, zio.aws.chime.model.DescribeChannelResponse.ReadOnly]
  def updateAccountSettings(
      request: UpdateAccountSettingsRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateAccountSettingsResponse.ReadOnly]
  def deleteAppInstanceStreamingConfigurations(
      request: DeleteAppInstanceStreamingConfigurationsRequest
  ): IO[AwsError, Unit]
  def listMeetingTags(
      request: ListMeetingTagsRequest
  ): IO[AwsError, zio.aws.chime.model.ListMeetingTagsResponse.ReadOnly]
  def putVoiceConnectorTerminationCredentials(
      request: PutVoiceConnectorTerminationCredentialsRequest
  ): IO[AwsError, Unit]
  def createSipMediaApplicationCall(
      request: CreateSipMediaApplicationCallRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.CreateSipMediaApplicationCallResponse.ReadOnly
  ]
  def getRoom(
      request: GetRoomRequest
  ): IO[AwsError, zio.aws.chime.model.GetRoomResponse.ReadOnly]
  def getVoiceConnectorLoggingConfiguration(
      request: GetVoiceConnectorLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ]
  def deleteVoiceConnectorGroup(
      request: DeleteVoiceConnectorGroupRequest
  ): IO[AwsError, Unit]
  def putVoiceConnectorStreamingConfiguration(
      request: PutVoiceConnectorStreamingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ]
  def getVoiceConnectorEmergencyCallingConfiguration(
      request: GetVoiceConnectorEmergencyCallingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ]
  def regenerateSecurityToken(
      request: RegenerateSecurityTokenRequest
  ): IO[AwsError, zio.aws.chime.model.RegenerateSecurityTokenResponse.ReadOnly]
  def deleteVoiceConnectorTermination(
      request: DeleteVoiceConnectorTerminationRequest
  ): IO[AwsError, Unit]
  def getBot(
      request: GetBotRequest
  ): IO[AwsError, zio.aws.chime.model.GetBotResponse.ReadOnly]
  def deleteVoiceConnectorStreamingConfiguration(
      request: DeleteVoiceConnectorStreamingConfigurationRequest
  ): IO[AwsError, Unit]
  def putVoiceConnectorOrigination(
      request: PutVoiceConnectorOriginationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly
  ]
  def listChannelModerators(
      request: ListChannelModeratorsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly,
    zio.aws.chime.model.ChannelModeratorSummary.ReadOnly
  ]]
  def listChannelModeratorsPaginated(
      request: ListChannelModeratorsRequest
  ): IO[AwsError, zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly]
  def getPhoneNumberSettings(): IO[
    AwsError,
    zio.aws.chime.model.GetPhoneNumberSettingsResponse.ReadOnly
  ]
  def getAccountSettings(
      request: GetAccountSettingsRequest
  ): IO[AwsError, zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly]
  def createMediaCapturePipeline(
      request: CreateMediaCapturePipelineRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly
  ]
  def updateProxySession(
      request: UpdateProxySessionRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly]
  def updateGlobalSettings(
      request: UpdateGlobalSettingsRequest
  ): IO[AwsError, Unit]
  def listChannelsModeratedByAppInstanceUser(
      request: ListChannelsModeratedByAppInstanceUserRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
  ]
  def listChannelsModeratedByAppInstanceUserPaginated(
      request: ListChannelsModeratedByAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
  ]
  def updateChannelMessage(
      request: UpdateChannelMessageRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateChannelMessageResponse.ReadOnly]
  def getMessagingSessionEndpoint(
      request: GetMessagingSessionEndpointRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetMessagingSessionEndpointResponse.ReadOnly
  ]
  def listVoiceConnectorGroups(
      request: ListVoiceConnectorGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.VoiceConnectorGroup.ReadOnly]
  def listVoiceConnectorGroupsPaginated(
      request: ListVoiceConnectorGroupsRequest
  ): IO[AwsError, zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly]
  def createSipRule(
      request: CreateSipRuleRequest
  ): IO[AwsError, zio.aws.chime.model.CreateSipRuleResponse.ReadOnly]
  def listRooms(
      request: ListRoomsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.Room.ReadOnly]
  def listRoomsPaginated(
      request: ListRoomsRequest
  ): IO[AwsError, zio.aws.chime.model.ListRoomsResponse.ReadOnly]
  def getVoiceConnectorGroup(
      request: GetVoiceConnectorGroupRequest
  ): IO[AwsError, zio.aws.chime.model.GetVoiceConnectorGroupResponse.ReadOnly]
  def createProxySession(
      request: CreateProxySessionRequest
  ): IO[AwsError, zio.aws.chime.model.CreateProxySessionResponse.ReadOnly]
  def deleteMediaCapturePipeline(
      request: DeleteMediaCapturePipelineRequest
  ): IO[AwsError, Unit]
  def getAppInstanceRetentionSettings(
      request: GetAppInstanceRetentionSettingsRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetAppInstanceRetentionSettingsResponse.ReadOnly
  ]
  def stopMeetingTranscription(
      request: StopMeetingTranscriptionRequest
  ): IO[AwsError, zio.aws.chime.model.StopMeetingTranscriptionResponse.ReadOnly]
  def getVoiceConnectorOrigination(
      request: GetVoiceConnectorOriginationRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorOriginationResponse.ReadOnly
  ]
  def listRoomMemberships(
      request: ListRoomMembershipsRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.RoomMembership.ReadOnly]
  def listRoomMembershipsPaginated(
      request: ListRoomMembershipsRequest
  ): IO[AwsError, zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly]
  def createSipMediaApplication(request: CreateSipMediaApplicationRequest): IO[
    AwsError,
    zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly
  ]
  def createAttendee(
      request: CreateAttendeeRequest
  ): IO[AwsError, zio.aws.chime.model.CreateAttendeeResponse.ReadOnly]
  def listAttendeeTags(
      request: ListAttendeeTagsRequest
  ): IO[AwsError, zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly]
  def updateChannel(
      request: UpdateChannelRequest
  ): IO[AwsError, zio.aws.chime.model.UpdateChannelResponse.ReadOnly]
  def listMediaCapturePipelines(
      request: ListMediaCapturePipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.chime.model.MediaCapturePipeline.ReadOnly]
  def listMediaCapturePipelinesPaginated(
      request: ListMediaCapturePipelinesRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly
  ]
  def deleteVoiceConnector(
      request: DeleteVoiceConnectorRequest
  ): IO[AwsError, Unit]
  def getRetentionSettings(
      request: GetRetentionSettingsRequest
  ): IO[AwsError, zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly]
  def batchUpdatePhoneNumber(
      request: BatchUpdatePhoneNumberRequest
  ): IO[AwsError, zio.aws.chime.model.BatchUpdatePhoneNumberResponse.ReadOnly]
  def putAppInstanceStreamingConfigurations(
      request: PutAppInstanceStreamingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly
  ]
}
object Chime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Chime] = customized(identity)
  def customized(
      customization: ChimeAsyncClientBuilder => ChimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Chime] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ChimeAsyncClientBuilder => ChimeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Chime] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ChimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[ChimeAsyncClient, ChimeAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[ChimeAsyncClient, ChimeAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new ChimeImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ChimeImpl[R](
      override val api: ChimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Chime
      with AwsServiceBase[R] {
    override val serviceName: String = "Chime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ChimeImpl[R1] = new ChimeImpl(api, newAspect, r)
    def listSipMediaApplications(
        request: ListSipMediaApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chime.model.SipMediaApplication.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest,
      ListSipMediaApplicationsResponse,
      SipMediaApplication
    ](
      "listSipMediaApplications",
      api.listSipMediaApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.sipMediaApplications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chime.model.SipMediaApplication.wrap(item))
      .provideEnvironment(r)
    def listSipMediaApplicationsPaginated(
        request: ListSipMediaApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest,
      ListSipMediaApplicationsResponse
    ]("listSipMediaApplications", api.listSipMediaApplications)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListSipMediaApplicationsResponse.wrap)
      .provideEnvironment(r)
    def redactConversationMessage(
        request: RedactConversationMessageRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.RedactConversationMessageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.RedactConversationMessageRequest,
      RedactConversationMessageResponse
    ]("redactConversationMessage", api.redactConversationMessage)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.RedactConversationMessageResponse.wrap)
      .provideEnvironment(r)
    def updateAccount(
        request: UpdateAccountRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateAccountRequest,
        UpdateAccountResponse
      ]("updateAccount", api.updateAccount)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateAccountResponse.wrap)
        .provideEnvironment(r)
    def describeAppInstance(
        request: DescribeAppInstanceRequest
    ): IO[AwsError, zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DescribeAppInstanceRequest,
        DescribeAppInstanceResponse
      ]("describeAppInstance", api.describeAppInstance)(request.buildAwsValue())
        .map(zio.aws.chime.model.DescribeAppInstanceResponse.wrap)
        .provideEnvironment(r)
    def describeChannelMembership(
        request: DescribeChannelMembershipRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DescribeChannelMembershipRequest,
      DescribeChannelMembershipResponse
    ]("describeChannelMembership", api.describeChannelMembership)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.DescribeChannelMembershipResponse.wrap)
      .provideEnvironment(r)
    def listAppInstanceUsers(
        request: ListAppInstanceUsersRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly,
      zio.aws.chime.model.AppInstanceUserSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListAppInstanceUsersRequest,
      ListAppInstanceUsersResponse,
      AppInstanceUserSummary
    ](
      "listAppInstanceUsers",
      api.listAppInstanceUsers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.appInstanceUsers().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.chime.model.ListAppInstanceUsersResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.chime.model.AppInstanceUserSummary.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listAppInstanceUsersPaginated(
        request: ListAppInstanceUsersRequest
    ): IO[AwsError, zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListAppInstanceUsersRequest,
        ListAppInstanceUsersResponse
      ]("listAppInstanceUsers", api.listAppInstanceUsers)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.ListAppInstanceUsersResponse.wrap)
        .provideEnvironment(r)
    def putVoiceConnectorEmergencyCallingConfiguration(
        request: PutVoiceConnectorEmergencyCallingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest,
      PutVoiceConnectorEmergencyCallingConfigurationResponse
    ](
      "putVoiceConnectorEmergencyCallingConfiguration",
      api.putVoiceConnectorEmergencyCallingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def updateRoomMembership(
        request: UpdateRoomMembershipRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateRoomMembershipResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateRoomMembershipRequest,
        UpdateRoomMembershipResponse
      ]("updateRoomMembership", api.updateRoomMembership)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.UpdateRoomMembershipResponse.wrap)
        .provideEnvironment(r)
    def deleteSipRule(request: DeleteSipRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteSipRuleRequest,
        DeleteSipRuleResponse
      ]("deleteSipRule", api.deleteSipRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def putVoiceConnectorProxy(request: PutVoiceConnectorProxyRequest): IO[
      AwsError,
      zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorProxyRequest,
      PutVoiceConnectorProxyResponse
    ]("putVoiceConnectorProxy", api.putVoiceConnectorProxy)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.PutVoiceConnectorProxyResponse.wrap)
      .provideEnvironment(r)
    def listUsers(
        request: ListUsersRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.User.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListUsersRequest,
        ListUsersResponse,
        User
      ](
        "listUsers",
        api.listUsers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.users().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.User.wrap(item))
        .provideEnvironment(r)
    def listUsersPaginated(
        request: ListUsersRequest
    ): IO[AwsError, zio.aws.chime.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListUsersRequest,
        ListUsersResponse
      ]("listUsers", api.listUsers)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def createVoiceConnector(
        request: CreateVoiceConnectorRequest
    ): IO[AwsError, zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest,
        CreateVoiceConnectorResponse
      ]("createVoiceConnector", api.createVoiceConnector)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.CreateVoiceConnectorResponse.wrap)
        .provideEnvironment(r)
    def updateAppInstance(
        request: UpdateAppInstanceRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateAppInstanceRequest,
        UpdateAppInstanceResponse
      ]("updateAppInstance", api.updateAppInstance)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateAppInstanceResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: UpdateUserRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateUserRequest,
        UpdateUserResponse
      ]("updateUser", api.updateUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def createAppInstanceUser(request: CreateAppInstanceUserRequest): IO[
      AwsError,
      zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateAppInstanceUserRequest,
      CreateAppInstanceUserResponse
    ]("createAppInstanceUser", api.createAppInstanceUser)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateAppInstanceUserResponse.wrap)
      .provideEnvironment(r)
    def listChannels(
        request: ListChannelsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.ChannelSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListChannelsRequest,
        ListChannelsResponse,
        ChannelSummary
      ](
        "listChannels",
        api.listChannels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.channels().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.ChannelSummary.wrap(item))
        .provideEnvironment(r)
    def listChannelsPaginated(
        request: ListChannelsRequest
    ): IO[AwsError, zio.aws.chime.model.ListChannelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListChannelsRequest,
        ListChannelsResponse
      ]("listChannels", api.listChannels)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListChannelsResponse.wrap)
        .provideEnvironment(r)
    def restorePhoneNumber(
        request: RestorePhoneNumberRequest
    ): IO[AwsError, zio.aws.chime.model.RestorePhoneNumberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.RestorePhoneNumberRequest,
        RestorePhoneNumberResponse
      ]("restorePhoneNumber", api.restorePhoneNumber)(request.buildAwsValue())
        .map(zio.aws.chime.model.RestorePhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def putSipMediaApplicationLoggingConfiguration(
        request: PutSipMediaApplicationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest,
      PutSipMediaApplicationLoggingConfigurationResponse
    ](
      "putSipMediaApplicationLoggingConfiguration",
      api.putSipMediaApplicationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listAppInstanceAdmins(
        request: ListAppInstanceAdminsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly,
      zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest,
      ListAppInstanceAdminsResponse,
      AppInstanceAdminSummary
    ](
      "listAppInstanceAdmins",
      api.listAppInstanceAdmins,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.appInstanceAdmins().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.chime.model.ListAppInstanceAdminsResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.chime.model.AppInstanceAdminSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listAppInstanceAdminsPaginated(
        request: ListAppInstanceAdminsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListAppInstanceAdminsRequest,
      ListAppInstanceAdminsResponse
    ]("listAppInstanceAdmins", api.listAppInstanceAdmins)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListAppInstanceAdminsResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnector(
        request: GetVoiceConnectorRequest
    ): IO[AwsError, zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetVoiceConnectorRequest,
        GetVoiceConnectorResponse
      ]("getVoiceConnector", api.getVoiceConnector)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetVoiceConnectorResponse.wrap)
        .provideEnvironment(r)
    def createAccount(
        request: CreateAccountRequest
    ): IO[AwsError, zio.aws.chime.model.CreateAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateAccountRequest,
        CreateAccountResponse
      ]("createAccount", api.createAccount)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateAccountResponse.wrap)
        .provideEnvironment(r)
    def disassociatePhoneNumbersFromVoiceConnector(
        request: DisassociatePhoneNumbersFromVoiceConnectorRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest,
      DisassociatePhoneNumbersFromVoiceConnectorResponse
    ](
      "disassociatePhoneNumbersFromVoiceConnector",
      api.disassociatePhoneNumbersFromVoiceConnector
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.wrap
      )
      .provideEnvironment(r)
    def updateBot(
        request: UpdateBotRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateBotRequest,
        UpdateBotResponse
      ]("updateBot", api.updateBot)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateBotResponse.wrap)
        .provideEnvironment(r)
    def updateVoiceConnectorGroup(
        request: UpdateVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest,
      UpdateVoiceConnectorGroupResponse
    ]("updateVoiceConnectorGroup", api.updateVoiceConnectorGroup)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.wrap)
      .provideEnvironment(r)
    def listSupportedPhoneNumberCountries(
        request: ListSupportedPhoneNumberCountriesRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListSupportedPhoneNumberCountriesRequest,
      ListSupportedPhoneNumberCountriesResponse
    ](
      "listSupportedPhoneNumberCountries",
      api.listSupportedPhoneNumberCountries
    )(request.buildAwsValue())
      .map(zio.aws.chime.model.ListSupportedPhoneNumberCountriesResponse.wrap)
      .provideEnvironment(r)
    def deleteChannelModerator(
        request: DeleteChannelModeratorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteChannelModeratorRequest,
      DeleteChannelModeratorResponse
    ]("deleteChannelModerator", api.deleteChannelModerator)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getVoiceConnectorProxy(request: GetVoiceConnectorProxyRequest): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorProxyRequest,
      GetVoiceConnectorProxyResponse
    ]("getVoiceConnectorProxy", api.getVoiceConnectorProxy)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetVoiceConnectorProxyResponse.wrap)
      .provideEnvironment(r)
    def listAttendees(
        request: ListAttendeesRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.Attendee.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListAttendeesRequest,
        ListAttendeesResponse,
        Attendee
      ](
        "listAttendees",
        api.listAttendees,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.attendees().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.Attendee.wrap(item))
        .provideEnvironment(r)
    def listAttendeesPaginated(
        request: ListAttendeesRequest
    ): IO[AwsError, zio.aws.chime.model.ListAttendeesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListAttendeesRequest,
        ListAttendeesResponse
      ]("listAttendees", api.listAttendees)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListAttendeesResponse.wrap)
        .provideEnvironment(r)
    def batchSuspendUser(
        request: BatchSuspendUserRequest
    ): IO[AwsError, zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest,
        BatchSuspendUserResponse
      ]("batchSuspendUser", api.batchSuspendUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.BatchSuspendUserResponse.wrap)
        .provideEnvironment(r)
    def describeAppInstanceUser(request: DescribeAppInstanceUserRequest): IO[
      AwsError,
      zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserRequest,
      DescribeAppInstanceUserResponse
    ]("describeAppInstanceUser", api.describeAppInstanceUser)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.DescribeAppInstanceUserResponse.wrap)
      .provideEnvironment(r)
    def deleteRoomMembership(
        request: DeleteRoomMembershipRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteRoomMembershipRequest,
      DeleteRoomMembershipResponse
    ]("deleteRoomMembership", api.deleteRoomMembership)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listVoiceConnectors(
        request: ListVoiceConnectorsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.VoiceConnector.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest,
        ListVoiceConnectorsResponse,
        VoiceConnector
      ](
        "listVoiceConnectors",
        api.listVoiceConnectors,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.voiceConnectors().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.VoiceConnector.wrap(item))
        .provideEnvironment(r)
    def listVoiceConnectorsPaginated(
        request: ListVoiceConnectorsRequest
    ): IO[AwsError, zio.aws.chime.model.ListVoiceConnectorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListVoiceConnectorsRequest,
        ListVoiceConnectorsResponse
      ]("listVoiceConnectors", api.listVoiceConnectors)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListVoiceConnectorsResponse.wrap)
        .provideEnvironment(r)
    def getMeeting(
        request: GetMeetingRequest
    ): IO[AwsError, zio.aws.chime.model.GetMeetingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetMeetingRequest,
        GetMeetingResponse
      ]("getMeeting", api.getMeeting)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetMeetingResponse.wrap)
        .provideEnvironment(r)
    def associatePhoneNumberWithUser(
        request: AssociatePhoneNumberWithUserRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.AssociatePhoneNumberWithUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest,
      AssociatePhoneNumberWithUserResponse
    ]("associatePhoneNumberWithUser", api.associatePhoneNumberWithUser)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.AssociatePhoneNumberWithUserResponse.wrap)
      .provideEnvironment(r)
    def describeChannelModeratedByAppInstanceUser(
        request: DescribeChannelModeratedByAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest,
      DescribeChannelModeratedByAppInstanceUserResponse
    ](
      "describeChannelModeratedByAppInstanceUser",
      api.describeChannelModeratedByAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def updateSipRule(
        request: UpdateSipRuleRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateSipRuleRequest,
        UpdateSipRuleResponse
      ]("updateSipRule", api.updateSipRule)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateSipRuleResponse.wrap)
        .provideEnvironment(r)
    def listAccounts(
        request: ListAccountsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.Account.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListAccountsRequest,
        ListAccountsResponse,
        Account
      ](
        "listAccounts",
        api.listAccounts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.accounts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.Account.wrap(item))
        .provideEnvironment(r)
    def listAccountsPaginated(
        request: ListAccountsRequest
    ): IO[AwsError, zio.aws.chime.model.ListAccountsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListAccountsRequest,
        ListAccountsResponse
      ]("listAccounts", api.listAccounts)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListAccountsResponse.wrap)
        .provideEnvironment(r)
    def listChannelMembershipsForAppInstanceUser(
        request: ListChannelMembershipsForAppInstanceUserRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserRequest,
      ListChannelMembershipsForAppInstanceUserResponse,
      ChannelMembershipForAppInstanceUserSummary
    ](
      "listChannelMembershipsForAppInstanceUser",
      api.listChannelMembershipsForAppInstanceUser,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelMemberships().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listChannelMembershipsForAppInstanceUserPaginated(
        request: ListChannelMembershipsForAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListChannelMembershipsForAppInstanceUserRequest,
      ListChannelMembershipsForAppInstanceUserResponse
    ](
      "listChannelMembershipsForAppInstanceUser",
      api.listChannelMembershipsForAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateSigninDelegateGroupsFromAccount(
        request: DisassociateSigninDelegateGroupsFromAccountRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest,
      DisassociateSigninDelegateGroupsFromAccountResponse
    ](
      "disassociateSigninDelegateGroupsFromAccount",
      api.disassociateSigninDelegateGroupsFromAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse.wrap
      )
      .provideEnvironment(r)
    def putAppInstanceRetentionSettings(
        request: PutAppInstanceRetentionSettingsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutAppInstanceRetentionSettingsRequest,
      PutAppInstanceRetentionSettingsResponse
    ]("putAppInstanceRetentionSettings", api.putAppInstanceRetentionSettings)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.wrap)
      .provideEnvironment(r)
    def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): IO[
      AwsError,
      zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineRequest,
      GetMediaCapturePipelineResponse
    ]("getMediaCapturePipeline", api.getMediaCapturePipeline)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetMediaCapturePipelineResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnectorTermination(
        request: GetVoiceConnectorTerminationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationRequest,
      GetVoiceConnectorTerminationResponse
    ]("getVoiceConnectorTermination", api.getVoiceConnectorTermination)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetVoiceConnectorTerminationResponse.wrap)
      .provideEnvironment(r)
    def sendChannelMessage(
        request: SendChannelMessageRequest
    ): IO[AwsError, zio.aws.chime.model.SendChannelMessageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.SendChannelMessageRequest,
        SendChannelMessageResponse
      ]("sendChannelMessage", api.sendChannelMessage)(request.buildAwsValue())
        .map(zio.aws.chime.model.SendChannelMessageResponse.wrap)
        .provideEnvironment(r)
    def associatePhoneNumbersWithVoiceConnector(
        request: AssociatePhoneNumbersWithVoiceConnectorRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorRequest,
      AssociatePhoneNumbersWithVoiceConnectorResponse
    ](
      "associatePhoneNumbersWithVoiceConnector",
      api.associatePhoneNumbersWithVoiceConnector
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse.wrap
      )
      .provideEnvironment(r)
    def createPhoneNumberOrder(request: CreatePhoneNumberOrderRequest): IO[
      AwsError,
      zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest,
      CreatePhoneNumberOrderResponse
    ]("createPhoneNumberOrder", api.createPhoneNumberOrder)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreatePhoneNumberOrderResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnectorEmergencyCallingConfiguration(
        request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
      DeleteVoiceConnectorEmergencyCallingConfigurationResponse
    ](
      "deleteVoiceConnectorEmergencyCallingConfiguration",
      api.deleteVoiceConnectorEmergencyCallingConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteChannelMembership(
        request: DeleteChannelMembershipRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteChannelMembershipRequest,
      DeleteChannelMembershipResponse
    ]("deleteChannelMembership", api.deleteChannelMembership)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createAppInstance(
        request: CreateAppInstanceRequest
    ): IO[AwsError, zio.aws.chime.model.CreateAppInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateAppInstanceRequest,
        CreateAppInstanceResponse
      ]("createAppInstance", api.createAppInstance)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateAppInstanceResponse.wrap)
        .provideEnvironment(r)
    def updateRoom(
        request: UpdateRoomRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateRoomResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateRoomRequest,
        UpdateRoomResponse
      ]("updateRoom", api.updateRoom)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateRoomResponse.wrap)
        .provideEnvironment(r)
    def getSipMediaApplicationLoggingConfiguration(
        request: GetSipMediaApplicationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest,
      GetSipMediaApplicationLoggingConfigurationResponse
    ](
      "getSipMediaApplicationLoggingConfiguration",
      api.getSipMediaApplicationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getProxySession(
        request: GetProxySessionRequest
    ): IO[AwsError, zio.aws.chime.model.GetProxySessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetProxySessionRequest,
        GetProxySessionResponse
      ]("getProxySession", api.getProxySession)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetProxySessionResponse.wrap)
        .provideEnvironment(r)
    def deletePhoneNumber(
        request: DeletePhoneNumberRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest,
      DeletePhoneNumberResponse
    ]("deletePhoneNumber", api.deletePhoneNumber)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listPhoneNumberOrders(request: ListPhoneNumberOrdersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chime.model.PhoneNumberOrder.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest,
      ListPhoneNumberOrdersResponse,
      PhoneNumberOrder
    ](
      "listPhoneNumberOrders",
      api.listPhoneNumberOrders,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumberOrders().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chime.model.PhoneNumberOrder.wrap(item))
      .provideEnvironment(r)
    def listPhoneNumberOrdersPaginated(
        request: ListPhoneNumberOrdersRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest,
      ListPhoneNumberOrdersResponse
    ]("listPhoneNumberOrders", api.listPhoneNumberOrders)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListPhoneNumberOrdersResponse.wrap)
      .provideEnvironment(r)
    def batchCreateRoomMembership(
        request: BatchCreateRoomMembershipRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest,
      BatchCreateRoomMembershipResponse
    ]("batchCreateRoomMembership", api.batchCreateRoomMembership)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.BatchCreateRoomMembershipResponse.wrap)
      .provideEnvironment(r)
    def tagMeeting(request: TagMeetingRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.TagMeetingRequest,
        TagMeetingResponse
      ]("tagMeeting", api.tagMeeting)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteAppInstanceAdmin(
        request: DeleteAppInstanceAdminRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteAppInstanceAdminRequest,
      DeleteAppInstanceAdminResponse
    ]("deleteAppInstanceAdmin", api.deleteAppInstanceAdmin)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteAccount(
        request: DeleteAccountRequest
    ): IO[AwsError, zio.aws.chime.model.DeleteAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteAccountRequest,
        DeleteAccountResponse
      ]("deleteAccount", api.deleteAccount)(request.buildAwsValue())
        .map(zio.aws.chime.model.DeleteAccountResponse.wrap)
        .provideEnvironment(r)
    def batchCreateAttendee(
        request: BatchCreateAttendeeRequest
    ): IO[AwsError, zio.aws.chime.model.BatchCreateAttendeeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest,
        BatchCreateAttendeeResponse
      ]("batchCreateAttendee", api.batchCreateAttendee)(request.buildAwsValue())
        .map(zio.aws.chime.model.BatchCreateAttendeeResponse.wrap)
        .provideEnvironment(r)
    def deleteSipMediaApplication(
        request: DeleteSipMediaApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteSipMediaApplicationRequest,
      DeleteSipMediaApplicationResponse
    ]("deleteSipMediaApplication", api.deleteSipMediaApplication)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getAccount(
        request: GetAccountRequest
    ): IO[AwsError, zio.aws.chime.model.GetAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetAccountRequest,
        GetAccountResponse
      ]("getAccount", api.getAccount)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetAccountResponse.wrap)
        .provideEnvironment(r)
    def listProxySessions(
        request: ListProxySessionsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.ProxySession.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListProxySessionsRequest,
        ListProxySessionsResponse,
        ProxySession
      ](
        "listProxySessions",
        api.listProxySessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.proxySessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.ProxySession.wrap(item))
        .provideEnvironment(r)
    def listProxySessionsPaginated(
        request: ListProxySessionsRequest
    ): IO[AwsError, zio.aws.chime.model.ListProxySessionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListProxySessionsRequest,
        ListProxySessionsResponse
      ]("listProxySessions", api.listProxySessions)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListProxySessionsResponse.wrap)
        .provideEnvironment(r)
    def describeAppInstanceAdmin(request: DescribeAppInstanceAdminRequest): IO[
      AwsError,
      zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DescribeAppInstanceAdminRequest,
      DescribeAppInstanceAdminResponse
    ]("describeAppInstanceAdmin", api.describeAppInstanceAdmin)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.DescribeAppInstanceAdminResponse.wrap)
      .provideEnvironment(r)
    def getEventsConfiguration(request: GetEventsConfigurationRequest): IO[
      AwsError,
      zio.aws.chime.model.GetEventsConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetEventsConfigurationRequest,
      GetEventsConfigurationResponse
    ]("getEventsConfiguration", api.getEventsConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetEventsConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteChannelRequest,
        DeleteChannelResponse
      ]("deleteChannel", api.deleteChannel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteVoiceConnectorProxy(
        request: DeleteVoiceConnectorProxyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest,
      DeleteVoiceConnectorProxyResponse
    ]("deleteVoiceConnectorProxy", api.deleteVoiceConnectorProxy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createRoomMembership(
        request: CreateRoomMembershipRequest
    ): IO[AwsError, zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest,
        CreateRoomMembershipResponse
      ]("createRoomMembership", api.createRoomMembership)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.CreateRoomMembershipResponse.wrap)
        .provideEnvironment(r)
    def updateAppInstanceUser(request: UpdateAppInstanceUserRequest): IO[
      AwsError,
      zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserRequest,
      UpdateAppInstanceUserResponse
    ]("updateAppInstanceUser", api.updateAppInstanceUser)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.UpdateAppInstanceUserResponse.wrap)
      .provideEnvironment(r)
    def getUser(
        request: GetUserRequest
    ): IO[AwsError, zio.aws.chime.model.GetUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetUserRequest,
        GetUserResponse
      ]("getUser", api.getUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetUserResponse.wrap)
        .provideEnvironment(r)
    def getPhoneNumberOrder(
        request: GetPhoneNumberOrderRequest
    ): IO[AwsError, zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest,
        GetPhoneNumberOrderResponse
      ]("getPhoneNumberOrder", api.getPhoneNumberOrder)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetPhoneNumberOrderResponse.wrap)
        .provideEnvironment(r)
    def deleteEventsConfiguration(
        request: DeleteEventsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest,
      DeleteEventsConfigurationResponse
    ]("deleteEventsConfiguration", api.deleteEventsConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateVoiceConnector(
        request: UpdateVoiceConnectorRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateVoiceConnectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest,
        UpdateVoiceConnectorResponse
      ]("updateVoiceConnector", api.updateVoiceConnector)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.UpdateVoiceConnectorResponse.wrap)
        .provideEnvironment(r)
    def batchUpdateUser(
        request: BatchUpdateUserRequest
    ): IO[AwsError, zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest,
        BatchUpdateUserResponse
      ]("batchUpdateUser", api.batchUpdateUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.BatchUpdateUserResponse.wrap)
        .provideEnvironment(r)
    def untagAttendee(request: UntagAttendeeRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UntagAttendeeRequest,
        UntagAttendeeResponse
      ]("untagAttendee", api.untagAttendee)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getSipMediaApplication(request: GetSipMediaApplicationRequest): IO[
      AwsError,
      zio.aws.chime.model.GetSipMediaApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetSipMediaApplicationRequest,
      GetSipMediaApplicationResponse
    ]("getSipMediaApplication", api.getSipMediaApplication)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetSipMediaApplicationResponse.wrap)
      .provideEnvironment(r)
    def listChannelBans(
        request: ListChannelBansRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chime.model.ListChannelBansResponse.ReadOnly,
      zio.aws.chime.model.ChannelBanSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListChannelBansRequest,
      ListChannelBansResponse,
      ChannelBanSummary
    ](
      "listChannelBans",
      api.listChannelBans,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelBans().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.chime.model.ListChannelBansResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.chime.model.ChannelBanSummary.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelBansPaginated(
        request: ListChannelBansRequest
    ): IO[AwsError, zio.aws.chime.model.ListChannelBansResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListChannelBansRequest,
        ListChannelBansResponse
      ]("listChannelBans", api.listChannelBans)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListChannelBansResponse.wrap)
        .provideEnvironment(r)
    def redactRoomMessage(
        request: RedactRoomMessageRequest
    ): IO[AwsError, zio.aws.chime.model.RedactRoomMessageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.RedactRoomMessageRequest,
        RedactRoomMessageResponse
      ]("redactRoomMessage", api.redactRoomMessage)(request.buildAwsValue())
        .map(zio.aws.chime.model.RedactRoomMessageResponse.wrap)
        .provideEnvironment(r)
    def updateSipMediaApplicationCall(
        request: UpdateSipMediaApplicationCallRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallRequest,
      UpdateSipMediaApplicationCallResponse
    ]("updateSipMediaApplicationCall", api.updateSipMediaApplicationCall)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.wrap)
      .provideEnvironment(r)
    def getUserSettings(
        request: GetUserSettingsRequest
    ): IO[AwsError, zio.aws.chime.model.GetUserSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetUserSettingsRequest,
        GetUserSettingsResponse
      ]("getUserSettings", api.getUserSettings)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetUserSettingsResponse.wrap)
        .provideEnvironment(r)
    def createUser(
        request: CreateUserRequest
    ): IO[AwsError, zio.aws.chime.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateUserRequest,
        CreateUserResponse
      ]("createUser", api.createUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def listChannelMessages(
        request: ListChannelMessagesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly,
      zio.aws.chime.model.ChannelMessageSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListChannelMessagesRequest,
      ListChannelMessagesResponse,
      ChannelMessageSummary
    ](
      "listChannelMessages",
      api.listChannelMessages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelMessages().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.chime.model.ListChannelMessagesResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.chime.model.ChannelMessageSummary.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelMessagesPaginated(
        request: ListChannelMessagesRequest
    ): IO[AwsError, zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListChannelMessagesRequest,
        ListChannelMessagesResponse
      ]("listChannelMessages", api.listChannelMessages)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListChannelMessagesResponse.wrap)
        .provideEnvironment(r)
    def deleteVoiceConnectorOrigination(
        request: DeleteVoiceConnectorOriginationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest,
      DeleteVoiceConnectorOriginationResponse
    ]("deleteVoiceConnectorOrigination", api.deleteVoiceConnectorOrigination)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listPhoneNumbers(
        request: ListPhoneNumbersRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.PhoneNumber.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest,
        ListPhoneNumbersResponse,
        PhoneNumber
      ](
        "listPhoneNumbers",
        api.listPhoneNumbers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.phoneNumbers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.PhoneNumber.wrap(item))
        .provideEnvironment(r)
    def listPhoneNumbersPaginated(
        request: ListPhoneNumbersRequest
    ): IO[AwsError, zio.aws.chime.model.ListPhoneNumbersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListPhoneNumbersRequest,
        ListPhoneNumbersResponse
      ]("listPhoneNumbers", api.listPhoneNumbers)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListPhoneNumbersResponse.wrap)
        .provideEnvironment(r)
    def deleteVoiceConnectorTerminationCredentials(
        request: DeleteVoiceConnectorTerminationCredentialsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationCredentialsRequest,
      DeleteVoiceConnectorTerminationCredentialsResponse
    ](
      "deleteVoiceConnectorTerminationCredentials",
      api.deleteVoiceConnectorTerminationCredentials
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def associateSigninDelegateGroupsWithAccount(
        request: AssociateSigninDelegateGroupsWithAccountRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest,
      AssociateSigninDelegateGroupsWithAccountResponse
    ](
      "associateSigninDelegateGroupsWithAccount",
      api.associateSigninDelegateGroupsWithAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountResponse.wrap
      )
      .provideEnvironment(r)
    def updatePhoneNumber(
        request: UpdatePhoneNumberRequest
    ): IO[AwsError, zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest,
        UpdatePhoneNumberResponse
      ]("updatePhoneNumber", api.updatePhoneNumber)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdatePhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def createChannelMembership(request: CreateChannelMembershipRequest): IO[
      AwsError,
      zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateChannelMembershipRequest,
      CreateChannelMembershipResponse
    ]("createChannelMembership", api.createChannelMembership)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateChannelMembershipResponse.wrap)
      .provideEnvironment(r)
    def deleteMeeting(request: DeleteMeetingRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteMeetingRequest,
        DeleteMeetingResponse
      ]("deleteMeeting", api.deleteMeeting)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def tagAttendee(request: TagAttendeeRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.TagAttendeeRequest,
        TagAttendeeResponse
      ]("tagAttendee", api.tagAttendee)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def inviteUsers(
        request: InviteUsersRequest
    ): IO[AwsError, zio.aws.chime.model.InviteUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.InviteUsersRequest,
        InviteUsersResponse
      ]("inviteUsers", api.inviteUsers)(request.buildAwsValue())
        .map(zio.aws.chime.model.InviteUsersResponse.wrap)
        .provideEnvironment(r)
    def getVoiceConnectorTerminationHealth(
        request: GetVoiceConnectorTerminationHealthRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorTerminationHealthRequest,
      GetVoiceConnectorTerminationHealthResponse
    ](
      "getVoiceConnectorTerminationHealth",
      api.getVoiceConnectorTerminationHealth
    )(request.buildAwsValue())
      .map(zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.wrap)
      .provideEnvironment(r)
    def getPhoneNumber(
        request: GetPhoneNumberRequest
    ): IO[AwsError, zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest,
        GetPhoneNumberResponse
      ]("getPhoneNumber", api.getPhoneNumber)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetPhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def updateUserSettings(
        request: UpdateUserSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest,
      UpdateUserSettingsResponse
    ]("updateUserSettings", api.updateUserSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def resetPersonalPIN(
        request: ResetPersonalPinRequest
    ): IO[AwsError, zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ResetPersonalPinRequest,
        ResetPersonalPinResponse
      ]("resetPersonalPIN", api.resetPersonalPIN)(request.buildAwsValue())
        .map(zio.aws.chime.model.ResetPersonalPinResponse.wrap)
        .provideEnvironment(r)
    def createChannel(
        request: CreateChannelRequest
    ): IO[AwsError, zio.aws.chime.model.CreateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateChannelRequest,
        CreateChannelResponse
      ]("createChannel", api.createChannel)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateChannelResponse.wrap)
        .provideEnvironment(r)
    def describeChannelBan(
        request: DescribeChannelBanRequest
    ): IO[AwsError, zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DescribeChannelBanRequest,
        DescribeChannelBanResponse
      ]("describeChannelBan", api.describeChannelBan)(request.buildAwsValue())
        .map(zio.aws.chime.model.DescribeChannelBanResponse.wrap)
        .provideEnvironment(r)
    def listChannelMemberships(
        request: ListChannelMembershipsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly,
      zio.aws.chime.model.ChannelMembershipSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListChannelMembershipsRequest,
      ListChannelMembershipsResponse,
      ChannelMembershipSummary
    ](
      "listChannelMemberships",
      api.listChannelMemberships,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelMemberships().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.chime.model.ListChannelMembershipsResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.chime.model.ChannelMembershipSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelMembershipsPaginated(
        request: ListChannelMembershipsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListChannelMembershipsRequest,
      ListChannelMembershipsResponse
    ]("listChannelMemberships", api.listChannelMemberships)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListChannelMembershipsResponse.wrap)
      .provideEnvironment(r)
    def batchCreateChannelMembership(
        request: BatchCreateChannelMembershipRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipRequest,
      BatchCreateChannelMembershipResponse
    ]("batchCreateChannelMembership", api.batchCreateChannelMembership)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.BatchCreateChannelMembershipResponse.wrap)
      .provideEnvironment(r)
    def putVoiceConnectorLoggingConfiguration(
        request: PutVoiceConnectorLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest,
      PutVoiceConnectorLoggingConfigurationResponse
    ](
      "putVoiceConnectorLoggingConfiguration",
      api.putVoiceConnectorLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def logoutUser(
        request: LogoutUserRequest
    ): IO[AwsError, zio.aws.chime.model.LogoutUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.LogoutUserRequest,
        LogoutUserResponse
      ]("logoutUser", api.logoutUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.LogoutUserResponse.wrap)
        .provideEnvironment(r)
    def searchAvailablePhoneNumbers(
        request: SearchAvailablePhoneNumbersRequest
    ): ZStream[Any, AwsError, E164PhoneNumber] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest,
      SearchAvailablePhoneNumbersResponse,
      java.lang.String
    ](
      "searchAvailablePhoneNumbers",
      api.searchAvailablePhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.e164PhoneNumbers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chime.model.primitives.E164PhoneNumber(item))
      .provideEnvironment(r)
    def searchAvailablePhoneNumbersPaginated(
        request: SearchAvailablePhoneNumbersRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.SearchAvailablePhoneNumbersRequest,
      SearchAvailablePhoneNumbersResponse
    ]("searchAvailablePhoneNumbers", api.searchAvailablePhoneNumbers)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.wrap)
      .provideEnvironment(r)
    def listVoiceConnectorTerminationCredentials(
        request: ListVoiceConnectorTerminationCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest,
      ListVoiceConnectorTerminationCredentialsResponse
    ](
      "listVoiceConnectorTerminationCredentials",
      api.listVoiceConnectorTerminationCredentials
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.wrap
      )
      .provideEnvironment(r)
    def updateChannelReadMarker(request: UpdateChannelReadMarkerRequest): IO[
      AwsError,
      zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerRequest,
      UpdateChannelReadMarkerResponse
    ]("updateChannelReadMarker", api.updateChannelReadMarker)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.UpdateChannelReadMarkerResponse.wrap)
      .provideEnvironment(r)
    def deleteAppInstanceUser(
        request: DeleteAppInstanceUserRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteAppInstanceUserRequest,
      DeleteAppInstanceUserResponse
    ]("deleteAppInstanceUser", api.deleteAppInstanceUser)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createChannelModerator(request: CreateChannelModeratorRequest): IO[
      AwsError,
      zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateChannelModeratorRequest,
      CreateChannelModeratorResponse
    ]("createChannelModerator", api.createChannelModerator)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateChannelModeratorResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getAppInstanceStreamingConfigurations(
        request: GetAppInstanceStreamingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetAppInstanceStreamingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetAppInstanceStreamingConfigurationsRequest,
      GetAppInstanceStreamingConfigurationsResponse
    ](
      "getAppInstanceStreamingConfigurations",
      api.getAppInstanceStreamingConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.GetAppInstanceStreamingConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
    def updateSipMediaApplication(
        request: UpdateSipMediaApplicationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationRequest,
      UpdateSipMediaApplicationResponse
    ]("updateSipMediaApplication", api.updateSipMediaApplication)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.UpdateSipMediaApplicationResponse.wrap)
      .provideEnvironment(r)
    def disassociatePhoneNumberFromUser(
        request: DisassociatePhoneNumberFromUserRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DisassociatePhoneNumberFromUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest,
      DisassociatePhoneNumberFromUserResponse
    ]("disassociatePhoneNumberFromUser", api.disassociatePhoneNumberFromUser)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.DisassociatePhoneNumberFromUserResponse.wrap)
      .provideEnvironment(r)
    def getChannelMessage(
        request: GetChannelMessageRequest
    ): IO[AwsError, zio.aws.chime.model.GetChannelMessageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetChannelMessageRequest,
        GetChannelMessageResponse
      ]("getChannelMessage", api.getChannelMessage)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetChannelMessageResponse.wrap)
        .provideEnvironment(r)
    def putRetentionSettings(
        request: PutRetentionSettingsRequest
    ): IO[AwsError, zio.aws.chime.model.PutRetentionSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.PutRetentionSettingsRequest,
        PutRetentionSettingsResponse
      ]("putRetentionSettings", api.putRetentionSettings)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.PutRetentionSettingsResponse.wrap)
        .provideEnvironment(r)
    def deleteAppInstance(
        request: DeleteAppInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteAppInstanceRequest,
      DeleteAppInstanceResponse
    ]("deleteAppInstance", api.deleteAppInstance)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createAppInstanceAdmin(request: CreateAppInstanceAdminRequest): IO[
      AwsError,
      zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateAppInstanceAdminRequest,
      CreateAppInstanceAdminResponse
    ]("createAppInstanceAdmin", api.createAppInstanceAdmin)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateAppInstanceAdminResponse.wrap)
      .provideEnvironment(r)
    def getSipRule(
        request: GetSipRuleRequest
    ): IO[AwsError, zio.aws.chime.model.GetSipRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetSipRuleRequest,
        GetSipRuleResponse
      ]("getSipRule", api.getSipRule)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetSipRuleResponse.wrap)
        .provideEnvironment(r)
    def createChannelBan(
        request: CreateChannelBanRequest
    ): IO[AwsError, zio.aws.chime.model.CreateChannelBanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateChannelBanRequest,
        CreateChannelBanResponse
      ]("createChannelBan", api.createChannelBan)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateChannelBanResponse.wrap)
        .provideEnvironment(r)
    def untagMeeting(request: UntagMeetingRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UntagMeetingRequest,
        UntagMeetingResponse
      ]("untagMeeting", api.untagMeeting)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updatePhoneNumberSettings(
        request: UpdatePhoneNumberSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest,
      UpdatePhoneNumberSettingsResponse
    ]("updatePhoneNumberSettings", api.updatePhoneNumberSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteChannelMessage(
        request: DeleteChannelMessageRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteChannelMessageRequest,
      DeleteChannelMessageResponse
    ]("deleteChannelMessage", api.deleteChannelMessage)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createRoom(
        request: CreateRoomRequest
    ): IO[AwsError, zio.aws.chime.model.CreateRoomResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateRoomRequest,
        CreateRoomResponse
      ]("createRoom", api.createRoom)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateRoomResponse.wrap)
        .provideEnvironment(r)
    def deleteRoom(request: DeleteRoomRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteRoomRequest,
        DeleteRoomResponse
      ]("deleteRoom", api.deleteRoom)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listBots(
        request: ListBotsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.Bot.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListBotsRequest,
        ListBotsResponse,
        Bot
      ](
        "listBots",
        api.listBots,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.bots().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.Bot.wrap(item))
        .provideEnvironment(r)
    def listBotsPaginated(
        request: ListBotsRequest
    ): IO[AwsError, zio.aws.chime.model.ListBotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListBotsRequest,
        ListBotsResponse
      ]("listBots", api.listBots)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListBotsResponse.wrap)
        .provideEnvironment(r)
    def getVoiceConnectorStreamingConfiguration(
        request: GetVoiceConnectorStreamingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest,
      GetVoiceConnectorStreamingConfigurationResponse
    ](
      "getVoiceConnectorStreamingConfiguration",
      api.getVoiceConnectorStreamingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def createVoiceConnectorGroup(
        request: CreateVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest,
      CreateVoiceConnectorGroupResponse
    ]("createVoiceConnectorGroup", api.createVoiceConnectorGroup)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateVoiceConnectorGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteProxySession(
        request: DeleteProxySessionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteProxySessionRequest,
      DeleteProxySessionResponse
    ]("deleteProxySession", api.deleteProxySession)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def redactChannelMessage(
        request: RedactChannelMessageRequest
    ): IO[AwsError, zio.aws.chime.model.RedactChannelMessageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.RedactChannelMessageRequest,
        RedactChannelMessageResponse
      ]("redactChannelMessage", api.redactChannelMessage)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.RedactChannelMessageResponse.wrap)
        .provideEnvironment(r)
    def createBot(
        request: CreateBotRequest
    ): IO[AwsError, zio.aws.chime.model.CreateBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateBotRequest,
        CreateBotResponse
      ]("createBot", api.createBot)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateBotResponse.wrap)
        .provideEnvironment(r)
    def listMeetings(
        request: ListMeetingsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.Meeting.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListMeetingsRequest,
        ListMeetingsResponse,
        Meeting
      ](
        "listMeetings",
        api.listMeetings,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.meetings().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.Meeting.wrap(item))
        .provideEnvironment(r)
    def listMeetingsPaginated(
        request: ListMeetingsRequest
    ): IO[AwsError, zio.aws.chime.model.ListMeetingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListMeetingsRequest,
        ListMeetingsResponse
      ]("listMeetings", api.listMeetings)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListMeetingsResponse.wrap)
        .provideEnvironment(r)
    def deleteAttendee(request: DeleteAttendeeRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest,
        DeleteAttendeeResponse
      ]("deleteAttendee", api.deleteAttendee)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteChannelBan(request: DeleteChannelBanRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DeleteChannelBanRequest,
        DeleteChannelBanResponse
      ]("deleteChannelBan", api.deleteChannelBan)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listSipRules(
        request: ListSipRulesRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.SipRule.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListSipRulesRequest,
        ListSipRulesResponse,
        SipRule
      ](
        "listSipRules",
        api.listSipRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.sipRules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.SipRule.wrap(item))
        .provideEnvironment(r)
    def listSipRulesPaginated(
        request: ListSipRulesRequest
    ): IO[AwsError, zio.aws.chime.model.ListSipRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListSipRulesRequest,
        ListSipRulesResponse
      ]("listSipRules", api.listSipRules)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListSipRulesResponse.wrap)
        .provideEnvironment(r)
    def getAttendee(
        request: GetAttendeeRequest
    ): IO[AwsError, zio.aws.chime.model.GetAttendeeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetAttendeeRequest,
        GetAttendeeResponse
      ]("getAttendee", api.getAttendee)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetAttendeeResponse.wrap)
        .provideEnvironment(r)
    def describeChannelModerator(request: DescribeChannelModeratorRequest): IO[
      AwsError,
      zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DescribeChannelModeratorRequest,
      DescribeChannelModeratorResponse
    ]("describeChannelModerator", api.describeChannelModerator)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.DescribeChannelModeratorResponse.wrap)
      .provideEnvironment(r)
    def batchUnsuspendUser(
        request: BatchUnsuspendUserRequest
    ): IO[AwsError, zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest,
        BatchUnsuspendUserResponse
      ]("batchUnsuspendUser", api.batchUnsuspendUser)(request.buildAwsValue())
        .map(zio.aws.chime.model.BatchUnsuspendUserResponse.wrap)
        .provideEnvironment(r)
    def describeChannelMembershipForAppInstanceUser(
        request: DescribeChannelMembershipForAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest,
      DescribeChannelMembershipForAppInstanceUserResponse
    ](
      "describeChannelMembershipForAppInstanceUser",
      api.describeChannelMembershipForAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def getGlobalSettings()
        : IO[AwsError, zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly] =
      asyncRequestResponse[GetGlobalSettingsRequest, GetGlobalSettingsResponse](
        "getGlobalSettings",
        api.getGlobalSettings
      )(GetGlobalSettingsRequest.builder().build())
        .map(zio.aws.chime.model.GetGlobalSettingsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.chime.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def createMeeting(
        request: CreateMeetingRequest
    ): IO[AwsError, zio.aws.chime.model.CreateMeetingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateMeetingRequest,
        CreateMeetingResponse
      ]("createMeeting", api.createMeeting)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateMeetingResponse.wrap)
        .provideEnvironment(r)
    def putVoiceConnectorTermination(
        request: PutVoiceConnectorTerminationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationRequest,
      PutVoiceConnectorTerminationResponse
    ]("putVoiceConnectorTermination", api.putVoiceConnectorTermination)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.PutVoiceConnectorTerminationResponse.wrap)
      .provideEnvironment(r)
    def startMeetingTranscription(
        request: StartMeetingTranscriptionRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.StartMeetingTranscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.StartMeetingTranscriptionRequest,
      StartMeetingTranscriptionResponse
    ]("startMeetingTranscription", api.startMeetingTranscription)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.StartMeetingTranscriptionResponse.wrap)
      .provideEnvironment(r)
    def associatePhoneNumbersWithVoiceConnectorGroup(
        request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
      AssociatePhoneNumbersWithVoiceConnectorGroupResponse
    ](
      "associatePhoneNumbersWithVoiceConnectorGroup",
      api.associatePhoneNumbersWithVoiceConnectorGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.wrap
      )
      .provideEnvironment(r)
    def listAppInstances(
        request: ListAppInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.AppInstanceSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListAppInstancesRequest,
        ListAppInstancesResponse,
        AppInstanceSummary
      ](
        "listAppInstances",
        api.listAppInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.appInstances().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.AppInstanceSummary.wrap(item))
        .provideEnvironment(r)
    def listAppInstancesPaginated(
        request: ListAppInstancesRequest
    ): IO[AwsError, zio.aws.chime.model.ListAppInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListAppInstancesRequest,
        ListAppInstancesResponse
      ]("listAppInstances", api.listAppInstances)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListAppInstancesResponse.wrap)
        .provideEnvironment(r)
    def createMeetingDialOut(
        request: CreateMeetingDialOutRequest
    ): IO[AwsError, zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest,
        CreateMeetingDialOutResponse
      ]("createMeetingDialOut", api.createMeetingDialOut)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.CreateMeetingDialOutResponse.wrap)
        .provideEnvironment(r)
    def putEventsConfiguration(request: PutEventsConfigurationRequest): IO[
      AwsError,
      zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutEventsConfigurationRequest,
      PutEventsConfigurationResponse
    ]("putEventsConfiguration", api.putEventsConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.PutEventsConfigurationResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def batchDeletePhoneNumber(request: BatchDeletePhoneNumberRequest): IO[
      AwsError,
      zio.aws.chime.model.BatchDeletePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest,
      BatchDeletePhoneNumberResponse
    ]("batchDeletePhoneNumber", api.batchDeletePhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.BatchDeletePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def createMeetingWithAttendees(
        request: CreateMeetingWithAttendeesRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest,
      CreateMeetingWithAttendeesResponse
    ]("createMeetingWithAttendees", api.createMeetingWithAttendees)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateMeetingWithAttendeesResponse.wrap)
      .provideEnvironment(r)
    def disassociatePhoneNumbersFromVoiceConnectorGroup(
        request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
      DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
    ](
      "disassociatePhoneNumbersFromVoiceConnectorGroup",
      api.disassociatePhoneNumbersFromVoiceConnectorGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.wrap
      )
      .provideEnvironment(r)
    def describeChannel(
        request: DescribeChannelRequest
    ): IO[AwsError, zio.aws.chime.model.DescribeChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.DescribeChannelRequest,
        DescribeChannelResponse
      ]("describeChannel", api.describeChannel)(request.buildAwsValue())
        .map(zio.aws.chime.model.DescribeChannelResponse.wrap)
        .provideEnvironment(r)
    def updateAccountSettings(request: UpdateAccountSettingsRequest): IO[
      AwsError,
      zio.aws.chime.model.UpdateAccountSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest,
      UpdateAccountSettingsResponse
    ]("updateAccountSettings", api.updateAccountSettings)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.UpdateAccountSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteAppInstanceStreamingConfigurations(
        request: DeleteAppInstanceStreamingConfigurationsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest,
      DeleteAppInstanceStreamingConfigurationsResponse
    ](
      "deleteAppInstanceStreamingConfigurations",
      api.deleteAppInstanceStreamingConfigurations
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listMeetingTags(
        request: ListMeetingTagsRequest
    ): IO[AwsError, zio.aws.chime.model.ListMeetingTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListMeetingTagsRequest,
        ListMeetingTagsResponse
      ]("listMeetingTags", api.listMeetingTags)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListMeetingTagsResponse.wrap)
        .provideEnvironment(r)
    def putVoiceConnectorTerminationCredentials(
        request: PutVoiceConnectorTerminationCredentialsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest,
      PutVoiceConnectorTerminationCredentialsResponse
    ](
      "putVoiceConnectorTerminationCredentials",
      api.putVoiceConnectorTerminationCredentials
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createSipMediaApplicationCall(
        request: CreateSipMediaApplicationCallRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.CreateSipMediaApplicationCallResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationCallRequest,
      CreateSipMediaApplicationCallResponse
    ]("createSipMediaApplicationCall", api.createSipMediaApplicationCall)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateSipMediaApplicationCallResponse.wrap)
      .provideEnvironment(r)
    def getRoom(
        request: GetRoomRequest
    ): IO[AwsError, zio.aws.chime.model.GetRoomResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetRoomRequest,
        GetRoomResponse
      ]("getRoom", api.getRoom)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetRoomResponse.wrap)
        .provideEnvironment(r)
    def getVoiceConnectorLoggingConfiguration(
        request: GetVoiceConnectorLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest,
      GetVoiceConnectorLoggingConfigurationResponse
    ](
      "getVoiceConnectorLoggingConfiguration",
      api.getVoiceConnectorLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteVoiceConnectorGroup(
        request: DeleteVoiceConnectorGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest,
      DeleteVoiceConnectorGroupResponse
    ]("deleteVoiceConnectorGroup", api.deleteVoiceConnectorGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putVoiceConnectorStreamingConfiguration(
        request: PutVoiceConnectorStreamingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest,
      PutVoiceConnectorStreamingConfigurationResponse
    ](
      "putVoiceConnectorStreamingConfiguration",
      api.putVoiceConnectorStreamingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getVoiceConnectorEmergencyCallingConfiguration(
        request: GetVoiceConnectorEmergencyCallingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationRequest,
      GetVoiceConnectorEmergencyCallingConfigurationResponse
    ](
      "getVoiceConnectorEmergencyCallingConfiguration",
      api.getVoiceConnectorEmergencyCallingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def regenerateSecurityToken(request: RegenerateSecurityTokenRequest): IO[
      AwsError,
      zio.aws.chime.model.RegenerateSecurityTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.RegenerateSecurityTokenRequest,
      RegenerateSecurityTokenResponse
    ]("regenerateSecurityToken", api.regenerateSecurityToken)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.RegenerateSecurityTokenResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnectorTermination(
        request: DeleteVoiceConnectorTerminationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest,
      DeleteVoiceConnectorTerminationResponse
    ]("deleteVoiceConnectorTermination", api.deleteVoiceConnectorTermination)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getBot(
        request: GetBotRequest
    ): IO[AwsError, zio.aws.chime.model.GetBotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetBotRequest,
        GetBotResponse
      ]("getBot", api.getBot)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetBotResponse.wrap)
        .provideEnvironment(r)
    def deleteVoiceConnectorStreamingConfiguration(
        request: DeleteVoiceConnectorStreamingConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest,
      DeleteVoiceConnectorStreamingConfigurationResponse
    ](
      "deleteVoiceConnectorStreamingConfiguration",
      api.deleteVoiceConnectorStreamingConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putVoiceConnectorOrigination(
        request: PutVoiceConnectorOriginationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutVoiceConnectorOriginationRequest,
      PutVoiceConnectorOriginationResponse
    ]("putVoiceConnectorOrigination", api.putVoiceConnectorOrigination)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.PutVoiceConnectorOriginationResponse.wrap)
      .provideEnvironment(r)
    def listChannelModerators(
        request: ListChannelModeratorsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly,
      zio.aws.chime.model.ChannelModeratorSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListChannelModeratorsRequest,
      ListChannelModeratorsResponse,
      ChannelModeratorSummary
    ](
      "listChannelModerators",
      api.listChannelModerators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelModerators().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.chime.model.ListChannelModeratorsResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.chime.model.ChannelModeratorSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelModeratorsPaginated(
        request: ListChannelModeratorsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListChannelModeratorsRequest,
      ListChannelModeratorsResponse
    ]("listChannelModerators", api.listChannelModerators)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListChannelModeratorsResponse.wrap)
      .provideEnvironment(r)
    def getPhoneNumberSettings(): IO[
      AwsError,
      zio.aws.chime.model.GetPhoneNumberSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPhoneNumberSettingsRequest,
      GetPhoneNumberSettingsResponse
    ]("getPhoneNumberSettings", api.getPhoneNumberSettings)(
      GetPhoneNumberSettingsRequest.builder().build()
    ).map(zio.aws.chime.model.GetPhoneNumberSettingsResponse.wrap)
      .provideEnvironment(r)
    def getAccountSettings(
        request: GetAccountSettingsRequest
    ): IO[AwsError, zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest,
        GetAccountSettingsResponse
      ]("getAccountSettings", api.getAccountSettings)(request.buildAwsValue())
        .map(zio.aws.chime.model.GetAccountSettingsResponse.wrap)
        .provideEnvironment(r)
    def createMediaCapturePipeline(
        request: CreateMediaCapturePipelineRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineRequest,
      CreateMediaCapturePipelineResponse
    ]("createMediaCapturePipeline", api.createMediaCapturePipeline)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateMediaCapturePipelineResponse.wrap)
      .provideEnvironment(r)
    def updateProxySession(
        request: UpdateProxySessionRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest,
        UpdateProxySessionResponse
      ]("updateProxySession", api.updateProxySession)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateProxySessionResponse.wrap)
        .provideEnvironment(r)
    def updateGlobalSettings(
        request: UpdateGlobalSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest,
      UpdateGlobalSettingsResponse
    ]("updateGlobalSettings", api.updateGlobalSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listChannelsModeratedByAppInstanceUser(
        request: ListChannelsModeratedByAppInstanceUserRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserRequest,
      ListChannelsModeratedByAppInstanceUserResponse,
      ChannelModeratedByAppInstanceUserSummary
    ](
      "listChannelsModeratedByAppInstanceUser",
      api.listChannelsModeratedByAppInstanceUser,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channels().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listChannelsModeratedByAppInstanceUserPaginated(
        request: ListChannelsModeratedByAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListChannelsModeratedByAppInstanceUserRequest,
      ListChannelsModeratedByAppInstanceUserResponse
    ](
      "listChannelsModeratedByAppInstanceUser",
      api.listChannelsModeratedByAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def updateChannelMessage(
        request: UpdateChannelMessageRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateChannelMessageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateChannelMessageRequest,
        UpdateChannelMessageResponse
      ]("updateChannelMessage", api.updateChannelMessage)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.UpdateChannelMessageResponse.wrap)
        .provideEnvironment(r)
    def getMessagingSessionEndpoint(
        request: GetMessagingSessionEndpointRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetMessagingSessionEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetMessagingSessionEndpointRequest,
      GetMessagingSessionEndpointResponse
    ]("getMessagingSessionEndpoint", api.getMessagingSessionEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetMessagingSessionEndpointResponse.wrap)
      .provideEnvironment(r)
    def listVoiceConnectorGroups(
        request: ListVoiceConnectorGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chime.model.VoiceConnectorGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest,
      ListVoiceConnectorGroupsResponse,
      VoiceConnectorGroup
    ](
      "listVoiceConnectorGroups",
      api.listVoiceConnectorGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.voiceConnectorGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chime.model.VoiceConnectorGroup.wrap(item))
      .provideEnvironment(r)
    def listVoiceConnectorGroupsPaginated(
        request: ListVoiceConnectorGroupsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest,
      ListVoiceConnectorGroupsResponse
    ]("listVoiceConnectorGroups", api.listVoiceConnectorGroups)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListVoiceConnectorGroupsResponse.wrap)
      .provideEnvironment(r)
    def createSipRule(
        request: CreateSipRuleRequest
    ): IO[AwsError, zio.aws.chime.model.CreateSipRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateSipRuleRequest,
        CreateSipRuleResponse
      ]("createSipRule", api.createSipRule)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateSipRuleResponse.wrap)
        .provideEnvironment(r)
    def listRooms(
        request: ListRoomsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.Room.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListRoomsRequest,
        ListRoomsResponse,
        Room
      ](
        "listRooms",
        api.listRooms,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.rooms().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.Room.wrap(item))
        .provideEnvironment(r)
    def listRoomsPaginated(
        request: ListRoomsRequest
    ): IO[AwsError, zio.aws.chime.model.ListRoomsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListRoomsRequest,
        ListRoomsResponse
      ]("listRooms", api.listRooms)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListRoomsResponse.wrap)
        .provideEnvironment(r)
    def getVoiceConnectorGroup(request: GetVoiceConnectorGroupRequest): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorGroupRequest,
      GetVoiceConnectorGroupResponse
    ]("getVoiceConnectorGroup", api.getVoiceConnectorGroup)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetVoiceConnectorGroupResponse.wrap)
      .provideEnvironment(r)
    def createProxySession(
        request: CreateProxySessionRequest
    ): IO[AwsError, zio.aws.chime.model.CreateProxySessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateProxySessionRequest,
        CreateProxySessionResponse
      ]("createProxySession", api.createProxySession)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateProxySessionResponse.wrap)
        .provideEnvironment(r)
    def deleteMediaCapturePipeline(
        request: DeleteMediaCapturePipelineRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteMediaCapturePipelineRequest,
      DeleteMediaCapturePipelineResponse
    ]("deleteMediaCapturePipeline", api.deleteMediaCapturePipeline)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getAppInstanceRetentionSettings(
        request: GetAppInstanceRetentionSettingsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetAppInstanceRetentionSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetAppInstanceRetentionSettingsRequest,
      GetAppInstanceRetentionSettingsResponse
    ]("getAppInstanceRetentionSettings", api.getAppInstanceRetentionSettings)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetAppInstanceRetentionSettingsResponse.wrap)
      .provideEnvironment(r)
    def stopMeetingTranscription(request: StopMeetingTranscriptionRequest): IO[
      AwsError,
      zio.aws.chime.model.StopMeetingTranscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.StopMeetingTranscriptionRequest,
      StopMeetingTranscriptionResponse
    ]("stopMeetingTranscription", api.stopMeetingTranscription)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.StopMeetingTranscriptionResponse.wrap)
      .provideEnvironment(r)
    def getVoiceConnectorOrigination(
        request: GetVoiceConnectorOriginationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.GetVoiceConnectorOriginationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.GetVoiceConnectorOriginationRequest,
      GetVoiceConnectorOriginationResponse
    ]("getVoiceConnectorOrigination", api.getVoiceConnectorOrigination)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.GetVoiceConnectorOriginationResponse.wrap)
      .provideEnvironment(r)
    def listRoomMemberships(
        request: ListRoomMembershipsRequest
    ): ZStream[Any, AwsError, zio.aws.chime.model.RoomMembership.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest,
        ListRoomMembershipsResponse,
        RoomMembership
      ](
        "listRoomMemberships",
        api.listRoomMemberships,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.roomMemberships().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.chime.model.RoomMembership.wrap(item))
        .provideEnvironment(r)
    def listRoomMembershipsPaginated(
        request: ListRoomMembershipsRequest
    ): IO[AwsError, zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListRoomMembershipsRequest,
        ListRoomMembershipsResponse
      ]("listRoomMemberships", api.listRoomMemberships)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListRoomMembershipsResponse.wrap)
        .provideEnvironment(r)
    def createSipMediaApplication(
        request: CreateSipMediaApplicationRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationRequest,
      CreateSipMediaApplicationResponse
    ]("createSipMediaApplication", api.createSipMediaApplication)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.CreateSipMediaApplicationResponse.wrap)
      .provideEnvironment(r)
    def createAttendee(
        request: CreateAttendeeRequest
    ): IO[AwsError, zio.aws.chime.model.CreateAttendeeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.CreateAttendeeRequest,
        CreateAttendeeResponse
      ]("createAttendee", api.createAttendee)(request.buildAwsValue())
        .map(zio.aws.chime.model.CreateAttendeeResponse.wrap)
        .provideEnvironment(r)
    def listAttendeeTags(
        request: ListAttendeeTagsRequest
    ): IO[AwsError, zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.ListAttendeeTagsRequest,
        ListAttendeeTagsResponse
      ]("listAttendeeTags", api.listAttendeeTags)(request.buildAwsValue())
        .map(zio.aws.chime.model.ListAttendeeTagsResponse.wrap)
        .provideEnvironment(r)
    def updateChannel(
        request: UpdateChannelRequest
    ): IO[AwsError, zio.aws.chime.model.UpdateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.UpdateChannelRequest,
        UpdateChannelResponse
      ]("updateChannel", api.updateChannel)(request.buildAwsValue())
        .map(zio.aws.chime.model.UpdateChannelResponse.wrap)
        .provideEnvironment(r)
    def listMediaCapturePipelines(
        request: ListMediaCapturePipelinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chime.model.MediaCapturePipeline.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesRequest,
      ListMediaCapturePipelinesResponse,
      MediaCapturePipeline
    ](
      "listMediaCapturePipelines",
      api.listMediaCapturePipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.mediaCapturePipelines().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chime.model.MediaCapturePipeline.wrap(item))
      .provideEnvironment(r)
    def listMediaCapturePipelinesPaginated(
        request: ListMediaCapturePipelinesRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.ListMediaCapturePipelinesRequest,
      ListMediaCapturePipelinesResponse
    ]("listMediaCapturePipelines", api.listMediaCapturePipelines)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.ListMediaCapturePipelinesResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceConnector(
        request: DeleteVoiceConnectorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorRequest,
      DeleteVoiceConnectorResponse
    ]("deleteVoiceConnector", api.deleteVoiceConnector)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getRetentionSettings(
        request: GetRetentionSettingsRequest
    ): IO[AwsError, zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.chime.model.GetRetentionSettingsRequest,
        GetRetentionSettingsResponse
      ]("getRetentionSettings", api.getRetentionSettings)(
        request.buildAwsValue()
      ).map(zio.aws.chime.model.GetRetentionSettingsResponse.wrap)
        .provideEnvironment(r)
    def batchUpdatePhoneNumber(request: BatchUpdatePhoneNumberRequest): IO[
      AwsError,
      zio.aws.chime.model.BatchUpdatePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest,
      BatchUpdatePhoneNumberResponse
    ]("batchUpdatePhoneNumber", api.batchUpdatePhoneNumber)(
      request.buildAwsValue()
    ).map(zio.aws.chime.model.BatchUpdatePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def putAppInstanceStreamingConfigurations(
        request: PutAppInstanceStreamingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chime.model.PutAppInstanceStreamingConfigurationsRequest,
      PutAppInstanceStreamingConfigurationsResponse
    ](
      "putAppInstanceStreamingConfigurations",
      api.putAppInstanceStreamingConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
  }
  def listSipMediaApplications(
      request: ListSipMediaApplicationsRequest
  ): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.SipMediaApplication.ReadOnly
  ] = ZStream.serviceWithStream(_.listSipMediaApplications(request))
  def listSipMediaApplicationsPaginated(
      request: ListSipMediaApplicationsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSipMediaApplicationsPaginated(request))
  def redactConversationMessage(request: RedactConversationMessageRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.RedactConversationMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.redactConversationMessage(request))
  def updateAccount(request: UpdateAccountRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccount(request))
  def describeAppInstance(request: DescribeAppInstanceRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAppInstance(request))
  def describeChannelMembership(request: DescribeChannelMembershipRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelMembership(request))
  def listAppInstanceUsers(
      request: ListAppInstanceUsersRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly,
    zio.aws.chime.model.AppInstanceUserSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listAppInstanceUsers(request))
  def listAppInstanceUsersPaginated(request: ListAppInstanceUsersRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppInstanceUsersPaginated(request))
  def putVoiceConnectorEmergencyCallingConfiguration(
      request: PutVoiceConnectorEmergencyCallingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.putVoiceConnectorEmergencyCallingConfiguration(request)
  )
  def updateRoomMembership(request: UpdateRoomMembershipRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateRoomMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoomMembership(request))
  def deleteSipRule(
      request: DeleteSipRuleRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSipRule(request))
  def putVoiceConnectorProxy(request: PutVoiceConnectorProxyRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorProxy(request))
  def listUsers(
      request: ListUsersRequest
  ): ZStream[zio.aws.chime.Chime, AwsError, zio.aws.chime.model.User.ReadOnly] =
    ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(request: ListUsersRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def createVoiceConnector(request: CreateVoiceConnectorRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceConnector(request))
  def updateAppInstance(request: UpdateAppInstanceRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAppInstance(request))
  def updateUser(request: UpdateUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def createAppInstanceUser(request: CreateAppInstanceUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppInstanceUser(request))
  def listChannels(request: ListChannelsRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ChannelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannels(request))
  def listChannelsPaginated(request: ListChannelsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelsPaginated(request))
  def restorePhoneNumber(request: RestorePhoneNumberRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.RestorePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restorePhoneNumber(request))
  def putSipMediaApplicationLoggingConfiguration(
      request: PutSipMediaApplicationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSipMediaApplicationLoggingConfiguration(request))
  def listAppInstanceAdmins(
      request: ListAppInstanceAdminsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly,
    zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listAppInstanceAdmins(request))
  def listAppInstanceAdminsPaginated(
      request: ListAppInstanceAdminsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppInstanceAdminsPaginated(request))
  def getVoiceConnector(request: GetVoiceConnectorRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnector(request))
  def createAccount(request: CreateAccountRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccount(request))
  def disassociatePhoneNumbersFromVoiceConnector(
      request: DisassociatePhoneNumbersFromVoiceConnectorRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociatePhoneNumbersFromVoiceConnector(request))
  def updateBot(request: UpdateBotRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBot(request))
  def updateVoiceConnectorGroup(request: UpdateVoiceConnectorGroupRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceConnectorGroup(request))
  def listSupportedPhoneNumberCountries(
      request: ListSupportedPhoneNumberCountriesRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSupportedPhoneNumberCountries(request))
  def deleteChannelModerator(
      request: DeleteChannelModeratorRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelModerator(request))
  def getVoiceConnectorProxy(request: GetVoiceConnectorProxyRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorProxy(request))
  def listAttendees(request: ListAttendeesRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.Attendee.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttendees(request))
  def listAttendeesPaginated(request: ListAttendeesRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListAttendeesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttendeesPaginated(request))
  def batchSuspendUser(request: BatchSuspendUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchSuspendUser(request))
  def describeAppInstanceUser(request: DescribeAppInstanceUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAppInstanceUser(request))
  def deleteRoomMembership(
      request: DeleteRoomMembershipRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRoomMembership(request))
  def listVoiceConnectors(request: ListVoiceConnectorsRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.VoiceConnector.ReadOnly
  ] = ZStream.serviceWithStream(_.listVoiceConnectors(request))
  def listVoiceConnectorsPaginated(request: ListVoiceConnectorsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListVoiceConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceConnectorsPaginated(request))
  def getMeeting(request: GetMeetingRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetMeetingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMeeting(request))
  def associatePhoneNumberWithUser(
      request: AssociatePhoneNumberWithUserRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.AssociatePhoneNumberWithUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePhoneNumberWithUser(request))
  def describeChannelModeratedByAppInstanceUser(
      request: DescribeChannelModeratedByAppInstanceUserRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelModeratedByAppInstanceUser(request))
  def updateSipRule(request: UpdateSipRuleRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSipRule(request))
  def listAccounts(request: ListAccountsRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.Account.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccounts(request))
  def listAccountsPaginated(request: ListAccountsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccountsPaginated(request))
  def listChannelMembershipsForAppInstanceUser(
      request: ListChannelMembershipsForAppInstanceUserRequest
  ): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listChannelMembershipsForAppInstanceUser(request)
  )
  def listChannelMembershipsForAppInstanceUserPaginated(
      request: ListChannelMembershipsForAppInstanceUserRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listChannelMembershipsForAppInstanceUserPaginated(request)
  )
  def disassociateSigninDelegateGroupsFromAccount(
      request: DisassociateSigninDelegateGroupsFromAccountRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSigninDelegateGroupsFromAccount(request))
  def putAppInstanceRetentionSettings(
      request: PutAppInstanceRetentionSettingsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAppInstanceRetentionSettings(request))
  def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMediaCapturePipeline(request))
  def getVoiceConnectorTermination(
      request: GetVoiceConnectorTerminationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorTermination(request))
  def sendChannelMessage(request: SendChannelMessageRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.SendChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendChannelMessage(request))
  def associatePhoneNumbersWithVoiceConnector(
      request: AssociatePhoneNumbersWithVoiceConnectorRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePhoneNumbersWithVoiceConnector(request))
  def createPhoneNumberOrder(request: CreatePhoneNumberOrderRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPhoneNumberOrder(request))
  def deleteVoiceConnectorEmergencyCallingConfiguration(
      request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] = ZIO.serviceWithZIO(
    _.deleteVoiceConnectorEmergencyCallingConfiguration(request)
  )
  def deleteChannelMembership(
      request: DeleteChannelMembershipRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelMembership(request))
  def createAppInstance(request: CreateAppInstanceRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateAppInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppInstance(request))
  def updateRoom(request: UpdateRoomRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoom(request))
  def getSipMediaApplicationLoggingConfiguration(
      request: GetSipMediaApplicationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSipMediaApplicationLoggingConfiguration(request))
  def getProxySession(request: GetProxySessionRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetProxySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProxySession(request))
  def deletePhoneNumber(
      request: DeletePhoneNumberRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePhoneNumber(request))
  def listPhoneNumberOrders(request: ListPhoneNumberOrdersRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PhoneNumberOrder.ReadOnly
  ] = ZStream.serviceWithStream(_.listPhoneNumberOrders(request))
  def listPhoneNumberOrdersPaginated(
      request: ListPhoneNumberOrdersRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumberOrdersPaginated(request))
  def batchCreateRoomMembership(
      request: BatchCreateRoomMembershipRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.batchCreateRoomMembership(request))
  def tagMeeting(
      request: TagMeetingRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagMeeting(request))
  def deleteAppInstanceAdmin(
      request: DeleteAppInstanceAdminRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAppInstanceAdmin(request))
  def deleteAccount(request: DeleteAccountRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DeleteAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccount(request))
  def batchCreateAttendee(request: BatchCreateAttendeeRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchCreateAttendeeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateAttendee(request))
  def deleteSipMediaApplication(
      request: DeleteSipMediaApplicationRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSipMediaApplication(request))
  def getAccount(request: GetAccountRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccount(request))
  def listProxySessions(request: ListProxySessionsRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ProxySession.ReadOnly
  ] = ZStream.serviceWithStream(_.listProxySessions(request))
  def listProxySessionsPaginated(request: ListProxySessionsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListProxySessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProxySessionsPaginated(request))
  def describeAppInstanceAdmin(request: DescribeAppInstanceAdminRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAppInstanceAdmin(request))
  def getEventsConfiguration(request: GetEventsConfigurationRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetEventsConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEventsConfiguration(request))
  def deleteChannel(
      request: DeleteChannelRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannel(request))
  def deleteVoiceConnectorProxy(
      request: DeleteVoiceConnectorProxyRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorProxy(request))
  def createRoomMembership(request: CreateRoomMembershipRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoomMembership(request))
  def updateAppInstanceUser(request: UpdateAppInstanceUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAppInstanceUser(request))
  def getUser(request: GetUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUser(request))
  def getPhoneNumberOrder(request: GetPhoneNumberOrderRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPhoneNumberOrder(request))
  def deleteEventsConfiguration(
      request: DeleteEventsConfigurationRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEventsConfiguration(request))
  def updateVoiceConnector(request: UpdateVoiceConnectorRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateVoiceConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVoiceConnector(request))
  def batchUpdateUser(request: BatchUpdateUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateUser(request))
  def untagAttendee(
      request: UntagAttendeeRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagAttendee(request))
  def getSipMediaApplication(request: GetSipMediaApplicationRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetSipMediaApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSipMediaApplication(request))
  def listChannelBans(
      request: ListChannelBansRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelBansResponse.ReadOnly,
    zio.aws.chime.model.ChannelBanSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listChannelBans(request))
  def listChannelBansPaginated(request: ListChannelBansRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelBansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelBansPaginated(request))
  def redactRoomMessage(request: RedactRoomMessageRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.RedactRoomMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.redactRoomMessage(request))
  def updateSipMediaApplicationCall(
      request: UpdateSipMediaApplicationCallRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSipMediaApplicationCall(request))
  def getUserSettings(request: GetUserSettingsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserSettings(request))
  def createUser(request: CreateUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def listChannelMessages(
      request: ListChannelMessagesRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly,
    zio.aws.chime.model.ChannelMessageSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listChannelMessages(request))
  def listChannelMessagesPaginated(request: ListChannelMessagesRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelMessagesPaginated(request))
  def deleteVoiceConnectorOrigination(
      request: DeleteVoiceConnectorOriginationRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorOrigination(request))
  def listPhoneNumbers(request: ListPhoneNumbersRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PhoneNumber.ReadOnly
  ] = ZStream.serviceWithStream(_.listPhoneNumbers(request))
  def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListPhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPhoneNumbersPaginated(request))
  def deleteVoiceConnectorTerminationCredentials(
      request: DeleteVoiceConnectorTerminationCredentialsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorTerminationCredentials(request))
  def associateSigninDelegateGroupsWithAccount(
      request: AssociateSigninDelegateGroupsWithAccountRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSigninDelegateGroupsWithAccount(request))
  def updatePhoneNumber(request: UpdatePhoneNumberRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePhoneNumber(request))
  def createChannelMembership(request: CreateChannelMembershipRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelMembership(request))
  def deleteMeeting(
      request: DeleteMeetingRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMeeting(request))
  def tagAttendee(
      request: TagAttendeeRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagAttendee(request))
  def inviteUsers(request: InviteUsersRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.InviteUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.inviteUsers(request))
  def getVoiceConnectorTerminationHealth(
      request: GetVoiceConnectorTerminationHealthRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorTerminationHealth(request))
  def getPhoneNumber(request: GetPhoneNumberRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPhoneNumber(request))
  def updateUserSettings(
      request: UpdateUserSettingsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUserSettings(request))
  def resetPersonalPIN(request: ResetPersonalPinRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetPersonalPIN(request))
  def createChannel(request: CreateChannelRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def describeChannelBan(request: DescribeChannelBanRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelBan(request))
  def listChannelMemberships(
      request: ListChannelMembershipsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly,
    zio.aws.chime.model.ChannelMembershipSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listChannelMemberships(request))
  def listChannelMembershipsPaginated(
      request: ListChannelMembershipsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelMembershipsPaginated(request))
  def batchCreateChannelMembership(
      request: BatchCreateChannelMembershipRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateChannelMembership(request))
  def putVoiceConnectorLoggingConfiguration(
      request: PutVoiceConnectorLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorLoggingConfiguration(request))
  def logoutUser(request: LogoutUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.LogoutUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.logoutUser(request))
  def searchAvailablePhoneNumbers(
      request: SearchAvailablePhoneNumbersRequest
  ): ZStream[zio.aws.chime.Chime, AwsError, E164PhoneNumber] =
    ZStream.serviceWithStream(_.searchAvailablePhoneNumbers(request))
  def searchAvailablePhoneNumbersPaginated(
      request: SearchAvailablePhoneNumbersRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchAvailablePhoneNumbersPaginated(request))
  def listVoiceConnectorTerminationCredentials(
      request: ListVoiceConnectorTerminationCredentialsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceConnectorTerminationCredentials(request))
  def updateChannelReadMarker(request: UpdateChannelReadMarkerRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelReadMarker(request))
  def deleteAppInstanceUser(
      request: DeleteAppInstanceUserRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAppInstanceUser(request))
  def createChannelModerator(request: CreateChannelModeratorRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelModerator(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def getAppInstanceStreamingConfigurations(
      request: GetAppInstanceStreamingConfigurationsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetAppInstanceStreamingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppInstanceStreamingConfigurations(request))
  def updateSipMediaApplication(request: UpdateSipMediaApplicationRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSipMediaApplication(request))
  def disassociatePhoneNumberFromUser(
      request: DisassociatePhoneNumberFromUserRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DisassociatePhoneNumberFromUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociatePhoneNumberFromUser(request))
  def getChannelMessage(request: GetChannelMessageRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelMessage(request))
  def putRetentionSettings(request: PutRetentionSettingsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutRetentionSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRetentionSettings(request))
  def deleteAppInstance(
      request: DeleteAppInstanceRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAppInstance(request))
  def createAppInstanceAdmin(request: CreateAppInstanceAdminRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppInstanceAdmin(request))
  def getSipRule(request: GetSipRuleRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetSipRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSipRule(request))
  def createChannelBan(request: CreateChannelBanRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateChannelBanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelBan(request))
  def untagMeeting(
      request: UntagMeetingRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagMeeting(request))
  def updatePhoneNumberSettings(
      request: UpdatePhoneNumberSettingsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updatePhoneNumberSettings(request))
  def deleteChannelMessage(
      request: DeleteChannelMessageRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelMessage(request))
  def createRoom(request: CreateRoomRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoom(request))
  def deleteRoom(
      request: DeleteRoomRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRoom(request))
  def listBots(
      request: ListBotsRequest
  ): ZStream[zio.aws.chime.Chime, AwsError, zio.aws.chime.model.Bot.ReadOnly] =
    ZStream.serviceWithStream(_.listBots(request))
  def listBotsPaginated(request: ListBotsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListBotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBotsPaginated(request))
  def getVoiceConnectorStreamingConfiguration(
      request: GetVoiceConnectorStreamingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorStreamingConfiguration(request))
  def createVoiceConnectorGroup(request: CreateVoiceConnectorGroupRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVoiceConnectorGroup(request))
  def deleteProxySession(
      request: DeleteProxySessionRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteProxySession(request))
  def redactChannelMessage(request: RedactChannelMessageRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.RedactChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.redactChannelMessage(request))
  def createBot(request: CreateBotRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBot(request))
  def listMeetings(request: ListMeetingsRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.Meeting.ReadOnly
  ] = ZStream.serviceWithStream(_.listMeetings(request))
  def listMeetingsPaginated(request: ListMeetingsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListMeetingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMeetingsPaginated(request))
  def deleteAttendee(
      request: DeleteAttendeeRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAttendee(request))
  def deleteChannelBan(
      request: DeleteChannelBanRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelBan(request))
  def listSipRules(request: ListSipRulesRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.SipRule.ReadOnly
  ] = ZStream.serviceWithStream(_.listSipRules(request))
  def listSipRulesPaginated(request: ListSipRulesRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListSipRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSipRulesPaginated(request))
  def getAttendee(request: GetAttendeeRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetAttendeeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAttendee(request))
  def describeChannelModerator(request: DescribeChannelModeratorRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelModerator(request))
  def batchUnsuspendUser(request: BatchUnsuspendUserRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUnsuspendUser(request))
  def describeChannelMembershipForAppInstanceUser(
      request: DescribeChannelMembershipForAppInstanceUserRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelMembershipForAppInstanceUser(request))
  def getGlobalSettings(): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGlobalSettings())
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def createMeeting(request: CreateMeetingRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateMeetingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMeeting(request))
  def putVoiceConnectorTermination(
      request: PutVoiceConnectorTerminationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorTermination(request))
  def startMeetingTranscription(request: StartMeetingTranscriptionRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.StartMeetingTranscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMeetingTranscription(request))
  def associatePhoneNumbersWithVoiceConnectorGroup(
      request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.associatePhoneNumbersWithVoiceConnectorGroup(request))
  def listAppInstances(request: ListAppInstancesRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.AppInstanceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAppInstances(request))
  def listAppInstancesPaginated(request: ListAppInstancesRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListAppInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppInstancesPaginated(request))
  def createMeetingDialOut(request: CreateMeetingDialOutRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMeetingDialOut(request))
  def putEventsConfiguration(request: PutEventsConfigurationRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEventsConfiguration(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def batchDeletePhoneNumber(request: BatchDeletePhoneNumberRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchDeletePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeletePhoneNumber(request))
  def createMeetingWithAttendees(
      request: CreateMeetingWithAttendeesRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMeetingWithAttendees(request))
  def disassociatePhoneNumbersFromVoiceConnectorGroup(
      request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.disassociatePhoneNumbersFromVoiceConnectorGroup(request)
  )
  def describeChannel(request: DescribeChannelRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.DescribeChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannel(request))
  def updateAccountSettings(request: UpdateAccountSettingsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccountSettings(request))
  def deleteAppInstanceStreamingConfigurations(
      request: DeleteAppInstanceStreamingConfigurationsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAppInstanceStreamingConfigurations(request))
  def listMeetingTags(request: ListMeetingTagsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListMeetingTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMeetingTags(request))
  def putVoiceConnectorTerminationCredentials(
      request: PutVoiceConnectorTerminationCredentialsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putVoiceConnectorTerminationCredentials(request))
  def createSipMediaApplicationCall(
      request: CreateSipMediaApplicationCallRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateSipMediaApplicationCallResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSipMediaApplicationCall(request))
  def getRoom(request: GetRoomRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoom(request))
  def getVoiceConnectorLoggingConfiguration(
      request: GetVoiceConnectorLoggingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorLoggingConfiguration(request))
  def deleteVoiceConnectorGroup(
      request: DeleteVoiceConnectorGroupRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorGroup(request))
  def putVoiceConnectorStreamingConfiguration(
      request: PutVoiceConnectorStreamingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorStreamingConfiguration(request))
  def getVoiceConnectorEmergencyCallingConfiguration(
      request: GetVoiceConnectorEmergencyCallingConfigurationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getVoiceConnectorEmergencyCallingConfiguration(request)
  )
  def regenerateSecurityToken(request: RegenerateSecurityTokenRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.RegenerateSecurityTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.regenerateSecurityToken(request))
  def deleteVoiceConnectorTermination(
      request: DeleteVoiceConnectorTerminationRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorTermination(request))
  def getBot(request: GetBotRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetBotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBot(request))
  def deleteVoiceConnectorStreamingConfiguration(
      request: DeleteVoiceConnectorStreamingConfigurationRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnectorStreamingConfiguration(request))
  def putVoiceConnectorOrigination(
      request: PutVoiceConnectorOriginationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putVoiceConnectorOrigination(request))
  def listChannelModerators(
      request: ListChannelModeratorsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly,
    zio.aws.chime.model.ChannelModeratorSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listChannelModerators(request))
  def listChannelModeratorsPaginated(
      request: ListChannelModeratorsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelModeratorsPaginated(request))
  def getPhoneNumberSettings(): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetPhoneNumberSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPhoneNumberSettings())
  def getAccountSettings(request: GetAccountSettingsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSettings(request))
  def createMediaCapturePipeline(
      request: CreateMediaCapturePipelineRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaCapturePipeline(request))
  def updateProxySession(request: UpdateProxySessionRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProxySession(request))
  def updateGlobalSettings(
      request: UpdateGlobalSettingsRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateGlobalSettings(request))
  def listChannelsModeratedByAppInstanceUser(
      request: ListChannelsModeratedByAppInstanceUserRequest
  ): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listChannelsModeratedByAppInstanceUser(request))
  def listChannelsModeratedByAppInstanceUserPaginated(
      request: ListChannelsModeratedByAppInstanceUserRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listChannelsModeratedByAppInstanceUserPaginated(request)
  )
  def updateChannelMessage(request: UpdateChannelMessageRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelMessage(request))
  def getMessagingSessionEndpoint(
      request: GetMessagingSessionEndpointRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetMessagingSessionEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMessagingSessionEndpoint(request))
  def listVoiceConnectorGroups(
      request: ListVoiceConnectorGroupsRequest
  ): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.VoiceConnectorGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listVoiceConnectorGroups(request))
  def listVoiceConnectorGroupsPaginated(
      request: ListVoiceConnectorGroupsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVoiceConnectorGroupsPaginated(request))
  def createSipRule(request: CreateSipRuleRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateSipRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSipRule(request))
  def listRooms(
      request: ListRoomsRequest
  ): ZStream[zio.aws.chime.Chime, AwsError, zio.aws.chime.model.Room.ReadOnly] =
    ZStream.serviceWithStream(_.listRooms(request))
  def listRoomsPaginated(request: ListRoomsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListRoomsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoomsPaginated(request))
  def getVoiceConnectorGroup(request: GetVoiceConnectorGroupRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorGroup(request))
  def createProxySession(request: CreateProxySessionRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateProxySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProxySession(request))
  def deleteMediaCapturePipeline(
      request: DeleteMediaCapturePipelineRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMediaCapturePipeline(request))
  def getAppInstanceRetentionSettings(
      request: GetAppInstanceRetentionSettingsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetAppInstanceRetentionSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppInstanceRetentionSettings(request))
  def stopMeetingTranscription(request: StopMeetingTranscriptionRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.StopMeetingTranscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopMeetingTranscription(request))
  def getVoiceConnectorOrigination(
      request: GetVoiceConnectorOriginationRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetVoiceConnectorOriginationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVoiceConnectorOrigination(request))
  def listRoomMemberships(request: ListRoomMembershipsRequest): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.RoomMembership.ReadOnly
  ] = ZStream.serviceWithStream(_.listRoomMemberships(request))
  def listRoomMembershipsPaginated(request: ListRoomMembershipsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoomMembershipsPaginated(request))
  def createSipMediaApplication(request: CreateSipMediaApplicationRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSipMediaApplication(request))
  def createAttendee(request: CreateAttendeeRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.CreateAttendeeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAttendee(request))
  def listAttendeeTags(request: ListAttendeeTagsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttendeeTags(request))
  def updateChannel(request: UpdateChannelRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
  def listMediaCapturePipelines(
      request: ListMediaCapturePipelinesRequest
  ): ZStream[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.MediaCapturePipeline.ReadOnly
  ] = ZStream.serviceWithStream(_.listMediaCapturePipelines(request))
  def listMediaCapturePipelinesPaginated(
      request: ListMediaCapturePipelinesRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMediaCapturePipelinesPaginated(request))
  def deleteVoiceConnector(
      request: DeleteVoiceConnectorRequest
  ): ZIO[zio.aws.chime.Chime, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVoiceConnector(request))
  def getRetentionSettings(request: GetRetentionSettingsRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRetentionSettings(request))
  def batchUpdatePhoneNumber(request: BatchUpdatePhoneNumberRequest): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.BatchUpdatePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdatePhoneNumber(request))
  def putAppInstanceStreamingConfigurations(
      request: PutAppInstanceStreamingConfigurationsRequest
  ): ZIO[
    zio.aws.chime.Chime,
    AwsError,
    zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAppInstanceStreamingConfigurations(request))
}
