package zio.aws.chime
import zio.aws.chime.model.BatchCreateRoomMembershipResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.chime.model.{
  CreateVoiceConnectorGroupRequest,
  UpdateVoiceConnectorRequest,
  GetVoiceConnectorOriginationRequest,
  ListChannelBansRequest,
  UpdatePhoneNumberSettingsRequest,
  CreateVoiceConnectorRequest,
  GetProxySessionRequest,
  CreateAccountRequest,
  UpdateUserSettingsRequest,
  DeleteSipMediaApplicationRequest,
  CreateBotRequest,
  ListVoiceConnectorTerminationCredentialsRequest,
  UpdateGlobalSettingsRequest,
  ListMeetingTagsRequest,
  BatchSuspendUserRequest,
  PutVoiceConnectorLoggingConfigurationRequest,
  CreateMeetingRequest,
  CreateRoomMembershipRequest,
  DeleteChannelModeratorRequest,
  BatchCreateChannelMembershipRequest,
  UpdateChannelReadMarkerRequest,
  PutAppInstanceStreamingConfigurationsRequest,
  ListChannelMessagesRequest,
  UpdateSipMediaApplicationRequest,
  DeleteVoiceConnectorOriginationRequest,
  PutRetentionSettingsRequest,
  UpdateAccountSettingsRequest,
  GetMediaCapturePipelineRequest,
  SearchAvailablePhoneNumbersRequest,
  GetBotRequest,
  UntagMeetingRequest,
  DisassociateSigninDelegateGroupsFromAccountRequest,
  DeleteEventsConfigurationRequest,
  CreateMeetingWithAttendeesRequest,
  GetChannelMessageRequest,
  RedactChannelMessageRequest,
  GetVoiceConnectorProxyRequest,
  UpdateSipMediaApplicationCallRequest,
  DeleteChannelRequest,
  DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
  ListUsersRequest,
  GetVoiceConnectorLoggingConfigurationRequest,
  StopMeetingTranscriptionRequest,
  GetSipRuleRequest,
  CreateSipMediaApplicationRequest,
  AssociatePhoneNumbersWithVoiceConnectorRequest,
  DeleteChannelMembershipRequest,
  DescribeChannelModeratedByAppInstanceUserRequest,
  ListMediaCapturePipelinesRequest,
  TagMeetingRequest,
  GetMeetingRequest,
  DeleteAppInstanceUserRequest,
  AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
  CreateChannelRequest,
  DescribeChannelMembershipRequest,
  CreateProxySessionRequest,
  DeleteVoiceConnectorTerminationRequest,
  ListAttendeeTagsRequest,
  DeleteRoomMembershipRequest,
  GetAppInstanceRetentionSettingsRequest,
  ListAttendeesRequest,
  DeleteVoiceConnectorProxyRequest,
  CreateAppInstanceAdminRequest,
  UpdatePhoneNumberRequest,
  UpdateAppInstanceUserRequest,
  GetVoiceConnectorRequest,
  ListTagsForResourceRequest,
  RedactConversationMessageRequest,
  ListBotsRequest,
  CreatePhoneNumberOrderRequest,
  UpdateAccountRequest,
  DeleteAttendeeRequest,
  CreateAppInstanceRequest,
  RedactRoomMessageRequest,
  PutSipMediaApplicationLoggingConfigurationRequest,
  UpdateChannelMessageRequest,
  InviteUsersRequest,
  PutVoiceConnectorOriginationRequest,
  CreateAppInstanceUserRequest,
  ListVoiceConnectorGroupsRequest,
  CreateChannelMembershipRequest,
  PutVoiceConnectorTerminationRequest,
  DeleteAppInstanceAdminRequest,
  GetVoiceConnectorGroupRequest,
  DeletePhoneNumberRequest,
  DeleteProxySessionRequest,
  DeleteRoomRequest,
  UpdateProxySessionRequest,
  DeleteAccountRequest,
  BatchDeletePhoneNumberRequest,
  DeleteMediaCapturePipelineRequest,
  ResetPersonalPinRequest,
  ListChannelMembershipsForAppInstanceUserRequest,
  CreateRoomRequest,
  ListSipRulesRequest,
  GetAttendeeRequest,
  DeleteChannelBanRequest,
  DisassociatePhoneNumberFromUserRequest,
  CreateMediaCapturePipelineRequest,
  ListProxySessionsRequest,
  DeleteVoiceConnectorGroupRequest,
  DescribeChannelMembershipForAppInstanceUserRequest,
  CreateUserRequest,
  RegenerateSecurityTokenRequest,
  GetAccountRequest,
  ListPhoneNumbersRequest,
  UpdateChannelRequest,
  GetUserSettingsRequest,
  DeleteVoiceConnectorRequest,
  CreateAttendeeRequest,
  GetAppInstanceStreamingConfigurationsRequest,
  PutAppInstanceRetentionSettingsRequest,
  GetEventsConfigurationRequest,
  GetPhoneNumberOrderRequest,
  CreateSipRuleRequest,
  DescribeChannelBanRequest,
  PutVoiceConnectorTerminationCredentialsRequest,
  DeleteVoiceConnectorTerminationCredentialsRequest,
  GetSipMediaApplicationRequest,
  DeleteVoiceConnectorStreamingConfigurationRequest,
  GetUserRequest,
  UpdateRoomMembershipRequest,
  ListAppInstanceUsersRequest,
  LogoutUserRequest,
  ListAccountsRequest,
  ListAppInstanceAdminsRequest,
  PutVoiceConnectorStreamingConfigurationRequest,
  DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
  DescribeAppInstanceUserRequest,
  ListChannelsRequest,
  PutVoiceConnectorEmergencyCallingConfigurationRequest,
  GetPhoneNumberRequest,
  ListChannelModeratorsRequest,
  SendChannelMessageRequest,
  ListRoomsRequest,
  UpdateVoiceConnectorGroupRequest,
  UntagResourceRequest,
  UpdateBotRequest,
  CreateSipMediaApplicationCallRequest,
  PutEventsConfigurationRequest,
  UntagAttendeeRequest,
  GetSipMediaApplicationLoggingConfigurationRequest,
  ListRoomMembershipsRequest,
  RestorePhoneNumberRequest,
  ListSupportedPhoneNumberCountriesRequest,
  CreateChannelBanRequest,
  BatchCreateAttendeeRequest,
  DescribeAppInstanceAdminRequest,
  ListMeetingsRequest,
  UpdateSipRuleRequest,
  StartMeetingTranscriptionRequest,
  CreateMeetingDialOutRequest,
  ListSipMediaApplicationsRequest,
  UpdateUserRequest,
  BatchUpdateUserRequest,
  GetMessagingSessionEndpointRequest,
  UpdateRoomRequest,
  DeleteSipRuleRequest,
  DeleteAppInstanceStreamingConfigurationsRequest,
  TagAttendeeRequest,
  DeleteChannelMessageRequest,
  ListVoiceConnectorsRequest,
  UpdateAppInstanceRequest,
  AssociatePhoneNumberWithUserRequest,
  GetVoiceConnectorTerminationHealthRequest,
  AssociateSigninDelegateGroupsWithAccountRequest,
  BatchCreateRoomMembershipRequest,
  DeleteAppInstanceRequest,
  GetVoiceConnectorStreamingConfigurationRequest,
  BatchUpdatePhoneNumberRequest,
  BatchUnsuspendUserRequest,
  ListAppInstancesRequest,
  GetVoiceConnectorEmergencyCallingConfigurationRequest,
  DescribeChannelRequest,
  GetAccountSettingsRequest,
  GetVoiceConnectorTerminationRequest,
  DescribeAppInstanceRequest,
  DeleteMeetingRequest,
  ListPhoneNumberOrdersRequest,
  CreateChannelModeratorRequest,
  PutVoiceConnectorProxyRequest,
  GetRoomRequest,
  TagResourceRequest,
  DisassociatePhoneNumbersFromVoiceConnectorRequest,
  DescribeChannelModeratorRequest,
  ListChannelMembershipsRequest,
  GetRetentionSettingsRequest,
  ListChannelsModeratedByAppInstanceUserRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.chime.model.primitives.E164PhoneNumber
import software.amazon.awssdk.services.chime.ChimeAsyncClient
object ChimeMock extends Mock[Chime] {
  object ListSipMediaApplications
      extends Stream[
        ListSipMediaApplicationsRequest,
        AwsError,
        zio.aws.chime.model.SipMediaApplication.ReadOnly
      ]
  object ListSipMediaApplicationsPaginated
      extends Effect[
        ListSipMediaApplicationsRequest,
        AwsError,
        zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly
      ]
  object RedactConversationMessage
      extends Effect[
        RedactConversationMessageRequest,
        AwsError,
        zio.aws.chime.model.RedactConversationMessageResponse.ReadOnly
      ]
  object UpdateAccount
      extends Effect[
        UpdateAccountRequest,
        AwsError,
        zio.aws.chime.model.UpdateAccountResponse.ReadOnly
      ]
  object DescribeAppInstance
      extends Effect[
        DescribeAppInstanceRequest,
        AwsError,
        zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly
      ]
  object DescribeChannelMembership
      extends Effect[
        DescribeChannelMembershipRequest,
        AwsError,
        zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly
      ]
  object ListAppInstanceUsers
      extends Effect[
        ListAppInstanceUsersRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly,
          zio.aws.chime.model.AppInstanceUserSummary.ReadOnly
        ]
      ]
  object ListAppInstanceUsersPaginated
      extends Effect[
        ListAppInstanceUsersRequest,
        AwsError,
        zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly
      ]
  object PutVoiceConnectorEmergencyCallingConfiguration
      extends Effect[
        PutVoiceConnectorEmergencyCallingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
      ]
  object UpdateRoomMembership
      extends Effect[
        UpdateRoomMembershipRequest,
        AwsError,
        zio.aws.chime.model.UpdateRoomMembershipResponse.ReadOnly
      ]
  object DeleteSipRule extends Effect[DeleteSipRuleRequest, AwsError, Unit]
  object PutVoiceConnectorProxy
      extends Effect[
        PutVoiceConnectorProxyRequest,
        AwsError,
        zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly
      ]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.chime.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.chime.model.ListUsersResponse.ReadOnly
      ]
  object CreateVoiceConnector
      extends Effect[
        CreateVoiceConnectorRequest,
        AwsError,
        zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly
      ]
  object UpdateAppInstance
      extends Effect[
        UpdateAppInstanceRequest,
        AwsError,
        zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.chime.model.UpdateUserResponse.ReadOnly
      ]
  object CreateAppInstanceUser
      extends Effect[
        CreateAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly
      ]
  object ListChannels
      extends Stream[
        ListChannelsRequest,
        AwsError,
        zio.aws.chime.model.ChannelSummary.ReadOnly
      ]
  object ListChannelsPaginated
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.chime.model.ListChannelsResponse.ReadOnly
      ]
  object RestorePhoneNumber
      extends Effect[
        RestorePhoneNumberRequest,
        AwsError,
        zio.aws.chime.model.RestorePhoneNumberResponse.ReadOnly
      ]
  object PutSipMediaApplicationLoggingConfiguration
      extends Effect[
        PutSipMediaApplicationLoggingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
      ]
  object ListAppInstanceAdmins
      extends Effect[
        ListAppInstanceAdminsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly,
          zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly
        ]
      ]
  object ListAppInstanceAdminsPaginated
      extends Effect[
        ListAppInstanceAdminsRequest,
        AwsError,
        zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly
      ]
  object GetVoiceConnector
      extends Effect[
        GetVoiceConnectorRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly
      ]
  object CreateAccount
      extends Effect[
        CreateAccountRequest,
        AwsError,
        zio.aws.chime.model.CreateAccountResponse.ReadOnly
      ]
  object DisassociatePhoneNumbersFromVoiceConnector
      extends Effect[
        DisassociatePhoneNumbersFromVoiceConnectorRequest,
        AwsError,
        zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
      ]
  object UpdateBot
      extends Effect[
        UpdateBotRequest,
        AwsError,
        zio.aws.chime.model.UpdateBotResponse.ReadOnly
      ]
  object UpdateVoiceConnectorGroup
      extends Effect[
        UpdateVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly
      ]
  object ListSupportedPhoneNumberCountries
      extends Effect[
        ListSupportedPhoneNumberCountriesRequest,
        AwsError,
        zio.aws.chime.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
      ]
  object DeleteChannelModerator
      extends Effect[DeleteChannelModeratorRequest, AwsError, Unit]
  object GetVoiceConnectorProxy
      extends Effect[
        GetVoiceConnectorProxyRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly
      ]
  object ListAttendees
      extends Stream[
        ListAttendeesRequest,
        AwsError,
        zio.aws.chime.model.Attendee.ReadOnly
      ]
  object ListAttendeesPaginated
      extends Effect[
        ListAttendeesRequest,
        AwsError,
        zio.aws.chime.model.ListAttendeesResponse.ReadOnly
      ]
  object BatchSuspendUser
      extends Effect[
        BatchSuspendUserRequest,
        AwsError,
        zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly
      ]
  object DescribeAppInstanceUser
      extends Effect[
        DescribeAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly
      ]
  object DeleteRoomMembership
      extends Effect[DeleteRoomMembershipRequest, AwsError, Unit]
  object ListVoiceConnectors
      extends Stream[
        ListVoiceConnectorsRequest,
        AwsError,
        zio.aws.chime.model.VoiceConnector.ReadOnly
      ]
  object ListVoiceConnectorsPaginated
      extends Effect[
        ListVoiceConnectorsRequest,
        AwsError,
        zio.aws.chime.model.ListVoiceConnectorsResponse.ReadOnly
      ]
  object GetMeeting
      extends Effect[
        GetMeetingRequest,
        AwsError,
        zio.aws.chime.model.GetMeetingResponse.ReadOnly
      ]
  object AssociatePhoneNumberWithUser
      extends Effect[
        AssociatePhoneNumberWithUserRequest,
        AwsError,
        zio.aws.chime.model.AssociatePhoneNumberWithUserResponse.ReadOnly
      ]
  object DescribeChannelModeratedByAppInstanceUser
      extends Effect[
        DescribeChannelModeratedByAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
      ]
  object UpdateSipRule
      extends Effect[
        UpdateSipRuleRequest,
        AwsError,
        zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly
      ]
  object ListAccounts
      extends Stream[
        ListAccountsRequest,
        AwsError,
        zio.aws.chime.model.Account.ReadOnly
      ]
  object ListAccountsPaginated
      extends Effect[
        ListAccountsRequest,
        AwsError,
        zio.aws.chime.model.ListAccountsResponse.ReadOnly
      ]
  object ListChannelMembershipsForAppInstanceUser
      extends Stream[
        ListChannelMembershipsForAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
      ]
  object ListChannelMembershipsForAppInstanceUserPaginated
      extends Effect[
        ListChannelMembershipsForAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
      ]
  object DisassociateSigninDelegateGroupsFromAccount
      extends Effect[
        DisassociateSigninDelegateGroupsFromAccountRequest,
        AwsError,
        zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse.ReadOnly
      ]
  object PutAppInstanceRetentionSettings
      extends Effect[
        PutAppInstanceRetentionSettingsRequest,
        AwsError,
        zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly
      ]
  object GetMediaCapturePipeline
      extends Effect[
        GetMediaCapturePipelineRequest,
        AwsError,
        zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly
      ]
  object GetVoiceConnectorTermination
      extends Effect[
        GetVoiceConnectorTerminationRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly
      ]
  object SendChannelMessage
      extends Effect[
        SendChannelMessageRequest,
        AwsError,
        zio.aws.chime.model.SendChannelMessageResponse.ReadOnly
      ]
  object AssociatePhoneNumbersWithVoiceConnector
      extends Effect[
        AssociatePhoneNumbersWithVoiceConnectorRequest,
        AwsError,
        zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
      ]
  object CreatePhoneNumberOrder
      extends Effect[
        CreatePhoneNumberOrderRequest,
        AwsError,
        zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly
      ]
  object DeleteVoiceConnectorEmergencyCallingConfiguration
      extends Effect[
        DeleteVoiceConnectorEmergencyCallingConfigurationRequest,
        AwsError,
        Unit
      ]
  object DeleteChannelMembership
      extends Effect[DeleteChannelMembershipRequest, AwsError, Unit]
  object CreateAppInstance
      extends Effect[
        CreateAppInstanceRequest,
        AwsError,
        zio.aws.chime.model.CreateAppInstanceResponse.ReadOnly
      ]
  object UpdateRoom
      extends Effect[
        UpdateRoomRequest,
        AwsError,
        zio.aws.chime.model.UpdateRoomResponse.ReadOnly
      ]
  object GetSipMediaApplicationLoggingConfiguration
      extends Effect[
        GetSipMediaApplicationLoggingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
      ]
  object GetProxySession
      extends Effect[
        GetProxySessionRequest,
        AwsError,
        zio.aws.chime.model.GetProxySessionResponse.ReadOnly
      ]
  object DeletePhoneNumber
      extends Effect[DeletePhoneNumberRequest, AwsError, Unit]
  object ListPhoneNumberOrders
      extends Stream[
        ListPhoneNumberOrdersRequest,
        AwsError,
        zio.aws.chime.model.PhoneNumberOrder.ReadOnly
      ]
  object ListPhoneNumberOrdersPaginated
      extends Effect[
        ListPhoneNumberOrdersRequest,
        AwsError,
        zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly
      ]
  object BatchCreateRoomMembership
      extends Effect[BatchCreateRoomMembershipRequest, AwsError, ReadOnly]
  object TagMeeting extends Effect[TagMeetingRequest, AwsError, Unit]
  object DeleteAppInstanceAdmin
      extends Effect[DeleteAppInstanceAdminRequest, AwsError, Unit]
  object DeleteAccount
      extends Effect[
        DeleteAccountRequest,
        AwsError,
        zio.aws.chime.model.DeleteAccountResponse.ReadOnly
      ]
  object BatchCreateAttendee
      extends Effect[
        BatchCreateAttendeeRequest,
        AwsError,
        zio.aws.chime.model.BatchCreateAttendeeResponse.ReadOnly
      ]
  object DeleteSipMediaApplication
      extends Effect[DeleteSipMediaApplicationRequest, AwsError, Unit]
  object GetAccount
      extends Effect[
        GetAccountRequest,
        AwsError,
        zio.aws.chime.model.GetAccountResponse.ReadOnly
      ]
  object ListProxySessions
      extends Stream[
        ListProxySessionsRequest,
        AwsError,
        zio.aws.chime.model.ProxySession.ReadOnly
      ]
  object ListProxySessionsPaginated
      extends Effect[
        ListProxySessionsRequest,
        AwsError,
        zio.aws.chime.model.ListProxySessionsResponse.ReadOnly
      ]
  object DescribeAppInstanceAdmin
      extends Effect[
        DescribeAppInstanceAdminRequest,
        AwsError,
        zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly
      ]
  object GetEventsConfiguration
      extends Effect[
        GetEventsConfigurationRequest,
        AwsError,
        zio.aws.chime.model.GetEventsConfigurationResponse.ReadOnly
      ]
  object DeleteChannel extends Effect[DeleteChannelRequest, AwsError, Unit]
  object DeleteVoiceConnectorProxy
      extends Effect[DeleteVoiceConnectorProxyRequest, AwsError, Unit]
  object CreateRoomMembership
      extends Effect[
        CreateRoomMembershipRequest,
        AwsError,
        zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly
      ]
  object UpdateAppInstanceUser
      extends Effect[
        UpdateAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly
      ]
  object GetUser
      extends Effect[
        GetUserRequest,
        AwsError,
        zio.aws.chime.model.GetUserResponse.ReadOnly
      ]
  object GetPhoneNumberOrder
      extends Effect[
        GetPhoneNumberOrderRequest,
        AwsError,
        zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly
      ]
  object DeleteEventsConfiguration
      extends Effect[DeleteEventsConfigurationRequest, AwsError, Unit]
  object UpdateVoiceConnector
      extends Effect[
        UpdateVoiceConnectorRequest,
        AwsError,
        zio.aws.chime.model.UpdateVoiceConnectorResponse.ReadOnly
      ]
  object BatchUpdateUser
      extends Effect[
        BatchUpdateUserRequest,
        AwsError,
        zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly
      ]
  object UntagAttendee extends Effect[UntagAttendeeRequest, AwsError, Unit]
  object GetSipMediaApplication
      extends Effect[
        GetSipMediaApplicationRequest,
        AwsError,
        zio.aws.chime.model.GetSipMediaApplicationResponse.ReadOnly
      ]
  object ListChannelBans
      extends Effect[ListChannelBansRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.chime.model.ListChannelBansResponse.ReadOnly,
        zio.aws.chime.model.ChannelBanSummary.ReadOnly
      ]]
  object ListChannelBansPaginated
      extends Effect[
        ListChannelBansRequest,
        AwsError,
        zio.aws.chime.model.ListChannelBansResponse.ReadOnly
      ]
  object RedactRoomMessage
      extends Effect[
        RedactRoomMessageRequest,
        AwsError,
        zio.aws.chime.model.RedactRoomMessageResponse.ReadOnly
      ]
  object UpdateSipMediaApplicationCall
      extends Effect[
        UpdateSipMediaApplicationCallRequest,
        AwsError,
        zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly
      ]
  object GetUserSettings
      extends Effect[
        GetUserSettingsRequest,
        AwsError,
        zio.aws.chime.model.GetUserSettingsResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.chime.model.CreateUserResponse.ReadOnly
      ]
  object ListChannelMessages
      extends Effect[
        ListChannelMessagesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly,
          zio.aws.chime.model.ChannelMessageSummary.ReadOnly
        ]
      ]
  object ListChannelMessagesPaginated
      extends Effect[
        ListChannelMessagesRequest,
        AwsError,
        zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly
      ]
  object DeleteVoiceConnectorOrigination
      extends Effect[DeleteVoiceConnectorOriginationRequest, AwsError, Unit]
  object ListPhoneNumbers
      extends Stream[
        ListPhoneNumbersRequest,
        AwsError,
        zio.aws.chime.model.PhoneNumber.ReadOnly
      ]
  object ListPhoneNumbersPaginated
      extends Effect[
        ListPhoneNumbersRequest,
        AwsError,
        zio.aws.chime.model.ListPhoneNumbersResponse.ReadOnly
      ]
  object DeleteVoiceConnectorTerminationCredentials
      extends Effect[
        DeleteVoiceConnectorTerminationCredentialsRequest,
        AwsError,
        Unit
      ]
  object AssociateSigninDelegateGroupsWithAccount
      extends Effect[
        AssociateSigninDelegateGroupsWithAccountRequest,
        AwsError,
        zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountResponse.ReadOnly
      ]
  object UpdatePhoneNumber
      extends Effect[
        UpdatePhoneNumberRequest,
        AwsError,
        zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly
      ]
  object CreateChannelMembership
      extends Effect[
        CreateChannelMembershipRequest,
        AwsError,
        zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly
      ]
  object DeleteMeeting extends Effect[DeleteMeetingRequest, AwsError, Unit]
  object TagAttendee extends Effect[TagAttendeeRequest, AwsError, Unit]
  object InviteUsers
      extends Effect[
        InviteUsersRequest,
        AwsError,
        zio.aws.chime.model.InviteUsersResponse.ReadOnly
      ]
  object GetVoiceConnectorTerminationHealth
      extends Effect[
        GetVoiceConnectorTerminationHealthRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
      ]
  object GetPhoneNumber
      extends Effect[
        GetPhoneNumberRequest,
        AwsError,
        zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly
      ]
  object UpdateUserSettings
      extends Effect[UpdateUserSettingsRequest, AwsError, Unit]
  object ResetPersonalPIN
      extends Effect[
        ResetPersonalPinRequest,
        AwsError,
        zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.chime.model.CreateChannelResponse.ReadOnly
      ]
  object DescribeChannelBan
      extends Effect[
        DescribeChannelBanRequest,
        AwsError,
        zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly
      ]
  object ListChannelMemberships
      extends Effect[
        ListChannelMembershipsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly,
          zio.aws.chime.model.ChannelMembershipSummary.ReadOnly
        ]
      ]
  object ListChannelMembershipsPaginated
      extends Effect[
        ListChannelMembershipsRequest,
        AwsError,
        zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly
      ]
  object BatchCreateChannelMembership
      extends Effect[
        BatchCreateChannelMembershipRequest,
        AwsError,
        zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly
      ]
  object PutVoiceConnectorLoggingConfiguration
      extends Effect[
        PutVoiceConnectorLoggingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
      ]
  object LogoutUser
      extends Effect[
        LogoutUserRequest,
        AwsError,
        zio.aws.chime.model.LogoutUserResponse.ReadOnly
      ]
  object SearchAvailablePhoneNumbers
      extends Stream[
        SearchAvailablePhoneNumbersRequest,
        AwsError,
        E164PhoneNumber
      ]
  object SearchAvailablePhoneNumbersPaginated
      extends Effect[
        SearchAvailablePhoneNumbersRequest,
        AwsError,
        zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly
      ]
  object ListVoiceConnectorTerminationCredentials
      extends Effect[
        ListVoiceConnectorTerminationCredentialsRequest,
        AwsError,
        zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
      ]
  object UpdateChannelReadMarker
      extends Effect[
        UpdateChannelReadMarkerRequest,
        AwsError,
        zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly
      ]
  object DeleteAppInstanceUser
      extends Effect[DeleteAppInstanceUserRequest, AwsError, Unit]
  object CreateChannelModerator
      extends Effect[
        CreateChannelModeratorRequest,
        AwsError,
        zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object GetAppInstanceStreamingConfigurations
      extends Effect[
        GetAppInstanceStreamingConfigurationsRequest,
        AwsError,
        zio.aws.chime.model.GetAppInstanceStreamingConfigurationsResponse.ReadOnly
      ]
  object UpdateSipMediaApplication
      extends Effect[
        UpdateSipMediaApplicationRequest,
        AwsError,
        zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly
      ]
  object DisassociatePhoneNumberFromUser
      extends Effect[
        DisassociatePhoneNumberFromUserRequest,
        AwsError,
        zio.aws.chime.model.DisassociatePhoneNumberFromUserResponse.ReadOnly
      ]
  object GetChannelMessage
      extends Effect[
        GetChannelMessageRequest,
        AwsError,
        zio.aws.chime.model.GetChannelMessageResponse.ReadOnly
      ]
  object PutRetentionSettings
      extends Effect[
        PutRetentionSettingsRequest,
        AwsError,
        zio.aws.chime.model.PutRetentionSettingsResponse.ReadOnly
      ]
  object DeleteAppInstance
      extends Effect[DeleteAppInstanceRequest, AwsError, Unit]
  object CreateAppInstanceAdmin
      extends Effect[
        CreateAppInstanceAdminRequest,
        AwsError,
        zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly
      ]
  object GetSipRule
      extends Effect[
        GetSipRuleRequest,
        AwsError,
        zio.aws.chime.model.GetSipRuleResponse.ReadOnly
      ]
  object CreateChannelBan
      extends Effect[
        CreateChannelBanRequest,
        AwsError,
        zio.aws.chime.model.CreateChannelBanResponse.ReadOnly
      ]
  object UntagMeeting extends Effect[UntagMeetingRequest, AwsError, Unit]
  object UpdatePhoneNumberSettings
      extends Effect[UpdatePhoneNumberSettingsRequest, AwsError, Unit]
  object DeleteChannelMessage
      extends Effect[DeleteChannelMessageRequest, AwsError, Unit]
  object CreateRoom
      extends Effect[
        CreateRoomRequest,
        AwsError,
        zio.aws.chime.model.CreateRoomResponse.ReadOnly
      ]
  object DeleteRoom extends Effect[DeleteRoomRequest, AwsError, Unit]
  object ListBots
      extends Stream[
        ListBotsRequest,
        AwsError,
        zio.aws.chime.model.Bot.ReadOnly
      ]
  object ListBotsPaginated
      extends Effect[
        ListBotsRequest,
        AwsError,
        zio.aws.chime.model.ListBotsResponse.ReadOnly
      ]
  object GetVoiceConnectorStreamingConfiguration
      extends Effect[
        GetVoiceConnectorStreamingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
      ]
  object CreateVoiceConnectorGroup
      extends Effect[
        CreateVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly
      ]
  object DeleteProxySession
      extends Effect[DeleteProxySessionRequest, AwsError, Unit]
  object RedactChannelMessage
      extends Effect[
        RedactChannelMessageRequest,
        AwsError,
        zio.aws.chime.model.RedactChannelMessageResponse.ReadOnly
      ]
  object CreateBot
      extends Effect[
        CreateBotRequest,
        AwsError,
        zio.aws.chime.model.CreateBotResponse.ReadOnly
      ]
  object ListMeetings
      extends Stream[
        ListMeetingsRequest,
        AwsError,
        zio.aws.chime.model.Meeting.ReadOnly
      ]
  object ListMeetingsPaginated
      extends Effect[
        ListMeetingsRequest,
        AwsError,
        zio.aws.chime.model.ListMeetingsResponse.ReadOnly
      ]
  object DeleteAttendee extends Effect[DeleteAttendeeRequest, AwsError, Unit]
  object DeleteChannelBan
      extends Effect[DeleteChannelBanRequest, AwsError, Unit]
  object ListSipRules
      extends Stream[
        ListSipRulesRequest,
        AwsError,
        zio.aws.chime.model.SipRule.ReadOnly
      ]
  object ListSipRulesPaginated
      extends Effect[
        ListSipRulesRequest,
        AwsError,
        zio.aws.chime.model.ListSipRulesResponse.ReadOnly
      ]
  object GetAttendee
      extends Effect[
        GetAttendeeRequest,
        AwsError,
        zio.aws.chime.model.GetAttendeeResponse.ReadOnly
      ]
  object DescribeChannelModerator
      extends Effect[
        DescribeChannelModeratorRequest,
        AwsError,
        zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly
      ]
  object BatchUnsuspendUser
      extends Effect[
        BatchUnsuspendUserRequest,
        AwsError,
        zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly
      ]
  object DescribeChannelMembershipForAppInstanceUser
      extends Effect[
        DescribeChannelMembershipForAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
      ]
  object GetGlobalSettings
      extends Effect[
        Unit,
        AwsError,
        zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.chime.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateMeeting
      extends Effect[
        CreateMeetingRequest,
        AwsError,
        zio.aws.chime.model.CreateMeetingResponse.ReadOnly
      ]
  object PutVoiceConnectorTermination
      extends Effect[
        PutVoiceConnectorTerminationRequest,
        AwsError,
        zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly
      ]
  object StartMeetingTranscription
      extends Effect[
        StartMeetingTranscriptionRequest,
        AwsError,
        zio.aws.chime.model.StartMeetingTranscriptionResponse.ReadOnly
      ]
  object AssociatePhoneNumbersWithVoiceConnectorGroup
      extends Effect[
        AssociatePhoneNumbersWithVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
      ]
  object ListAppInstances
      extends Stream[
        ListAppInstancesRequest,
        AwsError,
        zio.aws.chime.model.AppInstanceSummary.ReadOnly
      ]
  object ListAppInstancesPaginated
      extends Effect[
        ListAppInstancesRequest,
        AwsError,
        zio.aws.chime.model.ListAppInstancesResponse.ReadOnly
      ]
  object CreateMeetingDialOut
      extends Effect[
        CreateMeetingDialOutRequest,
        AwsError,
        zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly
      ]
  object PutEventsConfiguration
      extends Effect[
        PutEventsConfigurationRequest,
        AwsError,
        zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object BatchDeletePhoneNumber
      extends Effect[
        BatchDeletePhoneNumberRequest,
        AwsError,
        zio.aws.chime.model.BatchDeletePhoneNumberResponse.ReadOnly
      ]
  object CreateMeetingWithAttendees
      extends Effect[
        CreateMeetingWithAttendeesRequest,
        AwsError,
        zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly
      ]
  object DisassociatePhoneNumbersFromVoiceConnectorGroup
      extends Effect[
        DisassociatePhoneNumbersFromVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
      ]
  object DescribeChannel
      extends Effect[
        DescribeChannelRequest,
        AwsError,
        zio.aws.chime.model.DescribeChannelResponse.ReadOnly
      ]
  object UpdateAccountSettings
      extends Effect[
        UpdateAccountSettingsRequest,
        AwsError,
        zio.aws.chime.model.UpdateAccountSettingsResponse.ReadOnly
      ]
  object DeleteAppInstanceStreamingConfigurations
      extends Effect[
        DeleteAppInstanceStreamingConfigurationsRequest,
        AwsError,
        Unit
      ]
  object ListMeetingTags
      extends Effect[
        ListMeetingTagsRequest,
        AwsError,
        zio.aws.chime.model.ListMeetingTagsResponse.ReadOnly
      ]
  object PutVoiceConnectorTerminationCredentials
      extends Effect[
        PutVoiceConnectorTerminationCredentialsRequest,
        AwsError,
        Unit
      ]
  object CreateSipMediaApplicationCall
      extends Effect[
        CreateSipMediaApplicationCallRequest,
        AwsError,
        zio.aws.chime.model.CreateSipMediaApplicationCallResponse.ReadOnly
      ]
  object GetRoom
      extends Effect[
        GetRoomRequest,
        AwsError,
        zio.aws.chime.model.GetRoomResponse.ReadOnly
      ]
  object GetVoiceConnectorLoggingConfiguration
      extends Effect[
        GetVoiceConnectorLoggingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
      ]
  object DeleteVoiceConnectorGroup
      extends Effect[DeleteVoiceConnectorGroupRequest, AwsError, Unit]
  object PutVoiceConnectorStreamingConfiguration
      extends Effect[
        PutVoiceConnectorStreamingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
      ]
  object GetVoiceConnectorEmergencyCallingConfiguration
      extends Effect[
        GetVoiceConnectorEmergencyCallingConfigurationRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
      ]
  object RegenerateSecurityToken
      extends Effect[
        RegenerateSecurityTokenRequest,
        AwsError,
        zio.aws.chime.model.RegenerateSecurityTokenResponse.ReadOnly
      ]
  object DeleteVoiceConnectorTermination
      extends Effect[DeleteVoiceConnectorTerminationRequest, AwsError, Unit]
  object GetBot
      extends Effect[
        GetBotRequest,
        AwsError,
        zio.aws.chime.model.GetBotResponse.ReadOnly
      ]
  object DeleteVoiceConnectorStreamingConfiguration
      extends Effect[
        DeleteVoiceConnectorStreamingConfigurationRequest,
        AwsError,
        Unit
      ]
  object PutVoiceConnectorOrigination
      extends Effect[
        PutVoiceConnectorOriginationRequest,
        AwsError,
        zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly
      ]
  object ListChannelModerators
      extends Effect[
        ListChannelModeratorsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly,
          zio.aws.chime.model.ChannelModeratorSummary.ReadOnly
        ]
      ]
  object ListChannelModeratorsPaginated
      extends Effect[
        ListChannelModeratorsRequest,
        AwsError,
        zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly
      ]
  object GetPhoneNumberSettings
      extends Effect[
        Unit,
        AwsError,
        zio.aws.chime.model.GetPhoneNumberSettingsResponse.ReadOnly
      ]
  object GetAccountSettings
      extends Effect[
        GetAccountSettingsRequest,
        AwsError,
        zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly
      ]
  object CreateMediaCapturePipeline
      extends Effect[
        CreateMediaCapturePipelineRequest,
        AwsError,
        zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly
      ]
  object UpdateProxySession
      extends Effect[
        UpdateProxySessionRequest,
        AwsError,
        zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly
      ]
  object UpdateGlobalSettings
      extends Effect[UpdateGlobalSettingsRequest, AwsError, Unit]
  object ListChannelsModeratedByAppInstanceUser
      extends Stream[
        ListChannelsModeratedByAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
      ]
  object ListChannelsModeratedByAppInstanceUserPaginated
      extends Effect[
        ListChannelsModeratedByAppInstanceUserRequest,
        AwsError,
        zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
      ]
  object UpdateChannelMessage
      extends Effect[
        UpdateChannelMessageRequest,
        AwsError,
        zio.aws.chime.model.UpdateChannelMessageResponse.ReadOnly
      ]
  object GetMessagingSessionEndpoint
      extends Effect[
        GetMessagingSessionEndpointRequest,
        AwsError,
        zio.aws.chime.model.GetMessagingSessionEndpointResponse.ReadOnly
      ]
  object ListVoiceConnectorGroups
      extends Stream[
        ListVoiceConnectorGroupsRequest,
        AwsError,
        zio.aws.chime.model.VoiceConnectorGroup.ReadOnly
      ]
  object ListVoiceConnectorGroupsPaginated
      extends Effect[
        ListVoiceConnectorGroupsRequest,
        AwsError,
        zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly
      ]
  object CreateSipRule
      extends Effect[
        CreateSipRuleRequest,
        AwsError,
        zio.aws.chime.model.CreateSipRuleResponse.ReadOnly
      ]
  object ListRooms
      extends Stream[
        ListRoomsRequest,
        AwsError,
        zio.aws.chime.model.Room.ReadOnly
      ]
  object ListRoomsPaginated
      extends Effect[
        ListRoomsRequest,
        AwsError,
        zio.aws.chime.model.ListRoomsResponse.ReadOnly
      ]
  object GetVoiceConnectorGroup
      extends Effect[
        GetVoiceConnectorGroupRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorGroupResponse.ReadOnly
      ]
  object CreateProxySession
      extends Effect[
        CreateProxySessionRequest,
        AwsError,
        zio.aws.chime.model.CreateProxySessionResponse.ReadOnly
      ]
  object DeleteMediaCapturePipeline
      extends Effect[DeleteMediaCapturePipelineRequest, AwsError, Unit]
  object GetAppInstanceRetentionSettings
      extends Effect[
        GetAppInstanceRetentionSettingsRequest,
        AwsError,
        zio.aws.chime.model.GetAppInstanceRetentionSettingsResponse.ReadOnly
      ]
  object StopMeetingTranscription
      extends Effect[
        StopMeetingTranscriptionRequest,
        AwsError,
        zio.aws.chime.model.StopMeetingTranscriptionResponse.ReadOnly
      ]
  object GetVoiceConnectorOrigination
      extends Effect[
        GetVoiceConnectorOriginationRequest,
        AwsError,
        zio.aws.chime.model.GetVoiceConnectorOriginationResponse.ReadOnly
      ]
  object ListRoomMemberships
      extends Stream[
        ListRoomMembershipsRequest,
        AwsError,
        zio.aws.chime.model.RoomMembership.ReadOnly
      ]
  object ListRoomMembershipsPaginated
      extends Effect[
        ListRoomMembershipsRequest,
        AwsError,
        zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly
      ]
  object CreateSipMediaApplication
      extends Effect[
        CreateSipMediaApplicationRequest,
        AwsError,
        zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly
      ]
  object CreateAttendee
      extends Effect[
        CreateAttendeeRequest,
        AwsError,
        zio.aws.chime.model.CreateAttendeeResponse.ReadOnly
      ]
  object ListAttendeeTags
      extends Effect[
        ListAttendeeTagsRequest,
        AwsError,
        zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly
      ]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.chime.model.UpdateChannelResponse.ReadOnly
      ]
  object ListMediaCapturePipelines
      extends Stream[
        ListMediaCapturePipelinesRequest,
        AwsError,
        zio.aws.chime.model.MediaCapturePipeline.ReadOnly
      ]
  object ListMediaCapturePipelinesPaginated
      extends Effect[
        ListMediaCapturePipelinesRequest,
        AwsError,
        zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly
      ]
  object DeleteVoiceConnector
      extends Effect[DeleteVoiceConnectorRequest, AwsError, Unit]
  object GetRetentionSettings
      extends Effect[
        GetRetentionSettingsRequest,
        AwsError,
        zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly
      ]
  object BatchUpdatePhoneNumber
      extends Effect[
        BatchUpdatePhoneNumberRequest,
        AwsError,
        zio.aws.chime.model.BatchUpdatePhoneNumberResponse.ReadOnly
      ]
  object PutAppInstanceStreamingConfigurations
      extends Effect[
        PutAppInstanceStreamingConfigurationsRequest,
        AwsError,
        zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Chime] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Chime {
          val api: ChimeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Chime = this
          def listSipMediaApplications(
              request: ListSipMediaApplicationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.SipMediaApplication.ReadOnly
          ] = rts.unsafeRun(proxy(ListSipMediaApplications, request))
          def listSipMediaApplicationsPaginated(
              request: ListSipMediaApplicationsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListSipMediaApplicationsResponse.ReadOnly
          ] = proxy(ListSipMediaApplicationsPaginated, request)
          def redactConversationMessage(
              request: RedactConversationMessageRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.RedactConversationMessageResponse.ReadOnly
          ] = proxy(RedactConversationMessage, request)
          def updateAccount(
              request: UpdateAccountRequest
          ): IO[AwsError, zio.aws.chime.model.UpdateAccountResponse.ReadOnly] =
            proxy(UpdateAccount, request)
          def describeAppInstance(request: DescribeAppInstanceRequest): IO[
            AwsError,
            zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly
          ] = proxy(DescribeAppInstance, request)
          def describeChannelMembership(
              request: DescribeChannelMembershipRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly
          ] = proxy(DescribeChannelMembership, request)
          def listAppInstanceUsers(
              request: ListAppInstanceUsersRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly,
            zio.aws.chime.model.AppInstanceUserSummary.ReadOnly
          ]] = proxy(ListAppInstanceUsers, request)
          def listAppInstanceUsersPaginated(
              request: ListAppInstanceUsersRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListAppInstanceUsersResponse.ReadOnly
          ] = proxy(ListAppInstanceUsersPaginated, request)
          def putVoiceConnectorEmergencyCallingConfiguration(
              request: PutVoiceConnectorEmergencyCallingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
          ] = proxy(PutVoiceConnectorEmergencyCallingConfiguration, request)
          def updateRoomMembership(request: UpdateRoomMembershipRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateRoomMembershipResponse.ReadOnly
          ] = proxy(UpdateRoomMembership, request)
          def deleteSipRule(request: DeleteSipRuleRequest): IO[AwsError, Unit] =
            proxy(DeleteSipRule, request)
          def putVoiceConnectorProxy(
              request: PutVoiceConnectorProxyRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutVoiceConnectorProxyResponse.ReadOnly
          ] = proxy(PutVoiceConnectorProxy, request)
          def listUsers(
              request: ListUsersRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.User.ReadOnly] =
            rts.unsafeRun(proxy(ListUsers, request))
          def listUsersPaginated(
              request: ListUsersRequest
          ): IO[AwsError, zio.aws.chime.model.ListUsersResponse.ReadOnly] =
            proxy(ListUsersPaginated, request)
          def createVoiceConnector(request: CreateVoiceConnectorRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly
          ] = proxy(CreateVoiceConnector, request)
          def updateAppInstance(request: UpdateAppInstanceRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly
          ] = proxy(UpdateAppInstance, request)
          def updateUser(
              request: UpdateUserRequest
          ): IO[AwsError, zio.aws.chime.model.UpdateUserResponse.ReadOnly] =
            proxy(UpdateUser, request)
          def createAppInstanceUser(request: CreateAppInstanceUserRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly
          ] = proxy(CreateAppInstanceUser, request)
          def listChannels(request: ListChannelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.ChannelSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListChannels, request))
          def listChannelsPaginated(
              request: ListChannelsRequest
          ): IO[AwsError, zio.aws.chime.model.ListChannelsResponse.ReadOnly] =
            proxy(ListChannelsPaginated, request)
          def restorePhoneNumber(request: RestorePhoneNumberRequest): IO[
            AwsError,
            zio.aws.chime.model.RestorePhoneNumberResponse.ReadOnly
          ] = proxy(RestorePhoneNumber, request)
          def putSipMediaApplicationLoggingConfiguration(
              request: PutSipMediaApplicationLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly
          ] = proxy(PutSipMediaApplicationLoggingConfiguration, request)
          def listAppInstanceAdmins(
              request: ListAppInstanceAdminsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly,
            zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly
          ]] = proxy(ListAppInstanceAdmins, request)
          def listAppInstanceAdminsPaginated(
              request: ListAppInstanceAdminsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListAppInstanceAdminsResponse.ReadOnly
          ] = proxy(ListAppInstanceAdminsPaginated, request)
          def getVoiceConnector(request: GetVoiceConnectorRequest): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorResponse.ReadOnly
          ] = proxy(GetVoiceConnector, request)
          def createAccount(
              request: CreateAccountRequest
          ): IO[AwsError, zio.aws.chime.model.CreateAccountResponse.ReadOnly] =
            proxy(CreateAccount, request)
          def disassociatePhoneNumbersFromVoiceConnector(
              request: DisassociatePhoneNumbersFromVoiceConnectorRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly
          ] = proxy(DisassociatePhoneNumbersFromVoiceConnector, request)
          def updateBot(
              request: UpdateBotRequest
          ): IO[AwsError, zio.aws.chime.model.UpdateBotResponse.ReadOnly] =
            proxy(UpdateBot, request)
          def updateVoiceConnectorGroup(
              request: UpdateVoiceConnectorGroupRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly
          ] = proxy(UpdateVoiceConnectorGroup, request)
          def listSupportedPhoneNumberCountries(
              request: ListSupportedPhoneNumberCountriesRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListSupportedPhoneNumberCountriesResponse.ReadOnly
          ] = proxy(ListSupportedPhoneNumberCountries, request)
          def deleteChannelModerator(
              request: DeleteChannelModeratorRequest
          ): IO[AwsError, Unit] = proxy(DeleteChannelModerator, request)
          def getVoiceConnectorProxy(
              request: GetVoiceConnectorProxyRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorProxyResponse.ReadOnly
          ] = proxy(GetVoiceConnectorProxy, request)
          def listAttendees(
              request: ListAttendeesRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.Attendee.ReadOnly] =
            rts.unsafeRun(proxy(ListAttendees, request))
          def listAttendeesPaginated(
              request: ListAttendeesRequest
          ): IO[AwsError, zio.aws.chime.model.ListAttendeesResponse.ReadOnly] =
            proxy(ListAttendeesPaginated, request)
          def batchSuspendUser(request: BatchSuspendUserRequest): IO[
            AwsError,
            zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly
          ] = proxy(BatchSuspendUser, request)
          def describeAppInstanceUser(
              request: DescribeAppInstanceUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly
          ] = proxy(DescribeAppInstanceUser, request)
          def deleteRoomMembership(
              request: DeleteRoomMembershipRequest
          ): IO[AwsError, Unit] = proxy(DeleteRoomMembership, request)
          def listVoiceConnectors(request: ListVoiceConnectorsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.VoiceConnector.ReadOnly
          ] = rts.unsafeRun(proxy(ListVoiceConnectors, request))
          def listVoiceConnectorsPaginated(
              request: ListVoiceConnectorsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListVoiceConnectorsResponse.ReadOnly
          ] = proxy(ListVoiceConnectorsPaginated, request)
          def getMeeting(
              request: GetMeetingRequest
          ): IO[AwsError, zio.aws.chime.model.GetMeetingResponse.ReadOnly] =
            proxy(GetMeeting, request)
          def associatePhoneNumberWithUser(
              request: AssociatePhoneNumberWithUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.AssociatePhoneNumberWithUserResponse.ReadOnly
          ] = proxy(AssociatePhoneNumberWithUser, request)
          def describeChannelModeratedByAppInstanceUser(
              request: DescribeChannelModeratedByAppInstanceUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
          ] = proxy(DescribeChannelModeratedByAppInstanceUser, request)
          def updateSipRule(
              request: UpdateSipRuleRequest
          ): IO[AwsError, zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly] =
            proxy(UpdateSipRule, request)
          def listAccounts(
              request: ListAccountsRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.Account.ReadOnly] =
            rts.unsafeRun(proxy(ListAccounts, request))
          def listAccountsPaginated(
              request: ListAccountsRequest
          ): IO[AwsError, zio.aws.chime.model.ListAccountsResponse.ReadOnly] =
            proxy(ListAccountsPaginated, request)
          def listChannelMembershipsForAppInstanceUser(
              request: ListChannelMembershipsForAppInstanceUserRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
          ] = rts
            .unsafeRun(proxy(ListChannelMembershipsForAppInstanceUser, request))
          def listChannelMembershipsForAppInstanceUserPaginated(
              request: ListChannelMembershipsForAppInstanceUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
          ] = proxy(ListChannelMembershipsForAppInstanceUserPaginated, request)
          def disassociateSigninDelegateGroupsFromAccount(
              request: DisassociateSigninDelegateGroupsFromAccountRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse.ReadOnly
          ] = proxy(DisassociateSigninDelegateGroupsFromAccount, request)
          def putAppInstanceRetentionSettings(
              request: PutAppInstanceRetentionSettingsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutAppInstanceRetentionSettingsResponse.ReadOnly
          ] = proxy(PutAppInstanceRetentionSettings, request)
          def getMediaCapturePipeline(
              request: GetMediaCapturePipelineRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly
          ] = proxy(GetMediaCapturePipeline, request)
          def getVoiceConnectorTermination(
              request: GetVoiceConnectorTerminationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorTerminationResponse.ReadOnly
          ] = proxy(GetVoiceConnectorTermination, request)
          def sendChannelMessage(request: SendChannelMessageRequest): IO[
            AwsError,
            zio.aws.chime.model.SendChannelMessageResponse.ReadOnly
          ] = proxy(SendChannelMessage, request)
          def associatePhoneNumbersWithVoiceConnector(
              request: AssociatePhoneNumbersWithVoiceConnectorRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse.ReadOnly
          ] = proxy(AssociatePhoneNumbersWithVoiceConnector, request)
          def createPhoneNumberOrder(
              request: CreatePhoneNumberOrderRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly
          ] = proxy(CreatePhoneNumberOrder, request)
          def deleteVoiceConnectorEmergencyCallingConfiguration(
              request: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteVoiceConnectorEmergencyCallingConfiguration, request)
          def deleteChannelMembership(
              request: DeleteChannelMembershipRequest
          ): IO[AwsError, Unit] = proxy(DeleteChannelMembership, request)
          def createAppInstance(request: CreateAppInstanceRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateAppInstanceResponse.ReadOnly
          ] = proxy(CreateAppInstance, request)
          def updateRoom(
              request: UpdateRoomRequest
          ): IO[AwsError, zio.aws.chime.model.UpdateRoomResponse.ReadOnly] =
            proxy(UpdateRoom, request)
          def getSipMediaApplicationLoggingConfiguration(
              request: GetSipMediaApplicationLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly
          ] = proxy(GetSipMediaApplicationLoggingConfiguration, request)
          def getProxySession(request: GetProxySessionRequest): IO[
            AwsError,
            zio.aws.chime.model.GetProxySessionResponse.ReadOnly
          ] = proxy(GetProxySession, request)
          def deletePhoneNumber(
              request: DeletePhoneNumberRequest
          ): IO[AwsError, Unit] = proxy(DeletePhoneNumber, request)
          def listPhoneNumberOrders(
              request: ListPhoneNumberOrdersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.PhoneNumberOrder.ReadOnly
          ] = rts.unsafeRun(proxy(ListPhoneNumberOrders, request))
          def listPhoneNumberOrdersPaginated(
              request: ListPhoneNumberOrdersRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListPhoneNumberOrdersResponse.ReadOnly
          ] = proxy(ListPhoneNumberOrdersPaginated, request)
          def batchCreateRoomMembership(
              request: BatchCreateRoomMembershipRequest
          ): IO[AwsError, ReadOnly] = proxy(BatchCreateRoomMembership, request)
          def tagMeeting(request: TagMeetingRequest): IO[AwsError, Unit] =
            proxy(TagMeeting, request)
          def deleteAppInstanceAdmin(
              request: DeleteAppInstanceAdminRequest
          ): IO[AwsError, Unit] = proxy(DeleteAppInstanceAdmin, request)
          def deleteAccount(
              request: DeleteAccountRequest
          ): IO[AwsError, zio.aws.chime.model.DeleteAccountResponse.ReadOnly] =
            proxy(DeleteAccount, request)
          def batchCreateAttendee(request: BatchCreateAttendeeRequest): IO[
            AwsError,
            zio.aws.chime.model.BatchCreateAttendeeResponse.ReadOnly
          ] = proxy(BatchCreateAttendee, request)
          def deleteSipMediaApplication(
              request: DeleteSipMediaApplicationRequest
          ): IO[AwsError, Unit] = proxy(DeleteSipMediaApplication, request)
          def getAccount(
              request: GetAccountRequest
          ): IO[AwsError, zio.aws.chime.model.GetAccountResponse.ReadOnly] =
            proxy(GetAccount, request)
          def listProxySessions(
              request: ListProxySessionsRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.ProxySession.ReadOnly] =
            rts.unsafeRun(proxy(ListProxySessions, request))
          def listProxySessionsPaginated(request: ListProxySessionsRequest): IO[
            AwsError,
            zio.aws.chime.model.ListProxySessionsResponse.ReadOnly
          ] = proxy(ListProxySessionsPaginated, request)
          def describeAppInstanceAdmin(
              request: DescribeAppInstanceAdminRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly
          ] = proxy(DescribeAppInstanceAdmin, request)
          def getEventsConfiguration(
              request: GetEventsConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetEventsConfigurationResponse.ReadOnly
          ] = proxy(GetEventsConfiguration, request)
          def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit] =
            proxy(DeleteChannel, request)
          def deleteVoiceConnectorProxy(
              request: DeleteVoiceConnectorProxyRequest
          ): IO[AwsError, Unit] = proxy(DeleteVoiceConnectorProxy, request)
          def createRoomMembership(request: CreateRoomMembershipRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly
          ] = proxy(CreateRoomMembership, request)
          def updateAppInstanceUser(request: UpdateAppInstanceUserRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly
          ] = proxy(UpdateAppInstanceUser, request)
          def getUser(
              request: GetUserRequest
          ): IO[AwsError, zio.aws.chime.model.GetUserResponse.ReadOnly] =
            proxy(GetUser, request)
          def getPhoneNumberOrder(request: GetPhoneNumberOrderRequest): IO[
            AwsError,
            zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly
          ] = proxy(GetPhoneNumberOrder, request)
          def deleteEventsConfiguration(
              request: DeleteEventsConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteEventsConfiguration, request)
          def updateVoiceConnector(request: UpdateVoiceConnectorRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateVoiceConnectorResponse.ReadOnly
          ] = proxy(UpdateVoiceConnector, request)
          def batchUpdateUser(request: BatchUpdateUserRequest): IO[
            AwsError,
            zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly
          ] = proxy(BatchUpdateUser, request)
          def untagAttendee(request: UntagAttendeeRequest): IO[AwsError, Unit] =
            proxy(UntagAttendee, request)
          def getSipMediaApplication(
              request: GetSipMediaApplicationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetSipMediaApplicationResponse.ReadOnly
          ] = proxy(GetSipMediaApplication, request)
          def listChannelBans(
              request: ListChannelBansRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.chime.model.ListChannelBansResponse.ReadOnly,
            zio.aws.chime.model.ChannelBanSummary.ReadOnly
          ]] = proxy(ListChannelBans, request)
          def listChannelBansPaginated(request: ListChannelBansRequest): IO[
            AwsError,
            zio.aws.chime.model.ListChannelBansResponse.ReadOnly
          ] = proxy(ListChannelBansPaginated, request)
          def redactRoomMessage(request: RedactRoomMessageRequest): IO[
            AwsError,
            zio.aws.chime.model.RedactRoomMessageResponse.ReadOnly
          ] = proxy(RedactRoomMessage, request)
          def updateSipMediaApplicationCall(
              request: UpdateSipMediaApplicationCallRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly
          ] = proxy(UpdateSipMediaApplicationCall, request)
          def getUserSettings(request: GetUserSettingsRequest): IO[
            AwsError,
            zio.aws.chime.model.GetUserSettingsResponse.ReadOnly
          ] = proxy(GetUserSettings, request)
          def createUser(
              request: CreateUserRequest
          ): IO[AwsError, zio.aws.chime.model.CreateUserResponse.ReadOnly] =
            proxy(CreateUser, request)
          def listChannelMessages(
              request: ListChannelMessagesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly,
            zio.aws.chime.model.ChannelMessageSummary.ReadOnly
          ]] = proxy(ListChannelMessages, request)
          def listChannelMessagesPaginated(
              request: ListChannelMessagesRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListChannelMessagesResponse.ReadOnly
          ] = proxy(ListChannelMessagesPaginated, request)
          def deleteVoiceConnectorOrigination(
              request: DeleteVoiceConnectorOriginationRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteVoiceConnectorOrigination, request)
          def listPhoneNumbers(
              request: ListPhoneNumbersRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.PhoneNumber.ReadOnly] =
            rts.unsafeRun(proxy(ListPhoneNumbers, request))
          def listPhoneNumbersPaginated(request: ListPhoneNumbersRequest): IO[
            AwsError,
            zio.aws.chime.model.ListPhoneNumbersResponse.ReadOnly
          ] = proxy(ListPhoneNumbersPaginated, request)
          def deleteVoiceConnectorTerminationCredentials(
              request: DeleteVoiceConnectorTerminationCredentialsRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteVoiceConnectorTerminationCredentials, request)
          def associateSigninDelegateGroupsWithAccount(
              request: AssociateSigninDelegateGroupsWithAccountRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountResponse.ReadOnly
          ] = proxy(AssociateSigninDelegateGroupsWithAccount, request)
          def updatePhoneNumber(request: UpdatePhoneNumberRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly
          ] = proxy(UpdatePhoneNumber, request)
          def createChannelMembership(
              request: CreateChannelMembershipRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly
          ] = proxy(CreateChannelMembership, request)
          def deleteMeeting(request: DeleteMeetingRequest): IO[AwsError, Unit] =
            proxy(DeleteMeeting, request)
          def tagAttendee(request: TagAttendeeRequest): IO[AwsError, Unit] =
            proxy(TagAttendee, request)
          def inviteUsers(
              request: InviteUsersRequest
          ): IO[AwsError, zio.aws.chime.model.InviteUsersResponse.ReadOnly] =
            proxy(InviteUsers, request)
          def getVoiceConnectorTerminationHealth(
              request: GetVoiceConnectorTerminationHealthRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorTerminationHealthResponse.ReadOnly
          ] = proxy(GetVoiceConnectorTerminationHealth, request)
          def getPhoneNumber(
              request: GetPhoneNumberRequest
          ): IO[AwsError, zio.aws.chime.model.GetPhoneNumberResponse.ReadOnly] =
            proxy(GetPhoneNumber, request)
          def updateUserSettings(
              request: UpdateUserSettingsRequest
          ): IO[AwsError, Unit] = proxy(UpdateUserSettings, request)
          def resetPersonalPIN(request: ResetPersonalPinRequest): IO[
            AwsError,
            zio.aws.chime.model.ResetPersonalPinResponse.ReadOnly
          ] = proxy(ResetPersonalPIN, request)
          def createChannel(
              request: CreateChannelRequest
          ): IO[AwsError, zio.aws.chime.model.CreateChannelResponse.ReadOnly] =
            proxy(CreateChannel, request)
          def describeChannelBan(request: DescribeChannelBanRequest): IO[
            AwsError,
            zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly
          ] = proxy(DescribeChannelBan, request)
          def listChannelMemberships(
              request: ListChannelMembershipsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly,
            zio.aws.chime.model.ChannelMembershipSummary.ReadOnly
          ]] = proxy(ListChannelMemberships, request)
          def listChannelMembershipsPaginated(
              request: ListChannelMembershipsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListChannelMembershipsResponse.ReadOnly
          ] = proxy(ListChannelMembershipsPaginated, request)
          def batchCreateChannelMembership(
              request: BatchCreateChannelMembershipRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly
          ] = proxy(BatchCreateChannelMembership, request)
          def putVoiceConnectorLoggingConfiguration(
              request: PutVoiceConnectorLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutVoiceConnectorLoggingConfigurationResponse.ReadOnly
          ] = proxy(PutVoiceConnectorLoggingConfiguration, request)
          def logoutUser(
              request: LogoutUserRequest
          ): IO[AwsError, zio.aws.chime.model.LogoutUserResponse.ReadOnly] =
            proxy(LogoutUser, request)
          def searchAvailablePhoneNumbers(
              request: SearchAvailablePhoneNumbersRequest
          ): ZStream[Any, AwsError, E164PhoneNumber] =
            rts.unsafeRun(proxy(SearchAvailablePhoneNumbers, request))
          def searchAvailablePhoneNumbersPaginated(
              request: SearchAvailablePhoneNumbersRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.SearchAvailablePhoneNumbersResponse.ReadOnly
          ] = proxy(SearchAvailablePhoneNumbersPaginated, request)
          def listVoiceConnectorTerminationCredentials(
              request: ListVoiceConnectorTerminationCredentialsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListVoiceConnectorTerminationCredentialsResponse.ReadOnly
          ] = proxy(ListVoiceConnectorTerminationCredentials, request)
          def updateChannelReadMarker(
              request: UpdateChannelReadMarkerRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly
          ] = proxy(UpdateChannelReadMarker, request)
          def deleteAppInstanceUser(
              request: DeleteAppInstanceUserRequest
          ): IO[AwsError, Unit] = proxy(DeleteAppInstanceUser, request)
          def createChannelModerator(
              request: CreateChannelModeratorRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly
          ] = proxy(CreateChannelModerator, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def getAppInstanceStreamingConfigurations(
              request: GetAppInstanceStreamingConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetAppInstanceStreamingConfigurationsResponse.ReadOnly
          ] = proxy(GetAppInstanceStreamingConfigurations, request)
          def updateSipMediaApplication(
              request: UpdateSipMediaApplicationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly
          ] = proxy(UpdateSipMediaApplication, request)
          def disassociatePhoneNumberFromUser(
              request: DisassociatePhoneNumberFromUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DisassociatePhoneNumberFromUserResponse.ReadOnly
          ] = proxy(DisassociatePhoneNumberFromUser, request)
          def getChannelMessage(request: GetChannelMessageRequest): IO[
            AwsError,
            zio.aws.chime.model.GetChannelMessageResponse.ReadOnly
          ] = proxy(GetChannelMessage, request)
          def putRetentionSettings(request: PutRetentionSettingsRequest): IO[
            AwsError,
            zio.aws.chime.model.PutRetentionSettingsResponse.ReadOnly
          ] = proxy(PutRetentionSettings, request)
          def deleteAppInstance(
              request: DeleteAppInstanceRequest
          ): IO[AwsError, Unit] = proxy(DeleteAppInstance, request)
          def createAppInstanceAdmin(
              request: CreateAppInstanceAdminRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly
          ] = proxy(CreateAppInstanceAdmin, request)
          def getSipRule(
              request: GetSipRuleRequest
          ): IO[AwsError, zio.aws.chime.model.GetSipRuleResponse.ReadOnly] =
            proxy(GetSipRule, request)
          def createChannelBan(request: CreateChannelBanRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateChannelBanResponse.ReadOnly
          ] = proxy(CreateChannelBan, request)
          def untagMeeting(request: UntagMeetingRequest): IO[AwsError, Unit] =
            proxy(UntagMeeting, request)
          def updatePhoneNumberSettings(
              request: UpdatePhoneNumberSettingsRequest
          ): IO[AwsError, Unit] = proxy(UpdatePhoneNumberSettings, request)
          def deleteChannelMessage(
              request: DeleteChannelMessageRequest
          ): IO[AwsError, Unit] = proxy(DeleteChannelMessage, request)
          def createRoom(
              request: CreateRoomRequest
          ): IO[AwsError, zio.aws.chime.model.CreateRoomResponse.ReadOnly] =
            proxy(CreateRoom, request)
          def deleteRoom(request: DeleteRoomRequest): IO[AwsError, Unit] =
            proxy(DeleteRoom, request)
          def listBots(
              request: ListBotsRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.Bot.ReadOnly] =
            rts.unsafeRun(proxy(ListBots, request))
          def listBotsPaginated(
              request: ListBotsRequest
          ): IO[AwsError, zio.aws.chime.model.ListBotsResponse.ReadOnly] =
            proxy(ListBotsPaginated, request)
          def getVoiceConnectorStreamingConfiguration(
              request: GetVoiceConnectorStreamingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorStreamingConfigurationResponse.ReadOnly
          ] = proxy(GetVoiceConnectorStreamingConfiguration, request)
          def createVoiceConnectorGroup(
              request: CreateVoiceConnectorGroupRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly
          ] = proxy(CreateVoiceConnectorGroup, request)
          def deleteProxySession(
              request: DeleteProxySessionRequest
          ): IO[AwsError, Unit] = proxy(DeleteProxySession, request)
          def redactChannelMessage(request: RedactChannelMessageRequest): IO[
            AwsError,
            zio.aws.chime.model.RedactChannelMessageResponse.ReadOnly
          ] = proxy(RedactChannelMessage, request)
          def createBot(
              request: CreateBotRequest
          ): IO[AwsError, zio.aws.chime.model.CreateBotResponse.ReadOnly] =
            proxy(CreateBot, request)
          def listMeetings(
              request: ListMeetingsRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.Meeting.ReadOnly] =
            rts.unsafeRun(proxy(ListMeetings, request))
          def listMeetingsPaginated(
              request: ListMeetingsRequest
          ): IO[AwsError, zio.aws.chime.model.ListMeetingsResponse.ReadOnly] =
            proxy(ListMeetingsPaginated, request)
          def deleteAttendee(
              request: DeleteAttendeeRequest
          ): IO[AwsError, Unit] = proxy(DeleteAttendee, request)
          def deleteChannelBan(
              request: DeleteChannelBanRequest
          ): IO[AwsError, Unit] = proxy(DeleteChannelBan, request)
          def listSipRules(
              request: ListSipRulesRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.SipRule.ReadOnly] =
            rts.unsafeRun(proxy(ListSipRules, request))
          def listSipRulesPaginated(
              request: ListSipRulesRequest
          ): IO[AwsError, zio.aws.chime.model.ListSipRulesResponse.ReadOnly] =
            proxy(ListSipRulesPaginated, request)
          def getAttendee(
              request: GetAttendeeRequest
          ): IO[AwsError, zio.aws.chime.model.GetAttendeeResponse.ReadOnly] =
            proxy(GetAttendee, request)
          def describeChannelModerator(
              request: DescribeChannelModeratorRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly
          ] = proxy(DescribeChannelModerator, request)
          def batchUnsuspendUser(request: BatchUnsuspendUserRequest): IO[
            AwsError,
            zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly
          ] = proxy(BatchUnsuspendUser, request)
          def describeChannelMembershipForAppInstanceUser(
              request: DescribeChannelMembershipForAppInstanceUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
          ] = proxy(DescribeChannelMembershipForAppInstanceUser, request)
          def getGlobalSettings(): IO[
            AwsError,
            zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly
          ] = proxy(GetGlobalSettings)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.chime.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def createMeeting(
              request: CreateMeetingRequest
          ): IO[AwsError, zio.aws.chime.model.CreateMeetingResponse.ReadOnly] =
            proxy(CreateMeeting, request)
          def putVoiceConnectorTermination(
              request: PutVoiceConnectorTerminationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutVoiceConnectorTerminationResponse.ReadOnly
          ] = proxy(PutVoiceConnectorTermination, request)
          def startMeetingTranscription(
              request: StartMeetingTranscriptionRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.StartMeetingTranscriptionResponse.ReadOnly
          ] = proxy(StartMeetingTranscription, request)
          def associatePhoneNumbersWithVoiceConnectorGroup(
              request: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse.ReadOnly
          ] = proxy(AssociatePhoneNumbersWithVoiceConnectorGroup, request)
          def listAppInstances(request: ListAppInstancesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.AppInstanceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAppInstances, request))
          def listAppInstancesPaginated(request: ListAppInstancesRequest): IO[
            AwsError,
            zio.aws.chime.model.ListAppInstancesResponse.ReadOnly
          ] = proxy(ListAppInstancesPaginated, request)
          def createMeetingDialOut(request: CreateMeetingDialOutRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly
          ] = proxy(CreateMeetingDialOut, request)
          def putEventsConfiguration(
              request: PutEventsConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutEventsConfigurationResponse.ReadOnly
          ] = proxy(PutEventsConfiguration, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def batchDeletePhoneNumber(
              request: BatchDeletePhoneNumberRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.BatchDeletePhoneNumberResponse.ReadOnly
          ] = proxy(BatchDeletePhoneNumber, request)
          def createMeetingWithAttendees(
              request: CreateMeetingWithAttendeesRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly
          ] = proxy(CreateMeetingWithAttendees, request)
          def disassociatePhoneNumbersFromVoiceConnectorGroup(
              request: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly
          ] = proxy(DisassociatePhoneNumbersFromVoiceConnectorGroup, request)
          def describeChannel(request: DescribeChannelRequest): IO[
            AwsError,
            zio.aws.chime.model.DescribeChannelResponse.ReadOnly
          ] = proxy(DescribeChannel, request)
          def updateAccountSettings(request: UpdateAccountSettingsRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateAccountSettingsResponse.ReadOnly
          ] = proxy(UpdateAccountSettings, request)
          def deleteAppInstanceStreamingConfigurations(
              request: DeleteAppInstanceStreamingConfigurationsRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteAppInstanceStreamingConfigurations, request)
          def listMeetingTags(request: ListMeetingTagsRequest): IO[
            AwsError,
            zio.aws.chime.model.ListMeetingTagsResponse.ReadOnly
          ] = proxy(ListMeetingTags, request)
          def putVoiceConnectorTerminationCredentials(
              request: PutVoiceConnectorTerminationCredentialsRequest
          ): IO[AwsError, Unit] =
            proxy(PutVoiceConnectorTerminationCredentials, request)
          def createSipMediaApplicationCall(
              request: CreateSipMediaApplicationCallRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateSipMediaApplicationCallResponse.ReadOnly
          ] = proxy(CreateSipMediaApplicationCall, request)
          def getRoom(
              request: GetRoomRequest
          ): IO[AwsError, zio.aws.chime.model.GetRoomResponse.ReadOnly] =
            proxy(GetRoom, request)
          def getVoiceConnectorLoggingConfiguration(
              request: GetVoiceConnectorLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly
          ] = proxy(GetVoiceConnectorLoggingConfiguration, request)
          def deleteVoiceConnectorGroup(
              request: DeleteVoiceConnectorGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteVoiceConnectorGroup, request)
          def putVoiceConnectorStreamingConfiguration(
              request: PutVoiceConnectorStreamingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutVoiceConnectorStreamingConfigurationResponse.ReadOnly
          ] = proxy(PutVoiceConnectorStreamingConfiguration, request)
          def getVoiceConnectorEmergencyCallingConfiguration(
              request: GetVoiceConnectorEmergencyCallingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse.ReadOnly
          ] = proxy(GetVoiceConnectorEmergencyCallingConfiguration, request)
          def regenerateSecurityToken(
              request: RegenerateSecurityTokenRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.RegenerateSecurityTokenResponse.ReadOnly
          ] = proxy(RegenerateSecurityToken, request)
          def deleteVoiceConnectorTermination(
              request: DeleteVoiceConnectorTerminationRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteVoiceConnectorTermination, request)
          def getBot(
              request: GetBotRequest
          ): IO[AwsError, zio.aws.chime.model.GetBotResponse.ReadOnly] =
            proxy(GetBot, request)
          def deleteVoiceConnectorStreamingConfiguration(
              request: DeleteVoiceConnectorStreamingConfigurationRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteVoiceConnectorStreamingConfiguration, request)
          def putVoiceConnectorOrigination(
              request: PutVoiceConnectorOriginationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutVoiceConnectorOriginationResponse.ReadOnly
          ] = proxy(PutVoiceConnectorOrigination, request)
          def listChannelModerators(
              request: ListChannelModeratorsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly,
            zio.aws.chime.model.ChannelModeratorSummary.ReadOnly
          ]] = proxy(ListChannelModerators, request)
          def listChannelModeratorsPaginated(
              request: ListChannelModeratorsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListChannelModeratorsResponse.ReadOnly
          ] = proxy(ListChannelModeratorsPaginated, request)
          def getPhoneNumberSettings(): IO[
            AwsError,
            zio.aws.chime.model.GetPhoneNumberSettingsResponse.ReadOnly
          ] = proxy(GetPhoneNumberSettings)
          def getAccountSettings(request: GetAccountSettingsRequest): IO[
            AwsError,
            zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly
          ] = proxy(GetAccountSettings, request)
          def createMediaCapturePipeline(
              request: CreateMediaCapturePipelineRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly
          ] = proxy(CreateMediaCapturePipeline, request)
          def updateProxySession(request: UpdateProxySessionRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly
          ] = proxy(UpdateProxySession, request)
          def updateGlobalSettings(
              request: UpdateGlobalSettingsRequest
          ): IO[AwsError, Unit] = proxy(UpdateGlobalSettings, request)
          def listChannelsModeratedByAppInstanceUser(
              request: ListChannelsModeratedByAppInstanceUserRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
          ] = rts
            .unsafeRun(proxy(ListChannelsModeratedByAppInstanceUser, request))
          def listChannelsModeratedByAppInstanceUserPaginated(
              request: ListChannelsModeratedByAppInstanceUserRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
          ] = proxy(ListChannelsModeratedByAppInstanceUserPaginated, request)
          def updateChannelMessage(request: UpdateChannelMessageRequest): IO[
            AwsError,
            zio.aws.chime.model.UpdateChannelMessageResponse.ReadOnly
          ] = proxy(UpdateChannelMessage, request)
          def getMessagingSessionEndpoint(
              request: GetMessagingSessionEndpointRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetMessagingSessionEndpointResponse.ReadOnly
          ] = proxy(GetMessagingSessionEndpoint, request)
          def listVoiceConnectorGroups(
              request: ListVoiceConnectorGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.VoiceConnectorGroup.ReadOnly
          ] = rts.unsafeRun(proxy(ListVoiceConnectorGroups, request))
          def listVoiceConnectorGroupsPaginated(
              request: ListVoiceConnectorGroupsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListVoiceConnectorGroupsResponse.ReadOnly
          ] = proxy(ListVoiceConnectorGroupsPaginated, request)
          def createSipRule(
              request: CreateSipRuleRequest
          ): IO[AwsError, zio.aws.chime.model.CreateSipRuleResponse.ReadOnly] =
            proxy(CreateSipRule, request)
          def listRooms(
              request: ListRoomsRequest
          ): ZStream[Any, AwsError, zio.aws.chime.model.Room.ReadOnly] =
            rts.unsafeRun(proxy(ListRooms, request))
          def listRoomsPaginated(
              request: ListRoomsRequest
          ): IO[AwsError, zio.aws.chime.model.ListRoomsResponse.ReadOnly] =
            proxy(ListRoomsPaginated, request)
          def getVoiceConnectorGroup(
              request: GetVoiceConnectorGroupRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorGroupResponse.ReadOnly
          ] = proxy(GetVoiceConnectorGroup, request)
          def createProxySession(request: CreateProxySessionRequest): IO[
            AwsError,
            zio.aws.chime.model.CreateProxySessionResponse.ReadOnly
          ] = proxy(CreateProxySession, request)
          def deleteMediaCapturePipeline(
              request: DeleteMediaCapturePipelineRequest
          ): IO[AwsError, Unit] = proxy(DeleteMediaCapturePipeline, request)
          def getAppInstanceRetentionSettings(
              request: GetAppInstanceRetentionSettingsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetAppInstanceRetentionSettingsResponse.ReadOnly
          ] = proxy(GetAppInstanceRetentionSettings, request)
          def stopMeetingTranscription(
              request: StopMeetingTranscriptionRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.StopMeetingTranscriptionResponse.ReadOnly
          ] = proxy(StopMeetingTranscription, request)
          def getVoiceConnectorOrigination(
              request: GetVoiceConnectorOriginationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.GetVoiceConnectorOriginationResponse.ReadOnly
          ] = proxy(GetVoiceConnectorOrigination, request)
          def listRoomMemberships(request: ListRoomMembershipsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.RoomMembership.ReadOnly
          ] = rts.unsafeRun(proxy(ListRoomMemberships, request))
          def listRoomMembershipsPaginated(
              request: ListRoomMembershipsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListRoomMembershipsResponse.ReadOnly
          ] = proxy(ListRoomMembershipsPaginated, request)
          def createSipMediaApplication(
              request: CreateSipMediaApplicationRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly
          ] = proxy(CreateSipMediaApplication, request)
          def createAttendee(
              request: CreateAttendeeRequest
          ): IO[AwsError, zio.aws.chime.model.CreateAttendeeResponse.ReadOnly] =
            proxy(CreateAttendee, request)
          def listAttendeeTags(request: ListAttendeeTagsRequest): IO[
            AwsError,
            zio.aws.chime.model.ListAttendeeTagsResponse.ReadOnly
          ] = proxy(ListAttendeeTags, request)
          def updateChannel(
              request: UpdateChannelRequest
          ): IO[AwsError, zio.aws.chime.model.UpdateChannelResponse.ReadOnly] =
            proxy(UpdateChannel, request)
          def listMediaCapturePipelines(
              request: ListMediaCapturePipelinesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.chime.model.MediaCapturePipeline.ReadOnly
          ] = rts.unsafeRun(proxy(ListMediaCapturePipelines, request))
          def listMediaCapturePipelinesPaginated(
              request: ListMediaCapturePipelinesRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.ListMediaCapturePipelinesResponse.ReadOnly
          ] = proxy(ListMediaCapturePipelinesPaginated, request)
          def deleteVoiceConnector(
              request: DeleteVoiceConnectorRequest
          ): IO[AwsError, Unit] = proxy(DeleteVoiceConnector, request)
          def getRetentionSettings(request: GetRetentionSettingsRequest): IO[
            AwsError,
            zio.aws.chime.model.GetRetentionSettingsResponse.ReadOnly
          ] = proxy(GetRetentionSettings, request)
          def batchUpdatePhoneNumber(
              request: BatchUpdatePhoneNumberRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.BatchUpdatePhoneNumberResponse.ReadOnly
          ] = proxy(BatchUpdatePhoneNumber, request)
          def putAppInstanceStreamingConfigurations(
              request: PutAppInstanceStreamingConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.chime.model.PutAppInstanceStreamingConfigurationsResponse.ReadOnly
          ] = proxy(PutAppInstanceStreamingConfigurations, request)
        }
      }
    }
  }
}
