package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.Iso8601Timestamp
import scala.jdk.CollectionConverters._
final case class Account(
    awsAccountId: String,
    accountId: String,
    name: String,
    accountType: Optional[zio.aws.chime.model.AccountType] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    defaultLicense: Optional[zio.aws.chime.model.License] = Optional.Absent,
    supportedLicenses: Optional[Iterable[zio.aws.chime.model.License]] =
      Optional.Absent,
    accountStatus: Optional[zio.aws.chime.model.AccountStatus] =
      Optional.Absent,
    signinDelegateGroups: Optional[
      Iterable[zio.aws.chime.model.SigninDelegateGroup]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Account = {
    import Account.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Account
      .builder()
      .awsAccountId(awsAccountId: java.lang.String)
      .accountId(accountId: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(accountType.map(value => value.unwrap))(_.accountType)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(defaultLicense.map(value => value.unwrap))(
        _.defaultLicense
      )
      .optionallyWith(
        supportedLicenses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedLicensesWithStrings)
      .optionallyWith(accountStatus.map(value => value.unwrap))(_.accountStatus)
      .optionallyWith(
        signinDelegateGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signinDelegateGroups)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Account.ReadOnly =
    zio.aws.chime.model.Account.wrap(buildAwsValue())
}
object Account {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Account] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Account = zio.aws.chime.model.Account(
      awsAccountId,
      accountId,
      name,
      accountType.map(value => value),
      createdTimestamp.map(value => value),
      defaultLicense.map(value => value),
      supportedLicenses.map(value => value),
      accountStatus.map(value => value),
      signinDelegateGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def awsAccountId: String
    def accountId: String
    def name: String
    def accountType: Optional[zio.aws.chime.model.AccountType]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def defaultLicense: Optional[zio.aws.chime.model.License]
    def supportedLicenses: Optional[List[zio.aws.chime.model.License]]
    def accountStatus: Optional[zio.aws.chime.model.AccountStatus]
    def signinDelegateGroups
        : Optional[List[zio.aws.chime.model.SigninDelegateGroup.ReadOnly]]
    def getAwsAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(awsAccountId)
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getAccountType: ZIO[Any, AwsError, zio.aws.chime.model.AccountType] =
      AwsError.unwrapOptionField("accountType", accountType)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getDefaultLicense: ZIO[Any, AwsError, zio.aws.chime.model.License] =
      AwsError.unwrapOptionField("defaultLicense", defaultLicense)
    def getSupportedLicenses
        : ZIO[Any, AwsError, List[zio.aws.chime.model.License]] =
      AwsError.unwrapOptionField("supportedLicenses", supportedLicenses)
    def getAccountStatus
        : ZIO[Any, AwsError, zio.aws.chime.model.AccountStatus] =
      AwsError.unwrapOptionField("accountStatus", accountStatus)
    def getSigninDelegateGroups: ZIO[Any, AwsError, List[
      zio.aws.chime.model.SigninDelegateGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("signinDelegateGroups", signinDelegateGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Account
  ) extends zio.aws.chime.model.Account.ReadOnly {
    override val awsAccountId: String = impl.awsAccountId(): String
    override val accountId: String = impl.accountId(): String
    override val name: String = impl.name(): String
    override val accountType: Optional[zio.aws.chime.model.AccountType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountType())
        .map(value => zio.aws.chime.model.AccountType.wrap(value))
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val defaultLicense: Optional[zio.aws.chime.model.License] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultLicense())
        .map(value => zio.aws.chime.model.License.wrap(value))
    override val supportedLicenses
        : Optional[List[zio.aws.chime.model.License]] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedLicenses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.License.wrap(item)
        }.toList
      )
    override val accountStatus: Optional[zio.aws.chime.model.AccountStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountStatus())
        .map(value => zio.aws.chime.model.AccountStatus.wrap(value))
    override val signinDelegateGroups
        : Optional[List[zio.aws.chime.model.SigninDelegateGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signinDelegateGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.SigninDelegateGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Account
  ): zio.aws.chime.model.Account.ReadOnly = new Wrapper(impl)
}
