package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountSettings(
    disableRemoteControl: Optional[Boolean] = Optional.Absent,
    enableDialOut: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AccountSettings = {
    import AccountSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AccountSettings
      .builder()
      .optionallyWith(
        disableRemoteControl.map(value => value: java.lang.Boolean)
      )(_.disableRemoteControl)
      .optionallyWith(enableDialOut.map(value => value: java.lang.Boolean))(
        _.enableDialOut
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AccountSettings.ReadOnly =
    zio.aws.chime.model.AccountSettings.wrap(buildAwsValue())
}
object AccountSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AccountSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AccountSettings =
      zio.aws.chime.model.AccountSettings(
        disableRemoteControl.map(value => value),
        enableDialOut.map(value => value)
      )
    def disableRemoteControl: Optional[Boolean]
    def enableDialOut: Optional[Boolean]
    def getDisableRemoteControl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableRemoteControl", disableRemoteControl)
    def getEnableDialOut: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableDialOut", enableDialOut)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AccountSettings
  ) extends zio.aws.chime.model.AccountSettings.ReadOnly {
    override val disableRemoteControl: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disableRemoteControl())
      .map(value => value: Boolean)
    override val enableDialOut: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableDialOut())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AccountSettings
  ): zio.aws.chime.model.AccountSettings.ReadOnly = new Wrapper(impl)
}
