package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait AccountStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.AccountStatus
}
object AccountStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.AccountStatus
  ): zio.aws.chime.model.AccountStatus = value match {
    case software.amazon.awssdk.services.chime.model.AccountStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.AccountStatus.SUSPENDED =>
      val r = Suspended
      r
    case software.amazon.awssdk.services.chime.model.AccountStatus.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountStatus =
      software.amazon.awssdk.services.chime.model.AccountStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Suspended extends zio.aws.chime.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountStatus =
      software.amazon.awssdk.services.chime.model.AccountStatus.SUSPENDED
  }
  case object Active extends zio.aws.chime.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountStatus =
      software.amazon.awssdk.services.chime.model.AccountStatus.ACTIVE
  }
}
