package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait AccountType {
  def unwrap: software.amazon.awssdk.services.chime.model.AccountType
}
object AccountType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.AccountType
  ): zio.aws.chime.model.AccountType = value match {
    case software.amazon.awssdk.services.chime.model.AccountType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.AccountType.TEAM =>
      val r = Team
      r
    case software.amazon.awssdk.services.chime.model.AccountType.ENTERPRISE_DIRECTORY =>
      val r = EnterpriseDirectory
      r
    case software.amazon.awssdk.services.chime.model.AccountType.ENTERPRISE_LWA =>
      val r = EnterpriseLWA
      r
    case software.amazon.awssdk.services.chime.model.AccountType.ENTERPRISE_OIDC =>
      val r = EnterpriseOIDC
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountType =
      software.amazon.awssdk.services.chime.model.AccountType.UNKNOWN_TO_SDK_VERSION
  }
  case object Team extends zio.aws.chime.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountType =
      software.amazon.awssdk.services.chime.model.AccountType.TEAM
  }
  case object EnterpriseDirectory extends zio.aws.chime.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountType =
      software.amazon.awssdk.services.chime.model.AccountType.ENTERPRISE_DIRECTORY
  }
  case object EnterpriseLWA extends zio.aws.chime.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountType =
      software.amazon.awssdk.services.chime.model.AccountType.ENTERPRISE_LWA
  }
  case object EnterpriseOIDC extends zio.aws.chime.model.AccountType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AccountType =
      software.amazon.awssdk.services.chime.model.AccountType.ENTERPRISE_OIDC
  }
}
