package zio.aws.chime.model
import zio.aws.chime.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AlexaForBusinessMetadata(
    isAlexaForBusinessEnabled: Optional[Boolean] = Optional.Absent,
    alexaForBusinessRoomArn: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata = {
    import AlexaForBusinessMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata
      .builder()
      .optionallyWith(
        isAlexaForBusinessEnabled.map(value => value: java.lang.Boolean)
      )(_.isAlexaForBusinessEnabled)
      .optionallyWith(
        alexaForBusinessRoomArn.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.alexaForBusinessRoomArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly =
    zio.aws.chime.model.AlexaForBusinessMetadata.wrap(buildAwsValue())
}
object AlexaForBusinessMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AlexaForBusinessMetadata =
      zio.aws.chime.model.AlexaForBusinessMetadata(
        isAlexaForBusinessEnabled.map(value => value),
        alexaForBusinessRoomArn.map(value => value)
      )
    def isAlexaForBusinessEnabled: Optional[Boolean]
    def alexaForBusinessRoomArn: Optional[SensitiveString]
    def getIsAlexaForBusinessEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("isAlexaForBusinessEnabled", isAlexaForBusinessEnabled)
    def getAlexaForBusinessRoomArn: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField(
        "alexaForBusinessRoomArn",
        alexaForBusinessRoomArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata
  ) extends zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly {
    override val isAlexaForBusinessEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isAlexaForBusinessEnabled())
        .map(value => value: Boolean)
    override val alexaForBusinessRoomArn: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alexaForBusinessRoomArn())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata
  ): zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly = new Wrapper(impl)
}
