package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Timestamp,
  Metadata,
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class AppInstance(
    appInstanceArn: Optional[ChimeArn] = Optional.Absent,
    name: Optional[NonEmptyResourceName] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstance = {
    import AppInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstance
      .builder()
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstance.ReadOnly =
    zio.aws.chime.model.AppInstance.wrap(buildAwsValue())
}
object AppInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.AppInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstance =
      zio.aws.chime.model.AppInstance(
        appInstanceArn.map(value => value),
        name.map(value => value),
        metadata.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def appInstanceArn: Optional[ChimeArn]
    def name: Optional[NonEmptyResourceName]
    def metadata: Optional[Metadata]
    def createdTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstance
  ) extends zio.aws.chime.model.AppInstance.ReadOnly {
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val name: Optional[NonEmptyResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.NonEmptyResourceName(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstance
  ): zio.aws.chime.model.AppInstance.ReadOnly = new Wrapper(impl)
}
