package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Timestamp, ChimeArn}
import scala.jdk.CollectionConverters._
final case class AppInstanceAdmin(
    admin: Optional[zio.aws.chime.model.Identity] = Optional.Absent,
    appInstanceArn: Optional[ChimeArn] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceAdmin = {
    import AppInstanceAdmin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceAdmin
      .builder()
      .optionallyWith(admin.map(value => value.buildAwsValue()))(_.admin)
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstanceAdmin.ReadOnly =
    zio.aws.chime.model.AppInstanceAdmin.wrap(buildAwsValue())
}
object AppInstanceAdmin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceAdmin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceAdmin =
      zio.aws.chime.model.AppInstanceAdmin(
        admin.map(value => value.asEditable),
        appInstanceArn.map(value => value),
        createdTimestamp.map(value => value)
      )
    def admin: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def appInstanceArn: Optional[ChimeArn]
    def createdTimestamp: Optional[Timestamp]
    def getAdmin: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("admin", admin)
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceAdmin
  ) extends zio.aws.chime.model.AppInstanceAdmin.ReadOnly {
    override val admin: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.admin())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceAdmin
  ): zio.aws.chime.model.AppInstanceAdmin.ReadOnly = new Wrapper(impl)
}
