package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppInstanceAdminSummary(
    admin: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceAdminSummary = {
    import AppInstanceAdminSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceAdminSummary
      .builder()
      .optionallyWith(admin.map(value => value.buildAwsValue()))(_.admin)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly =
    zio.aws.chime.model.AppInstanceAdminSummary.wrap(buildAwsValue())
}
object AppInstanceAdminSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceAdminSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceAdminSummary =
      zio.aws.chime.model
        .AppInstanceAdminSummary(admin.map(value => value.asEditable))
    def admin: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getAdmin: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("admin", admin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceAdminSummary
  ) extends zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly {
    override val admin: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.admin())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceAdminSummary
  ): zio.aws.chime.model.AppInstanceAdminSummary.ReadOnly = new Wrapper(impl)
}
